/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.lock.DirectoryLockManager;
import com.atlassian.event.api.EventPublisher;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final DirectoryLockManager directoryLockManager;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;

    public DirectorySynchroniserImpl(DirectoryLockManager directoryLockManager, DirectorySynchroniserHelper directorySynchroniserHelper, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher) {
        this.directoryLockManager = directoryLockManager;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        long directoryId = remoteDirectory.getDirectoryId();
        Directory directory = this.findDirectoryById(directoryId);
        if (!directory.isActive()) {
            log.debug("Request to synchronise directory [ {} ] is returning silently because the directory is not active.", (Object)directoryId);
            return;
        }
        log.debug("request to synchronise directory [ {} ]", (Object)directoryId);
        Lock lock = this.directoryLockManager.getLock(directoryId);
        if (lock.tryLock()) {
            try {
                this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory);
                this.synchronisationStatusManager.syncStarted(directory);
                try {
                    remoteDirectory.synchroniseCache(mode, this.synchronisationStatusManager);
                }
                finally {
                    this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory);
                    this.synchronisationStatusManager.syncFinished(directoryId);
                }
            }
            finally {
                lock.unlock();
            }
            this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, (RemoteDirectory)remoteDirectory));
        } else {
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    @Override
    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.isSynchronising(directoryId);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.findDirectoryById(directoryId);
    }
}

