/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.webhook;

import com.atlassian.crowd.model.webhook.Webhook;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookPinger {
    private static final Logger logger = LoggerFactory.getLogger(WebhookPinger.class);
    private final HttpClient httpClient;

    public WebhookPinger() {
        this(new HttpClient());
    }

    public WebhookPinger(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void ping(Webhook webhook) throws IOException {
        int statusCode;
        logger.debug("Pinging Webhook {} at endpoint {}", (Object)webhook.getId(), (Object)webhook.getEndpointUrl());
        PostMethod method = new PostMethod(webhook.getEndpointUrl());
        if (webhook.getToken() != null) {
            method.setRequestHeader("Authorization", "Basic " + webhook.getToken());
        }
        if (!WebhookPinger.isSuccessfulStatusCode(statusCode = this.httpClient.executeMethod((HttpMethod)method))) {
            throw new IOException("Webhook endpoint returned status code " + statusCode);
        }
        logger.debug("Webhook {} successfully pinged at endpoint {}", (Object)webhook.getId(), (Object)webhook.getEndpointUrl());
    }

    private static boolean isSuccessfulStatusCode(int statusCode) {
        return statusCode / 100 == 2;
    }
}

