/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.cache.UserAuthorisationCache;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.AbstractDelegatingApplicationService;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.Preconditions;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CachingApplicationService
extends AbstractDelegatingApplicationService {
    private final UserAuthorisationCache userAuthorisationCache;

    public CachingApplicationService(ApplicationService applicationService, UserAuthorisationCache userAuthorisationCache) {
        super(applicationService);
        this.userAuthorisationCache = (UserAuthorisationCache)Preconditions.checkNotNull((Object)userAuthorisationCache);
    }

    @Override
    public boolean isUserAuthorised(Application application, String username) {
        Boolean allowedToAuthenticate = this.userAuthorisationCache.isPermitted(username, application.getName());
        if (allowedToAuthenticate != null) {
            return allowedToAuthenticate;
        }
        boolean permitted = this.getApplicationService().isUserAuthorised(application, username);
        if (permitted) {
            this.userAuthorisationCache.setPermitted(username, application.getName(), permitted);
        }
        return permitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User renameUser(Application application, String oldUserName, String newUsername) throws UserNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidUserException {
        try {
            User user = this.getApplicationService().renameUser(application, oldUserName, newUsername);
            return user;
        }
        finally {
            this.userAuthorisationCache.clear(oldUserName, application.getName());
            this.userAuthorisationCache.clear(newUsername, application.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(Application application, String user) throws OperationFailedException, UserNotFoundException, ApplicationPermissionException {
        try {
            this.getApplicationService().removeUser(application, user);
        }
        finally {
            this.userAuthorisationCache.clear(user, application.getName());
        }
    }
}

