/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event;

import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.model.event.AbstractOperationEvent;
import com.atlassian.crowd.model.event.OperationEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class EventStoreGeneric
implements EventStore {
    private static final String SEPARATOR = ":";
    private static final OperationEvent RESET_EVENT = new AbstractOperationEvent(null, null){};
    private static final Random random = new Random();
    private final long maxStoredEvents;
    private final ConcurrentNavigableMap<Long, OperationEvent> events = new ConcurrentSkipListMap<Long, OperationEvent>();
    private final String instanceId = String.valueOf(random.nextLong());
    private long eventNumber = 0L;

    public String getCurrentEventToken() {
        return this.toEventToken((Long)this.events.lastKey());
    }

    public EventStoreGeneric(long maxStoredEvents) {
        this.maxStoredEvents = maxStoredEvents + 1L;
        this.storeEvent(RESET_EVENT);
    }

    public Events getNewEvents(String eventToken) throws EventTokenExpiredException {
        Long currentEventNumber = this.toEventNumber(eventToken);
        Iterator eventsSince = this.events.tailMap((Object)currentEventNumber).entrySet().iterator();
        if (!eventsSince.hasNext() || !((Long)eventsSince.next().getKey()).equals(currentEventNumber)) {
            throw new EventTokenExpiredException();
        }
        ArrayList events = new ArrayList();
        Long newEventNumber = currentEventNumber;
        while (eventsSince.hasNext()) {
            Map.Entry eventEntry = eventsSince.next();
            OperationEvent event = (OperationEvent)eventEntry.getValue();
            if (event == RESET_EVENT) {
                throw new EventTokenExpiredException();
            }
            newEventNumber = (Long)eventEntry.getKey();
            events.add(eventEntry.getValue());
        }
        return new Events(events, this.toEventToken(newEventNumber));
    }

    public synchronized void storeEvent(OperationEvent event) {
        long currentEventNumber;
        if ((currentEventNumber = ++this.eventNumber) > this.maxStoredEvents) {
            this.events.remove(this.events.firstKey());
        }
        this.events.put(currentEventNumber, event);
    }

    public void invalidateEvents() {
        this.storeEvent(RESET_EVENT);
    }

    private Long toEventNumber(String eventToken) throws EventTokenExpiredException {
        String[] parts = eventToken.split(SEPARATOR);
        if (parts.length != 2 || !parts[0].equals(this.instanceId)) {
            throw new EventTokenExpiredException();
        }
        return Long.valueOf(parts[1]);
    }

    private String toEventToken(long eventNumber) {
        return this.instanceId + SEPARATOR + eventNumber;
    }
}

