/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.hybrid.LocalGroupHandler;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.directory.ldap.cache.EventTokenChangedCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.UsnChangedCacheRefresher;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.TimedOperation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCachingRemoteDirectory
implements RemoteDirectory,
SynchronisableDirectory {
    private static final Logger log = LoggerFactory.getLogger(DbCachingRemoteDirectory.class);
    public static final String INTERNAL_USER_PASSWORD = "nopass";
    private final RemoteDirectory remoteDirectory;
    private final LocalGroupHandler localGroupHandler;
    private final InternalRemoteDirectory internalDirectory;
    private final DirectoryCacheFactory directoryCacheFactory;
    private final CacheRefresher cacheRefresher;

    public DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, DirectoryCacheFactory directoryCacheFactory) {
        this(remoteDirectory, internalDirectory, directoryCacheFactory, new LocalGroupHandler(internalDirectory), DbCachingRemoteDirectory.buildCacheRefresher(remoteDirectory));
    }

    DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, DirectoryCacheFactory directoryCacheFactory, CacheRefresher cacheRefresher) {
        this(remoteDirectory, internalDirectory, directoryCacheFactory, new LocalGroupHandler(internalDirectory), cacheRefresher);
    }

    private DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, DirectoryCacheFactory directoryCacheFactory, LocalGroupHandler localGroupHandler, CacheRefresher cacheRefresher) {
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
        this.directoryCacheFactory = directoryCacheFactory;
        this.localGroupHandler = localGroupHandler;
        this.cacheRefresher = cacheRefresher;
        log.debug("DBCached directory created for directory [ " + remoteDirectory.getDirectoryId() + " ]");
    }

    private static CacheRefresher buildCacheRefresher(RemoteDirectory remoteDirectory) {
        if (remoteDirectory instanceof MicrosoftActiveDirectory) {
            return new UsnChangedCacheRefresher((MicrosoftActiveDirectory)remoteDirectory);
        }
        if (remoteDirectory instanceof RemoteCrowdDirectory) {
            return new EventTokenChangedCacheRefresher((RemoteCrowdDirectory)remoteDirectory);
        }
        return new RemoteDirectoryCacheRefresher(remoteDirectory);
    }

    public long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    public void setDirectoryId(long directoryId) {
        throw new UnsupportedOperationException("You cannot mutate the directoryID of " + this.getClass().getName());
    }

    public String getDescriptiveName() {
        return this.remoteDirectory.getDescriptiveName();
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("You cannot mutate the attributes of " + this.getClass().getName());
    }

    public User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserByName(name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserWithAttributesByName(name);
    }

    public User findUserByExternalId(String externalId) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserByExternalId(externalId);
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        if (this.remoteDirectory instanceof RemoteCrowdDirectory) {
            return this.authenticateAndUpdateInternalUser(name, credential);
        }
        return this.performAuthenticationAndUpdateAttributes(name, credential);
    }

    public Iterable<Membership> getMemberships() throws OperationFailedException {
        return this.internalDirectory.getMemberships();
    }

    private User performAuthenticationAndUpdateAttributes(String name, PasswordCredential credential) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, OperationFailedException, InvalidAuthenticationException {
        HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
        try {
            TimestampedUser internalUser;
            User authenticatedUser = this.authenticateAndUpdateInternalUser(name, credential);
            if (!this.remoteDirectory.supportsInactiveAccounts() && !(internalUser = this.internalDirectory.findUserByName(name)).isActive()) {
                throw new InactiveAccountException(name);
            }
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(0L)));
            attributesToUpdate.put("lastAuthenticated", Collections.singleton(Long.toString(System.currentTimeMillis())));
            this.storeUserAttributes(name, attributesToUpdate);
            return authenticatedUser;
        }
        catch (InvalidAuthenticationException e) {
            UserWithAttributes user = this.findUserWithAttributesByName(name);
            long currentInvalidAttempts = NumberUtils.toLong((String)user.getValue("invalidPasswordAttempts"), (long)0L);
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(++currentInvalidAttempts)));
            this.storeUserAttributes(name, attributesToUpdate);
            throw e;
        }
    }

    @VisibleForTesting
    protected User authenticateAndUpdateInternalUser(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        User remoteUser;
        block6: {
            remoteUser = this.remoteDirectory.authenticate(name, credential);
            TimestampedUser internalUser = this.findLocalUserByExternalIdOrName(remoteUser);
            try {
                if (internalUser == null) {
                    try {
                        this.addInternalUser(remoteUser);
                        break block6;
                    }
                    catch (UserAlreadyExistsException ex) {
                        throw new ConcurrentModificationException("Error while trying to add a new user '" + remoteUser.getName() + "' during login.");
                    }
                }
                if (!internalUser.getName().equals(remoteUser.getName())) {
                    internalUser = this.internalDirectory.forceRenameUser((User)internalUser, remoteUser.getName());
                }
                this.updateUserAndSetActiveFlag(remoteUser, (User)internalUser);
            }
            catch (InvalidUserException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
        }
        this.updateGroupsMembershipOnLogin(remoteUser);
        return remoteUser;
    }

    private TimestampedUser findLocalUserByExternalIdOrName(User remoteUser) {
        TimestampedUser user = this.findLocalUserByExternalId(remoteUser.getExternalId());
        if (user != null) {
            return user;
        }
        try {
            return this.internalDirectory.findUserByName(remoteUser.getName());
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    private TimestampedUser findLocalUserByExternalId(String externalId) {
        try {
            if (externalId != null && !externalId.isEmpty()) {
                return this.internalDirectory.findUserByExternalId(externalId);
            }
            return null;
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    @VisibleForTesting
    protected User updateUserAndSetActiveFlag(User remoteUser, User internalUser) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        this.preventExternalIdDuplication(remoteUser, internalUser);
        UserTemplate userTemplate = new UserTemplate(remoteUser);
        if (!this.remoteDirectory.supportsInactiveAccounts() || this.internalDirectory.isLocalUserStatusEnabled()) {
            userTemplate.setActive(internalUser.isActive());
        }
        return this.internalDirectory.updateUser(userTemplate);
    }

    @VisibleForTesting
    protected void updateGroupsMembershipOnLogin(User user) throws OperationFailedException, UserNotFoundException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        ImmutableSet userRemoteGroupNames = ImmutableSet.copyOf((Collection)this.remoteDirectory.searchGroupRelationships(query));
        ImmutableSet userLocalGroupNames = ImmutableSet.copyOf((Collection)this.internalDirectory.searchGroupRelationships(query));
        Sets.SetView groupsToAddUser = Sets.difference((Set)userRemoteGroupNames, (Set)userLocalGroupNames);
        Sets.SetView groupsToRemoveUser = Sets.difference((Set)userLocalGroupNames, (Set)userRemoteGroupNames);
        for (String groupName : groupsToAddUser) {
            try {
                this.internalDirectory.addUserToGroup(user.getName(), groupName);
            }
            catch (GroupNotFoundException e1) {
            }
            catch (ReadOnlyGroupException e1) {
                throw new RuntimeException("Failed to add user from internal directory as group " + groupName + " is read only ", e1);
            }
            catch (MembershipAlreadyExistsException e1) {
                if (!log.isDebugEnabled()) continue;
                log.debug("User " + user.getName() + " is already member of the group " + groupName);
            }
        }
        if (!groupsToRemoveUser.isEmpty()) {
            ImmutableSet<String> localGroups = this.findAllLocalGroups();
            for (String groupName : groupsToRemoveUser) {
                try {
                    if (localGroups.contains((Object)groupName)) continue;
                    this.internalDirectory.removeUserFromGroup(user.getName(), groupName);
                }
                catch (GroupNotFoundException e1) {
                }
                catch (ReadOnlyGroupException e1) {
                    throw new RuntimeException("Failed to remove user from internal directory as group " + groupName + " is read only ", e1);
                }
                catch (MembershipNotFoundException e) {
                    log.debug("User " + user.getName() + " is no longer member of the group " + groupName);
                }
            }
        }
    }

    private void preventExternalIdDuplication(User remoteUser, User internalUser) throws OperationFailedException, InvalidUserException {
        if (StringUtils.isBlank((CharSequence)remoteUser.getExternalId()) || remoteUser.getExternalId().equals(internalUser.getExternalId())) {
            return;
        }
        try {
            TimestampedUser internalUserByExternalId = this.internalDirectory.findUserByExternalId(remoteUser.getExternalId());
            if (internalUserByExternalId != null) {
                this.removeExternalId((User)internalUserByExternalId);
                log.warn("Possible user unique id duplication, removing unique id: " + internalUser.getExternalId() + " for user " + internalUser.getName());
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    private void removeExternalId(User user) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        UserTemplate userTemplate = new UserTemplate(user);
        userTemplate.setExternalId(null);
        this.internalDirectory.updateUser(userTemplate);
    }

    private ImmutableSet<String> findAllLocalGroups() throws OperationFailedException {
        if (!this.localGroupHandler.isLocalGroupsEnabled()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)this.internalDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.LOCAL).exactlyMatching((Object)true)).returningAtMost(-1)));
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        User addedUser = this.remoteDirectory.addUser(user, credential);
        return this.addInternalUser(addedUser);
    }

    private User addInternalUser(User user) throws InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        try {
            return this.internalDirectory.addUser(new UserTemplate(user), PasswordCredential.encrypted((String)INTERNAL_USER_PASSWORD));
        }
        catch (InvalidCredentialException ex) {
            throw new RuntimeException("Unexpected Credential Exception", ex);
        }
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        UserTemplate remoteUserTemplate = new UserTemplate((User)user);
        if (this.remoteDirectory.supportsInactiveAccounts() && this.isLocalUserStatusEnabled()) {
            User existingRemoteUser = this.remoteDirectory.findUserByName(user.getName());
            remoteUserTemplate.setActive(existingRemoteUser.isActive());
        }
        User updatedUser = this.remoteDirectory.updateUser(remoteUserTemplate);
        UserTemplate updatedUserTemplate = new UserTemplate(updatedUser);
        if (!this.remoteDirectory.supportsInactiveAccounts() || this.isLocalUserStatusEnabled()) {
            updatedUserTemplate.setActive(user.isActive());
        }
        return this.internalDirectory.updateUser(updatedUserTemplate);
    }

    private boolean isLocalUserStatusEnabled() {
        return this.internalDirectory.isLocalUserStatusEnabled();
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        this.remoteDirectory.updateUserCredential(username, credential);
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("Renaming users is not supported");
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.storeUserAttributes(username, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUserAttributes(username, attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        try {
            this.remoteDirectory.removeUser(name);
        }
        catch (UserNotFoundException ex) {
            this.internalDirectory.removeUser(name);
            throw ex;
        }
        this.internalDirectory.removeUser(name);
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchUsers(query);
    }

    public Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupByName(name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupWithAttributesByName(name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new InvalidGroupException((Group)group, "Group already exists in the Remote Directory");
            }
            try {
                return this.localGroupHandler.createLocalGroup(this.makeGroupTemplate((Group)group));
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        Group addedGroup = this.remoteDirectory.addGroup(group);
        return this.internalDirectory.addGroup(new GroupTemplate(addedGroup));
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new ReadOnlyGroupException(group.getName());
            }
            return this.localGroupHandler.updateLocalGroup(this.makeGroupTemplate((Group)group));
        }
        Group updatedGroup = this.remoteDirectory.updateGroup(group);
        return this.internalDirectory.updateGroup(new GroupTemplate(updatedGroup));
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Renaming groups is not supported");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.storeGroupAttributes(groupName, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.removeGroupAttributes(groupName, attributeName);
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(name)) {
                throw new ReadOnlyGroupException(name);
            }
            this.internalDirectory.removeGroup(name);
        } else {
            try {
                this.remoteDirectory.removeGroup(name);
            }
            catch (GroupNotFoundException e) {
                this.internalDirectory.removeGroup(name);
                throw e;
            }
            this.internalDirectory.removeGroup(name);
        }
    }

    private boolean isRemoteGroup(String groupName) throws OperationFailedException {
        try {
            this.remoteDirectory.findGroupByName(groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroups(query);
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        return this.internalDirectory.isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        return this.internalDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.addUserToLocalGroup(username, groupName);
        } else {
            try {
                this.remoteDirectory.addUserToGroup(username, groupName);
            }
            catch (MembershipAlreadyExistsException e) {
                this.internalDirectory.addUserToGroup(username, groupName);
                throw e;
            }
            this.internalDirectory.addUserToGroup(username, groupName);
        }
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
        } else {
            try {
                this.remoteDirectory.addGroupToGroup(childGroup, parentGroup);
            }
            catch (MembershipAlreadyExistsException e) {
                this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
                throw e;
            }
            this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.removeUserFromLocalGroup(username, groupName);
        } else {
            this.remoteDirectory.removeUserFromGroup(username, groupName);
            this.internalDirectory.removeUserFromGroup(username, groupName);
        }
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        } else {
            this.remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        }
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroupRelationships(query);
    }

    public void testConnection() throws OperationFailedException {
        this.remoteDirectory.testConnection();
    }

    public boolean supportsInactiveAccounts() {
        return this.remoteDirectory.supportsInactiveAccounts() || this.internalDirectory.isLocalUserStatusEnabled();
    }

    public boolean supportsNestedGroups() {
        return this.remoteDirectory.supportsNestedGroups();
    }

    public boolean isRolesDisabled() {
        return true;
    }

    public Set<String> getValues(String name) {
        return this.remoteDirectory.getValues(name);
    }

    public String getValue(String name) {
        return this.remoteDirectory.getValue(name);
    }

    public boolean isEmpty() {
        return this.remoteDirectory.isEmpty();
    }

    public Set<String> getKeys() {
        return this.remoteDirectory.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchroniseCache(SynchronisationMode mode, SynchronisationStatusManager synchronisationStatusManager) throws OperationFailedException {
        block10: {
            String description;
            TimedOperation operation;
            long directoryId;
            block9: {
                directoryId = this.getDirectoryId();
                SynchronisationMode synchronisedMode = null;
                operation = new TimedOperation();
                try {
                    log.info("synchronisation for directory [ " + directoryId + " ] starting");
                    DirectoryCache directoryCache = this.directoryCacheFactory.createDirectoryCache(this.remoteDirectory, this.internalDirectory);
                    if (mode == SynchronisationMode.INCREMENTAL) {
                        synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.incremental", new Serializable[0]);
                        try {
                            if (this.cacheRefresher.synchroniseChanges(directoryCache)) {
                                synchronisedMode = SynchronisationMode.INCREMENTAL;
                            }
                        }
                        catch (RuntimeException e) {
                            log.error("Incremental synchronisation was unexpectedly interrupted, falling back to a full synchronisation", (Throwable)e);
                        }
                    }
                    if (synchronisedMode == null) {
                        synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.full", new Serializable[0]);
                        this.cacheRefresher.synchroniseAll(directoryCache);
                        synchronisedMode = SynchronisationMode.FULL;
                    }
                    description = " synchronisation complete for directory [ " + directoryId + " ]";
                    if (synchronisedMode == null) break block9;
                }
                catch (Throwable throwable) {
                    String description2 = " synchronisation complete for directory [ " + directoryId + " ]";
                    if (synchronisedMode != null) {
                        log.info(operation.complete(synchronisedMode + description2));
                        synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed." + synchronisedMode, new Serializable[0]);
                    } else {
                        log.info(operation.complete("failed" + description2));
                        synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed.error", new Serializable[0]);
                    }
                    throw throwable;
                }
                log.info(operation.complete(synchronisedMode + description));
                synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed." + synchronisedMode, new Serializable[0]);
                break block10;
            }
            log.info(operation.complete("failed" + description));
            synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed.error", new Serializable[0]);
        }
    }

    public RemoteDirectory getAuthoritativeDirectory() {
        return this.remoteDirectory;
    }

    private GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }
}

