/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.support;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.support.SupportInformationBuilder;
import com.atlassian.crowd.support.SupportInformationService;
import java.util.List;

public class SupportInformationServiceImpl
implements SupportInformationService {
    final DirectoryManager directoryManager;

    public SupportInformationServiceImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public String getSupportInformation(User currentUser) {
        List directories = this.directoryManager.findAllDirectories();
        return this.getSupportInformation(directories, currentUser);
    }

    private String getSupportInformation(List<Directory> directories, User currentUser) {
        SupportInformationBuilder builder = new SupportInformationBuilder();
        if (currentUser != null) {
            builder.addHeading("Current user");
            builder.addField("Directory ID", currentUser.getDirectoryId());
            builder.addField("Username", currentUser.getName());
            builder.addField("Display name", currentUser.getDisplayName());
            builder.addField("Email address", currentUser.getEmailAddress());
            builder.newLine();
        }
        if (directories != null) {
            builder.addHeading("Directories configured");
            for (Directory directory : directories) {
                builder.addField("Directory ID", directory.getId());
                builder.addField("Name", directory.getName());
                builder.addField("Active", directory.isActive());
                builder.addField("Type", directory.getType());
                builder.addField("Created date", directory.getCreatedDate());
                builder.addField("Updated date", directory.getUpdatedDate());
                builder.addField("Allowed operations", directory.getAllowedOperations());
                builder.addField("Implementation class", directory.getImplementationClass());
                builder.addField("Encryption type", directory.getEncryptionType());
                builder.addAttributes("Attributes", directory.getAttributes());
                builder.newLine();
            }
        }
        return builder.build();
    }
}

