/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.AbstractQuartzDirectoryPollerManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobBean;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SimpleTriggerBean;

public class SpringQuartzDirectoryPollerManager
extends AbstractQuartzDirectoryPollerManager
implements ApplicationContextAware {
    private Scheduler scheduler;
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected JobDetail buildJobDetail(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(this.getJobName(poller.getDirectoryID()));
        jobDetail.setGroup("DirectoryPoller");
        jobDetail.setJobClass(DirectoryPollerJobBean.class);
        jobDetail.setVolatility(true);
        jobDetail.setJobDataMap(new JobDataMap((Map)ImmutableMap.of((Object)"DIRECTORY_POLLER", (Object)poller)));
        return jobDetail;
    }

    @Override
    protected Trigger buildTrigger(DirectoryPoller poller, JobDetail jobDetail) throws DirectoryMonitorRegistrationException {
        SimpleTriggerBean trigger = new SimpleTriggerBean();
        trigger.setName(this.getJobName(poller.getDirectoryID()));
        trigger.setGroup("DirectoryPoller");
        trigger.setVolatility(jobDetail.isVolatile());
        trigger.setJobDetail(jobDetail);
        trigger.setStartDelay(NumberUtils.toLong((String)System.getProperty("crowd.polling.startdelay"), (long)5000L));
        trigger.setRepeatInterval(poller.getPollingInterval() * 1000L);
        try {
            trigger.afterPropertiesSet();
        }
        catch (ParseException e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
        return trigger;
    }

    @Override
    protected Scheduler getScheduler() {
        if (this.scheduler == null) {
            Map schedulers = this.applicationContext.getBeansOfType(Scheduler.class);
            if (schedulers.isEmpty()) {
                throw new IllegalStateException("Could not find any scheduler in Spring context.");
            }
            if (schedulers.size() > 1) {
                throw new IllegalStateException("Found more than one scheduler in Spring context. I am confused!");
            }
            this.scheduler = (Scheduler)schedulers.values().iterator().next();
        }
        return this.scheduler;
    }
}

