/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzDirectoryPollerManager
implements DirectoryPollerManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractQuartzDirectoryPollerManager.class);
    public static final String DIRECTORY_POLLER_JOB_GROUP = "DirectoryPoller";

    @Override
    public void addPoller(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        try {
            JobDetail jobDetail = this.buildJobDetail(poller);
            Trigger trigger = this.buildTrigger(poller, jobDetail);
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
    }

    protected abstract JobDetail buildJobDetail(DirectoryPoller var1) throws DirectoryMonitorRegistrationException;

    protected abstract Trigger buildTrigger(DirectoryPoller var1, JobDetail var2) throws DirectoryMonitorRegistrationException;

    @Override
    public boolean hasPoller(long directoryID) {
        boolean registered = false;
        try {
            JobDetail jobDetail = this.getScheduler().getJobDetail(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
            if (jobDetail != null) {
                registered = true;
            }
        }
        catch (SchedulerException e) {
            // empty catch block
        }
        return registered;
    }

    @Override
    public void triggerPoll(long directoryID, SynchronisationMode synchronisationMode) {
        try {
            JobDetail jobDetail = this.getScheduler().getJobDetail(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
            if (jobDetail != null) {
                this.getScheduler().triggerJobWithVolatileTrigger(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
            } else {
                LOG.info("Cannot trigger manual poll as directory [" + directoryID + "] does not have a poller registered");
            }
        }
        catch (SchedulerException e) {
            LOG.error("Could not trigger manual poll on directory [" + directoryID + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean removePoller(long directoryID) throws DirectoryMonitorUnregistrationException {
        try {
            return this.getScheduler().deleteJob(this.getJobName(directoryID), DIRECTORY_POLLER_JOB_GROUP);
        }
        catch (SchedulerException e) {
            throw new DirectoryMonitorUnregistrationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new DirectoryMonitorUnregistrationException((Throwable)e);
        }
    }

    @Override
    public void removeAllPollers() {
        try {
            String[] directoryIDs;
            for (String directoryID : directoryIDs = this.getScheduler().getJobNames(DIRECTORY_POLLER_JOB_GROUP)) {
                try {
                    this.removePoller(Long.parseLong(directoryID));
                }
                catch (DirectoryMonitorUnregistrationException e) {
                    // empty catch block
                }
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected String getJobName(long directoryID) {
        return Long.toString(directoryID);
    }

    protected abstract Scheduler getScheduler();
}

