/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.manager.lock.DirectoryLockManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryManagerGeneric
implements DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManagerGeneric.class);
    private final DirectoryDao directoryDao;
    private final ApplicationDAO applicationDAO;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private final PasswordHelper passwordHelper;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectorySynchroniser directorySynchroniser;
    private final DirectoryPollerManager directoryPollerManager;
    private final DirectoryLockManager directoryLockManager;
    private final SynchronisationStatusManager synchronisationStatusManager;

    public DirectoryManagerGeneric(DirectoryDao directoryDao, ApplicationDAO applicationDAO, EventPublisher eventPublisher, PermissionManager permissionManager, PasswordHelper passwordHelper, DirectoryInstanceLoader directoryInstanceLoader, DirectorySynchroniser directorySynchroniser, DirectoryPollerManager directoryPollerManager, DirectoryLockManager directoryLockManager, SynchronisationStatusManager synchronisationStatusManager) {
        this.directoryDao = (DirectoryDao)Preconditions.checkNotNull((Object)directoryDao);
        this.applicationDAO = (ApplicationDAO)Preconditions.checkNotNull((Object)applicationDAO);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.directoryInstanceLoader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)directoryInstanceLoader);
        this.directorySynchroniser = (DirectorySynchroniser)Preconditions.checkNotNull((Object)directorySynchroniser);
        this.directoryPollerManager = (DirectoryPollerManager)Preconditions.checkNotNull((Object)directoryPollerManager);
        this.directoryLockManager = (DirectoryLockManager)Preconditions.checkNotNull((Object)directoryLockManager);
        this.synchronisationStatusManager = (SynchronisationStatusManager)Preconditions.checkNotNull((Object)synchronisationStatusManager);
    }

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        if (!this.directoryInstanceLoader.canLoad(directory.getImplementationClass())) {
            throw new IllegalArgumentException("Failed to instantiate directory with class: " + directory.getImplementationClass());
        }
        Directory addedDirectory = this.directoryDao.add(directory);
        this.eventPublisher.publish((Object)new DirectoryCreatedEvent((Object)this, addedDirectory));
        return addedDirectory;
    }

    public Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }

    public List<Directory> findAllDirectories() {
        return this.directoryDao.findAll();
    }

    public List<Directory> searchDirectories(EntityQuery<Directory> query) {
        return this.directoryDao.search(query);
    }

    public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
        return this.directoryDao.findByName(name);
    }

    public Directory updateDirectory(Directory directory) throws DirectoryNotFoundException {
        if (directory.getId() == null) {
            throw new DirectoryNotFoundException(directory.getId());
        }
        this.findDirectoryById(directory.getId());
        Directory updatedDirectory = this.directoryDao.update(directory);
        this.eventPublisher.publish((Object)new DirectoryUpdatedEvent((Object)this, updatedDirectory));
        return updatedDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
        Lock lock = this.directoryLockManager.getLock(directory.getId());
        if (lock.tryLock()) {
            try {
                this.applicationDAO.removeDirectoryMappings(directory.getId().longValue());
                this.directoryDao.remove(directory);
                this.eventPublisher.publish((Object)new DirectoryDeletedEvent((Object)this, directory));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new DirectoryCurrentlySynchronisingException(directory.getId().longValue());
        }
    }

    public boolean supportsNestedGroups(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory.supportsNestedGroups();
    }

    public boolean isSynchronisable(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory instanceof SynchronisableDirectory;
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode) throws OperationFailedException, DirectoryNotFoundException {
        this.synchroniseCache(directoryId, mode, true);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode, boolean runInBackground) throws OperationFailedException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            if (runInBackground) {
                this.directoryPollerManager.triggerPoll(directoryId, mode);
            } else {
                if (this.isSynchronising(directoryId)) {
                    throw new OperationFailedException("Directory " + directoryId + " is currently synchronising");
                }
                this.directorySynchroniser.synchronise((SynchronisableDirectory)remoteDirectory, mode);
            }
        }
    }

    public boolean isSynchronising(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directorySynchroniser.isSynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            return this.synchronisationStatusManager.getDirectorySynchronisationInformation(this.findDirectoryById(directoryId));
        }
        return null;
    }

    private RemoteDirectory getDirectoryImplementation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryInstanceLoader.getDirectory(this.findDirectoryById(directoryId));
    }

    public com.atlassian.crowd.model.user.User authenticateUser(long directoryId, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).authenticate(username, passwordCredential);
    }

    public com.atlassian.crowd.model.user.User findUserByName(long directoryId, String username) throws OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).findUserByName(username);
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        return this.getDirectoryImplementation(directoryId).findUserWithAttributesByName(username);
    }

    public <T> List<T> searchUsers(long directoryId, EntityQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchUsers(query);
    }

    public com.atlassian.crowd.model.user.User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserAlreadyExistsException {
        if (this.userExists(directoryId, user.getName())) {
            throw new InvalidUserException((User)user, "User already exists");
        }
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)user.getName())) {
            throw new InvalidUserException((User)user, "User name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            com.atlassian.crowd.model.user.User createdUser = this.getDirectoryImplementation(directoryId).addUser(user, credential);
            this.eventPublisher.publish((Object)new UserCreatedEvent((Object)this, directory, createdUser));
            return createdUser;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of users");
    }

    private boolean userExists(long directoryId, String username) throws DirectoryNotFoundException, OperationFailedException {
        try {
            this.findUserByName(directoryId, username);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    public com.atlassian.crowd.model.user.User updateUser(long directoryId, UserTemplate user) throws OperationFailedException, DirectoryPermissionException, InvalidUserException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).updateUser(user);
            this.eventPublisher.publish((Object)new UserUpdatedEvent((Object)this, directory, updatedUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public com.atlassian.crowd.model.user.User renameUser(long directoryId, String oldUsername, String newUsername) throws OperationFailedException, DirectoryPermissionException, InvalidUserException, DirectoryNotFoundException, UserNotFoundException, UserAlreadyExistsException {
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)newUsername)) {
            UserTemplate user = new UserTemplate(newUsername, directoryId);
            throw new InvalidUserException((User)user, "User name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).renameUser(oldUsername, newUsername);
            this.eventPublisher.publish((Object)new UserRenamedEvent((Object)this, directory, updatedUser, oldUsername));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new DirectoryPermissionException("Directory does not allow user attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).storeUserAttributes(username, attributes);
        com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventPublisher.publish((Object)new UserAttributeStoredEvent((Object)this, directory, updatedUser, attributes));
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new DirectoryPermissionException("Directory does not allow user attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).removeUserAttributes(username, attributeName);
        com.atlassian.crowd.model.user.User updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
        this.eventPublisher.publish((Object)new UserAttributeDeletedEvent((Object)this, directory, updatedUser, attributeName));
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws OperationFailedException, DirectoryPermissionException, InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
        logger.info("The password for \"" + username + "\" in \"" + directory.getName() + "\" is being changed.");
        this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
        this.eventPublisher.publish((Object)new UserCredentialUpdatedEvent((Object)this, directory, username, credential));
    }

    public void resetPassword(long directoryId, String username) throws OperationFailedException, InvalidEmailAddressException, DirectoryPermissionException, InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException {
        com.atlassian.crowd.model.user.User user;
        String password;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            password = this.passwordHelper.generateRandomPassword();
            PasswordCredential credential = new PasswordCredential(password);
            user = this.getDirectoryImplementation(directoryId).findUserByName(username);
            if (!StringUtils.isNotBlank((String)user.getEmailAddress())) {
                throw new InvalidEmailAddressException("Cannot email a new password; user's email address is blank.");
            }
            logger.info("The password for \"" + username + "\" in \"" + directory.getName() + "\" is being reset to a random value.");
            this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
        } else {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
        this.eventPublisher.publish((Object)new ResetPasswordEvent((Object)this, directory, user, password));
    }

    public void removeUser(long directoryId, String username) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, UserNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.DELETE_USER)) {
            throw new DirectoryPermissionException("Directory does not allow user removal");
        }
        this.getDirectoryImplementation(directoryId).removeUser(username);
        this.eventPublisher.publish((Object)new UserDeletedEvent((Object)this, directory, username));
    }

    public Group findGroupByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).findGroupWithAttributesByName(groupName);
    }

    public <T> List<T> searchGroups(long directoryId, EntityQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).searchGroups(query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        try {
            this.findGroupByName(directoryId, group.getName());
            throw new InvalidGroupException((Group)group, "Group with name <" + group.getName() + "> already exists in directory <" + directory.getName() + ">");
        }
        catch (GroupNotFoundException e) {
            if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)group.getName())) {
                throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
            }
            OperationType operationType = this.getCreateOperationType((Group)group);
            if (!this.permissionManager.hasPermission(directory, operationType)) {
                if (operationType.equals((Object)OperationType.CREATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow adding of groups");
                }
                throw new DirectoryPermissionException("Directory does not allow adding of roles");
            }
            Group createdGroup = this.getDirectoryImplementation(directoryId).addGroup(group);
            this.eventPublisher.publish((Object)new GroupCreatedEvent((Object)this, directory, createdGroup));
            return createdGroup;
        }
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType((Group)group))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        Group updatedGroup = this.getDirectoryImplementation(directoryId).updateGroup(group);
        this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
        return updatedGroup;
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)newGroupname)) {
            GroupTemplate group = new GroupTemplate(newGroupname, directoryId);
            throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, oldGroupname)))) {
            Group updatedGroup = this.getDirectoryImplementation(directoryId).renameGroup(oldGroupname, newGroupname);
            this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
            return updatedGroup;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = this.getUpdateAttributeOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.getDirectoryImplementation(directoryId).storeGroupAttributes(groupName, attributes);
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeStoredEvent((Object)this, directory, updateGroup, attributes));
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws OperationFailedException, DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = this.getUpdateAttributeOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP_ATTRIBUTE)) {
                throw new DirectoryPermissionException("Directory does not allow group attribute modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role attribute modifications");
        }
        this.getDirectoryImplementation(directoryId).removeGroupAttributes(groupName, attributeName);
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeDeletedEvent((Object)this, directory, updateGroup, attributeName));
    }

    public void removeGroup(long directoryId, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        Group groupToDelete;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = this.getDeleteOperationType(groupToDelete = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.DELETE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group removal");
            }
            throw new DirectoryPermissionException("Directory does not allow role removal");
        }
        this.getDirectoryImplementation(directoryId).removeGroup(groupName);
        this.applicationDAO.removeGroupMappings(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupDeletedEvent((Object)this, directory, groupName));
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws OperationFailedException, DirectoryNotFoundException {
        return this.getDirectoryImplementation(directoryId).isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory.supportsNestedGroups() && remoteDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException {
        if (!this.isUserDirectGroupMember(directoryId, username, groupName)) {
            Group groupToUpdate;
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
                this.getDirectoryImplementation(directoryId).addUserToGroup(username, groupName);
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
            } else {
                if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow group modifications");
                }
                throw new DirectoryPermissionException("Directory does not allow role modifications");
            }
        }
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, NestedGroupsNotSupportedException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new NestedGroupsNotSupportedException(directoryId);
        }
        if (!this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup)) {
            Group parentGroupToUpdate;
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(parentGroupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
                if (childGroup.equals(parentGroup)) {
                    throw new InvalidMembershipException("Cannot add direct circular group membership reference");
                }
                remoteDirectory.addGroupToGroup(childGroup, parentGroup);
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
            } else {
                if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow group modifications");
                }
                throw new DirectoryPermissionException("Directory does not allow role modifications");
            }
        }
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException, MembershipNotFoundException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.getDirectoryImplementation(directoryId).removeUserFromGroup(username, groupName);
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, MembershipNotFoundException, DirectoryNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        Group groupToUpdate;
        OperationType operationType;
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new UnsupportedOperationException("Directory with id [" + directoryId + "] does not support nested groups");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
            if (childGroup.equals(parentGroup)) {
                throw new InvalidMembershipException("Cannot remove direct circular group membership reference");
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
    }

    public <T> List<T> searchDirectGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups() && query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            return Collections.emptyList();
        }
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToMatch().getGroupType() == GroupType.LEGACY_ROLE || query.getEntityToReturn().getEntityType() == Entity.GROUP && query.getEntityToReturn().getGroupType() == GroupType.LEGACY_ROLE) {
            return Collections.emptyList();
        }
        return this.getDirectoryImplementation(directoryId).searchGroupRelationships(query);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws OperationFailedException, DirectoryNotFoundException {
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isUserNestedGroupMember(directoryId, username, groupName, new HashSet<String>());
        }
        return this.isUserDirectGroupMember(directoryId, username, groupName);
    }

    private boolean isUserNestedGroupMember(long directoryId, String username, String groupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(IdentifierUtils.toLowerCase((String)groupName))) {
                return false;
            }
            isMember = this.isUserDirectGroupMember(directoryId, username, groupName);
            visitedGroups.add(IdentifierUtils.toLowerCase((String)groupName));
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isUserNestedGroupMember(directoryId, username, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException, DirectoryNotFoundException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isGroupNestedGroupMember(directoryId, childGroup, parentGroup, new HashSet<String>());
        }
        return this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    private boolean isGroupNestedGroupMember(long directoryId, String childGroupName, String parentGroupName, Set<String> visitedGroups) throws OperationFailedException, DirectoryNotFoundException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(IdentifierUtils.toLowerCase((String)parentGroupName))) {
                return false;
            }
            isMember = this.isGroupDirectGroupMember(directoryId, childGroupName, parentGroupName);
            visitedGroups.add(IdentifierUtils.toLowerCase((String)parentGroupName));
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isGroupNestedGroupMember(directoryId, childGroupName, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> List<T> searchNestedGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException, DirectoryNotFoundException {
        List relations;
        if (!this.getDirectoryImplementation(directoryId).supportsNestedGroups()) return this.searchDirectGroupRelationships(directoryId, query);
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.isFindChildren()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                relations = this.findNestedUserMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                relations = this.findNestedGroupMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                relations = this.findNestedGroupMembershipsOfUser(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                relations = this.findNestedGroupMembershipsOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            }
        }
        relations = SearchResultsUtil.constrainResults(relations, (int)query.getStartIndex(), (int)query.getMaxResults());
        if (query.getReturnType() != String.class) return relations;
        return SearchResultsUtil.convertEntitiesToNames((Iterable)relations);
    }

    private List<Group> findNestedGroupMembershipsOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        List<Group> nestedParents = this.findNestedGroupMembershipsIncludingGroups(directoryId, Arrays.asList(group), groupType, maxResults, false);
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsIncludingGroups(long directoryId, List<Group> groups, GroupType groupType, int maxResults, boolean includeOriginal) throws OperationFailedException, DirectoryNotFoundException {
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedParents = new LinkedHashSet<Group>();
        groupsToVisit.addAll(groups);
        int totalResults = maxResults;
        if (maxResults != -1 && !includeOriginal) {
            totalResults = maxResults + groups.size();
        }
        while (!(groupsToVisit.isEmpty() || totalResults != -1 && nestedParents.size() >= totalResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedParents.contains(groupToVisit)) continue;
            nestedParents.add(groupToVisit);
            List directParents = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directParents);
        }
        if (!includeOriginal) {
            nestedParents.removeAll(groups);
        }
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsOfUser(long directoryId, String username, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        List<Group> directGroupMemberships = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(maxResults));
        return this.findNestedGroupMembershipsIncludingGroups(directoryId, directGroupMemberships, groupType, maxResults, true);
    }

    private List<Group> findNestedGroupMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedMembers = new LinkedHashSet<Group>();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedMembers.size() >= maxResults + 1)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedMembers.contains(groupToVisit)) continue;
            nestedMembers.add(groupToVisit);
            List directMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directMembers);
        }
        nestedMembers.remove(group);
        return new ArrayList<Group>(nestedMembers);
    }

    private List<com.atlassian.crowd.model.user.User> findNestedUserMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException, DirectoryNotFoundException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedGroupMembers = new LinkedHashSet<Group>();
        LinkedHashSet nestedUserMembers = new LinkedHashSet();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedUserMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            List directUserMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            nestedUserMembers.addAll(directUserMembers);
            if (nestedGroupMembers.contains(groupToVisit)) continue;
            nestedGroupMembers.add(groupToVisit);
            List directGroupMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).childrenOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(-1));
            groupsToVisit.addAll(directGroupMembers);
        }
        return new ArrayList<com.atlassian.crowd.model.user.User>(nestedUserMembers);
    }

    public BulkAddResult<com.atlassian.crowd.model.user.User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            List<UserTemplateWithCredentialAndAttributes> failedEntities;
            List<com.atlassian.crowd.model.user.User> successfulEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<UserTemplateWithCredentialAndAttributes> usersToAdd = new ArrayList<UserTemplateWithCredentialAndAttributes>();
            BulkAddResult result = new BulkAddResult((long)users.size(), overwrite);
            for (UserTemplateWithCredentialAndAttributes user : users) {
                try {
                    this.findUserByName(directoryId, user.getName());
                    if (overwrite) {
                        try {
                            logger.info("Removing existing user: " + user);
                            this.removeUser(directoryId, user.getName());
                            usersToAdd.add(user);
                        }
                        catch (Exception e) {
                            logger.error("Could not remove user for bulk import overwrite: " + user, (Throwable)e);
                            result.addExistingEntity((Object)user);
                        }
                        continue;
                    }
                    logger.info("User <" + user + "> already exists in directory. Skipping over this entity.");
                    result.addExistingEntity((Object)user);
                }
                catch (UserNotFoundException e) {
                    usersToAdd.add(user);
                }
            }
            Set uniqueUsersToAdd = this.retainUniqueEntities(usersToAdd);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllUsers(uniqueUsersToAdd);
                successfulEntities = batchResult.getSuccessfulEntities();
                failedEntities = batchResult.getFailedEntities();
            } else {
                successfulEntities = new ArrayList(uniqueUsersToAdd);
                failedEntities = new ArrayList();
                for (UserTemplateWithCredentialAndAttributes user : uniqueUsersToAdd) {
                    try {
                        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)user.getName())) {
                            throw new InvalidUserException((User)user, "User name may not contain leading or trailing whitespace");
                        }
                        successfulEntities.add(remoteDirectory.addUser((UserTemplate)user, user.getCredential()));
                    }
                    catch (Exception e) {
                        failedEntities.add(user);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            this.logFailedEntities(remoteDirectory, failedEntities);
            for (com.atlassian.crowd.model.user.User addedUser : successfulEntities) {
                this.eventPublisher.publish((Object)new UserCreatedEvent((Object)this, directory, addedUser));
            }
            return result;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of users");
    }

    private <T> Set<T> retainUniqueEntities(Collection<T> entities) {
        HashSet<T> uniqueEntities = new HashSet<T>(entities.size());
        for (T entity : entities) {
            boolean added;
            if (logger.isDebugEnabled()) {
                logger.debug("Going to add: " + entity);
            }
            if (added = uniqueEntities.add(entity)) continue;
            logger.warn("Duplicate entity. Entity is already in the set of entities to bulk add: " + entity);
        }
        return uniqueEntities;
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, InvalidGroupException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_GROUP)) {
            List<GroupTemplate> failedEntities;
            List<Group> successfulEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<GroupTemplate> groupsToAdd = new ArrayList<GroupTemplate>();
            BulkAddResult result = new BulkAddResult((long)groups.size(), overwrite);
            for (GroupTemplate group : groups) {
                try {
                    this.findGroupByName(directoryId, group.getName());
                    if (overwrite) {
                        try {
                            logger.info("Removing existing group: " + group);
                            this.removeGroup(directoryId, group.getName());
                            groupsToAdd.add(group);
                        }
                        catch (Exception e) {
                            logger.error("Could not remove group for bulk import overwrite: " + group, (Throwable)e);
                            result.addExistingEntity((Object)group);
                        }
                        continue;
                    }
                    logger.info("Group <" + group + "> already exists in directory. Skipping over this entity.");
                    result.addExistingEntity((Object)group);
                }
                catch (GroupNotFoundException e) {
                    groupsToAdd.add(group);
                }
            }
            Set uniqueGroupsToAdd = this.retainUniqueEntities(groupsToAdd);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllGroups(uniqueGroupsToAdd);
                successfulEntities = batchResult.getSuccessfulEntities();
                failedEntities = batchResult.getFailedEntities();
            } else {
                successfulEntities = new ArrayList(uniqueGroupsToAdd.size());
                failedEntities = new ArrayList();
                for (GroupTemplate group : uniqueGroupsToAdd) {
                    try {
                        if (IdentifierUtils.hasLeadingOrTrailingWhitespace((String)group.getName())) {
                            throw new InvalidGroupException((Group)group, "Group name may not contain leading or trailing whitespace");
                        }
                        successfulEntities.add(remoteDirectory.addGroup(group));
                    }
                    catch (Exception e) {
                        failedEntities.add(group);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            this.logFailedEntities(remoteDirectory, failedEntities);
            for (Group addedGroup : successfulEntities) {
                this.eventPublisher.publish((Object)new GroupCreatedEvent((Object)this, directory, addedGroup));
            }
            return result;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of groups");
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            List<String> failedUsers;
            List<String> successfulUsers;
            RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
            Set<String> usersToAdd = this.retainUniqueEntities(userNames);
            BulkAddResult result = new BulkAddResult((long)userNames.size(), true);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                BatchResult batchResult = ((InternalRemoteDirectory)remoteDirectory).addAllUsersToGroup(usersToAdd, groupName);
                successfulUsers = batchResult.getSuccessfulEntities();
                failedUsers = batchResult.getFailedEntities();
            } else {
                successfulUsers = new ArrayList(usersToAdd.size());
                failedUsers = new ArrayList();
                for (String username : usersToAdd) {
                    try {
                        this.addUserToGroup(directoryId, username, groupName);
                        successfulUsers.add(username);
                    }
                    catch (Exception e) {
                        failedUsers.add(username);
                        logger.error(e.getMessage());
                    }
                }
            }
            result.addFailedEntities(failedUsers);
            for (String username : successfulUsers) {
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
            }
            for (String failedUser : failedUsers) {
                logger.warn("Could not add the following user to the group [ {} ]: {}", (Object)groupName, (Object)failedUser);
            }
            return result;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    private OperationType getCreateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.CREATE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getUpdateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getUpdateAttributeOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP_ATTRIBUTE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getDeleteOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.DELETE_GROUP;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void logFailedEntities(RemoteDirectory remoteDirectory, Collection<? extends DirectoryEntity> failedEntities) {
        if (!failedEntities.isEmpty()) {
            String directoryName = remoteDirectory.getDescriptiveName();
            for (DirectoryEntity directoryEntity : failedEntities) {
                logger.warn("Could not add the following entity to the directory [ {} ]: {}", (Object)directoryName, (Object)directoryEntity.getName());
            }
        }
    }
}

