/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.lock;

import com.atlassian.crowd.manager.lock.LockFactory;
import com.atlassian.crowd.manager.lock.ReentrantLockFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.locks.Lock;

public class DirectoryLockManager {
    private static final String KEY_PREFIX = DirectoryLockManager.class.getName() + ".directory-";
    private final Cache<String, Lock> locks;

    public DirectoryLockManager() {
        this(new ReentrantLockFactory());
    }

    public DirectoryLockManager(final LockFactory lockFactory) {
        this.locks = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Lock>(){

            public Lock load(String key) throws Exception {
                return lockFactory.getLock(key);
            }
        });
    }

    public Lock getLock(long directoryId) {
        return (Lock)this.locks.getUnchecked((Object)this.getLockKey(directoryId));
    }

    private String getLockKey(long directoryId) {
        return KEY_PREFIX + directoryId;
    }
}

