/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event;

import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.model.event.GroupEvent;
import com.atlassian.crowd.model.event.GroupMembershipEvent;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.atlassian.crowd.model.event.UserEvent;
import com.atlassian.crowd.model.event.UserMembershipEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class StoringEventListener {
    private final EventStore eventStore;
    private final boolean ignoreAttributes;

    public StoringEventListener(EventStore eventStore, EventPublisher eventPublisher, boolean ignoreAttributes) {
        this.eventStore = eventStore;
        eventPublisher.register((Object)this);
        this.ignoreAttributes = ignoreAttributes;
    }

    @EventListener
    public void handleEvent(UserCreatedEvent event) {
        this.eventStore.storeEvent((OperationEvent)new UserEvent(Operation.CREATED, event.getDirectory(), event.getUser(), null, null));
    }

    @EventListener
    public void handleEvent(UserUpdatedEvent event) {
        HashMap<String, Set> storedAttributes = null;
        Set<String> deletedAttributes = null;
        if (event instanceof UserAttributeStoredEvent) {
            if (this.ignoreAttributes) {
                return;
            }
            UserAttributeStoredEvent userAttributeStoredEvent = (UserAttributeStoredEvent)event;
            storedAttributes = new HashMap<String, Set>();
            for (String storedAttribute : userAttributeStoredEvent.getAttributeNames()) {
                storedAttributes.put(storedAttribute, userAttributeStoredEvent.getAttributeValues(storedAttribute));
            }
        } else if (event instanceof UserAttributeDeletedEvent) {
            if (this.ignoreAttributes) {
                return;
            }
            deletedAttributes = Collections.singleton(((UserAttributeDeletedEvent)event).getAttributeName());
        }
        this.eventStore.storeEvent((OperationEvent)new UserEvent(Operation.UPDATED, event.getDirectory(), event.getUser(), storedAttributes, deletedAttributes));
    }

    @EventListener
    public void handleEvent(UserDeletedEvent event) {
        UserTemplate user = new UserTemplate(event.getUsername(), event.getDirectory().getId().longValue());
        this.eventStore.storeEvent((OperationEvent)new UserEvent(Operation.DELETED, event.getDirectory(), (User)user, null, null));
    }

    @EventListener
    public void handleEvent(GroupCreatedEvent event) {
        this.eventStore.storeEvent((OperationEvent)new GroupEvent(Operation.CREATED, event.getDirectory(), event.getGroup(), null, null));
    }

    @EventListener
    public void handleEvent(GroupUpdatedEvent event) {
        HashMap<String, Set> storedAttributes = null;
        Set<String> deletedAttributes = null;
        if (event instanceof GroupAttributeStoredEvent) {
            if (this.ignoreAttributes) {
                return;
            }
            GroupAttributeStoredEvent groupAttributeStoredEvent = (GroupAttributeStoredEvent)event;
            storedAttributes = new HashMap<String, Set>();
            for (String storedAttribute : groupAttributeStoredEvent.getAttributeNames()) {
                storedAttributes.put(storedAttribute, groupAttributeStoredEvent.getAttributeValues(storedAttribute));
            }
        } else if (event instanceof GroupAttributeDeletedEvent) {
            if (this.ignoreAttributes) {
                return;
            }
            deletedAttributes = Collections.singleton(((GroupAttributeDeletedEvent)event).getAttributeName());
        }
        this.eventStore.storeEvent((OperationEvent)new GroupEvent(Operation.UPDATED, event.getDirectory(), event.getGroup(), storedAttributes, deletedAttributes));
    }

    @EventListener
    public void handleEvent(GroupDeletedEvent event) {
        GroupTemplate group = new GroupTemplate(event.getGroupName(), event.getDirectory().getId().longValue());
        this.eventStore.storeEvent((OperationEvent)new GroupEvent(Operation.DELETED, event.getDirectory(), (Group)group, null, null));
    }

    @EventListener
    public void handleEvent(GroupMembershipCreatedEvent event) {
        if (event.getMembershipType() == MembershipType.GROUP_USER) {
            this.eventStore.storeEvent((OperationEvent)new UserMembershipEvent(Operation.CREATED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else if (event.getMembershipType() == MembershipType.GROUP_GROUP) {
            this.eventStore.storeEvent((OperationEvent)new GroupMembershipEvent(Operation.CREATED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else {
            throw new IllegalArgumentException("MembershipType " + event.getMembershipType() + " is not supported");
        }
    }

    @EventListener
    public void handleEvent(GroupMembershipDeletedEvent event) {
        if (event.getMembershipType() == MembershipType.GROUP_USER) {
            this.eventStore.storeEvent((OperationEvent)new UserMembershipEvent(Operation.DELETED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else if (event.getMembershipType() == MembershipType.GROUP_GROUP) {
            this.eventStore.storeEvent((OperationEvent)new GroupMembershipEvent(Operation.DELETED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else {
            throw new IllegalArgumentException("MembershipType " + event.getMembershipType() + " is not supported");
        }
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        this.eventStore.invalidateEvents();
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        this.eventStore.invalidateEvents();
    }

    @EventListener
    public void handleEvent(XMLRestoreFinishedEvent event) {
        this.eventStore.invalidateEvents();
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryAddedEvent event) {
        this.eventStore.invalidateEvents();
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryRemovedEvent event) {
        this.eventStore.invalidateEvents();
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryOrderUpdatedEvent event) {
        this.eventStore.invalidateEvents();
    }
}

