/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.manager.application.ResultsAggregator;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AggregatorImpl<T, K extends Comparable<? super K>>
extends ResultsAggregator<T> {
    private final int startIndex;
    private final int maxResults;
    private final int totalResults;
    private final Function<? super T, ? extends K> keymaker;
    private final Map<K, T> contents;

    AggregatorImpl(Function<? super T, ? extends K> keymaker, Query<? extends T> query) {
        this(keymaker, query.getStartIndex(), query.getMaxResults());
    }

    AggregatorImpl(Function<? super T, ? extends K> keymaker, int startIndex, int maxResults) {
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.totalResults = AggregatorImpl.totalResults(startIndex, maxResults);
        this.keymaker = keymaker;
        this.contents = new HashMap<K, T>();
    }

    private static int totalResults(int startIndex, int maxResults) {
        if (maxResults == -1) {
            return -1;
        }
        return startIndex + maxResults;
    }

    @Override
    void add(T t) {
        Comparable k = (Comparable)this.keymaker.apply(t);
        if (!this.contents.containsKey(k)) {
            this.contents.put(k, t);
        }
    }

    @Override
    void addAll(Iterable<? extends T> results) {
        for (T t : results) {
            this.add(t);
        }
    }

    @Override
    List<T> constrainResults() {
        ArrayList<K> keys = new ArrayList<K>(this.contents.keySet());
        Collections.sort(keys);
        ArrayList<T> sorted = new ArrayList<T>(this.contents.size());
        for (Comparable k : keys) {
            sorted.add(this.contents.get(k));
        }
        return SearchResultsUtil.constrainResults(sorted, (int)this.startIndex, (int)this.maxResults);
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    int getRequiredResultCount() {
        return this.totalResults;
    }
}

