/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.lock;

import com.atlassian.crowd.manager.lock.LockFactory;
import com.atlassian.crowd.manager.lock.ReentrantLockFactory;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

public class DirectoryLockManager {
    private static final String KEY_PREFIX = DirectoryLockManager.class.getName() + ".directory-";
    private final ConcurrentMap<String, Lock> locks;

    public DirectoryLockManager() {
        this(new ReentrantLockFactory());
    }

    public DirectoryLockManager(final LockFactory lockFactory) {
        this.locks = new MapMaker().softValues().makeComputingMap((Function)new Function<String, Lock>(){

            public Lock apply(String key) {
                return lockFactory.getLock(key);
            }
        });
    }

    public Lock getLock(long directoryId) {
        return (Lock)this.locks.get(this.getLockKey(directoryId));
    }

    private String getLockKey(long directoryId) {
        return KEY_PREFIX + directoryId;
    }
}

