/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
interface DirectoryCacheChangeOperations {
    public void deleteCachedUsersNotIn(List<? extends User> var1, Date var2) throws OperationFailedException;

    public void deleteCachedUsers(Set<String> var1) throws OperationFailedException;

    public void deleteCachedGroupsNotIn(GroupType var1, List<? extends Group> var2, Date var3) throws OperationFailedException;

    public void deleteCachedGroups(Set<String> var1) throws OperationFailedException;

    public AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> getUsersToAddAndUpdate(List<? extends User> var1, Date var2) throws OperationFailedException;

    public void addUsers(Set<UserTemplateWithCredentialAndAttributes> var1) throws OperationFailedException;

    public void updateUsers(Set<UserTemplate> var1) throws OperationFailedException;

    public GroupsToAddUpdateReplace findGroupsToUpdate(List<? extends Group> var1, Date var2) throws OperationFailedException;

    public void removeGroups(Collection<String> var1) throws OperationFailedException;

    public void addGroups(Set<GroupTemplate> var1) throws OperationFailedException;

    public void updateGroups(Collection<GroupTemplate> var1) throws OperationFailedException;

    public boolean ignoreGroupOnSynchroniseMemberships(Group var1) throws OperationFailedException;

    public AddRemoveSets<String> findUserMembershipForGroupChanges(Group var1, List<String> var2) throws OperationFailedException;

    public void addUserMembershipsForGroup(Group var1, Set<String> var2) throws OperationFailedException;

    public void removeUserMembershipsForGroup(Group var1, Set<String> var2) throws OperationFailedException;

    public AddRemoveSets<String> findGroupMembershipForGroupChanges(Group var1, List<String> var2) throws OperationFailedException;

    public void addGroupMembershipsForGroup(Group var1, Collection<String> var2) throws OperationFailedException;

    public void removeGroupMembershipsForGroup(Group var1, Collection<String> var2) throws OperationFailedException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRemoveSets<T> {
        final Set<T> toAdd;
        final Set<T> toRemove;

        public AddRemoveSets(Set<T> toAdd, Set<T> toRemove) {
            this.toAdd = toAdd;
            this.toRemove = toRemove;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupsToAddUpdateReplace {
        final Set<GroupTemplate> groupsToAdd;
        final Set<GroupTemplate> groupsToUpdate;
        final Map<String, GroupTemplate> groupsToReplace;

        GroupsToAddUpdateReplace(Set<GroupTemplate> groupsToAdd, Set<GroupTemplate> groupsToUpdate, Map<String, GroupTemplate> groupsToReplace) {
            this.groupsToAdd = groupsToAdd;
            this.groupsToUpdate = groupsToUpdate;
            this.groupsToReplace = groupsToReplace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddUpdateSets<A, U> {
        private final Set<A> toAddSet;
        private final Set<U> toUpdateSet;

        public AddUpdateSets(Set<A> addSet, Set<U> updateSet) {
            this.toAddSet = addSet;
            this.toUpdateSet = updateSet;
        }

        public Set<A> getToAddSet() {
            return this.toAddSet;
        }

        public Set<U> getToUpdateSet() {
            return this.toUpdateSet;
        }
    }
}

