/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.TimerStack;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.Percentage;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbCachingRemoteDirectoryCache
implements DirectoryCache {
    private static final Logger logger = LoggerFactory.getLogger(DbCachingRemoteDirectoryCache.class);
    private final RemoteDirectory remoteDirectory;
    private final InternalRemoteDirectory internalDirectory;
    private final SynchronisationStatusManager synchronisationStatusManager;

    public DbCachingRemoteDirectoryCache(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, SynchronisationStatusManager synchronisationStatusManager) {
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
        this.synchronisationStatusManager = synchronisationStatusManager;
    }

    private long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    private Map<String, TimestampedUser> findUsersUpdatedBefore(Date date) throws OperationFailedException {
        HashMap<String, TimestampedUser> users = new HashMap<String, TimestampedUser>();
        NullRestriction restriction = date == null ? NullRestrictionImpl.INSTANCE : Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)date), Restriction.on((Property)UserTermKeys.UPDATED_DATE).lessThan((Object)date)});
        List list = this.internalDirectory.searchUsers(QueryBuilder.queryFor(TimestampedUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1));
        for (TimestampedUser timestampedUser : list) {
            users.put(timestampedUser.getName(), timestampedUser);
        }
        return users;
    }

    private Map<String, InternalDirectoryGroup> findGroupsUpdatedBefore(Date date) throws OperationFailedException {
        HashMap<String, InternalDirectoryGroup> result = new HashMap<String, InternalDirectoryGroup>();
        NullRestriction restriction = date == null ? NullRestrictionImpl.INSTANCE : Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.CREATED_DATE).lessThan((Object)date), Restriction.on((Property)GroupTermKeys.UPDATED_DATE).lessThan((Object)date)});
        List groups = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)restriction).returningAtMost(-1));
        List roles = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)restriction).returningAtMost(-1));
        for (InternalDirectoryGroup internalGroup : groups) {
            result.put(internalGroup.getName(), internalGroup);
        }
        for (InternalDirectoryGroup internalGroup : roles) {
            result.put(internalGroup.getName(), internalGroup);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedUsers(List<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        block20: {
            TimerStack.push();
            try {
                Set usersToUpdate;
                Set usersToAdd;
                TimerStack.push();
                try {
                    AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> result = this.getUsersToAddAndUpdate(remoteUsers, syncStartDate);
                    usersToAdd = ((AddUpdateSets)result).getToAddSet();
                    usersToUpdate = ((AddUpdateSets)result).getToUpdateSet();
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for update in DB cache in [ {0} ]"));
                }
                if (!usersToAdd.isEmpty()) {
                    this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.adding.users", new Serializable[]{Integer.valueOf(usersToAdd.size())});
                    logger.info("adding [ {} ] users", (Object)usersToAdd.size());
                    TimerStack.push();
                    try {
                        this.internalDirectory.addAllUsers(usersToAdd);
                    }
                    finally {
                        logger.info(TimerStack.pop("added [ " + usersToAdd.size() + " ] users in [ {0} ]"));
                    }
                }
                if (usersToUpdate.isEmpty()) break block20;
                this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.updating.users", new Serializable[]{Integer.valueOf(usersToUpdate.size())});
                logger.info("updating [ {} ] users", (Object)usersToUpdate.size());
                TimerStack.push();
                try {
                    int count = 0;
                    for (UserTemplate user : usersToUpdate) {
                        if (usersToUpdate.size() > 100 && count % 100 == 0) {
                            logger.info("updated [ {}% ] users", (Object)Percentage.get((int)count, (int)usersToUpdate.size()));
                        }
                        try {
                            this.internalDirectory.updateUser(user);
                        }
                        catch (InvalidUserException e) {
                            logger.warn("Unable to synchronize user " + user.getName() + " from remote directory: " + e.getMessage(), (Throwable)e);
                        }
                        catch (UserNotFoundException e) {
                            logger.warn("Could not find user to " + user.getName() + " in internal directory: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                finally {
                    logger.info(TimerStack.pop("updated [ " + usersToUpdate.size() + " ] users in [ {0} ]"));
                }
            }
            finally {
                logger.info(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] users in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedUsersNotIn(List<? extends User> remoteUsers, Date synchStartDate) throws OperationFailedException {
        TimerStack.push();
        try {
            HashSet<String> remoteUsernames = new HashSet<String>(remoteUsers.size());
            HashSet<String> usersToDelete = new HashSet<String>();
            TimerStack.push();
            try {
                for (User user : remoteUsers) {
                    remoteUsernames.add(user.getName());
                }
                Map<String, TimestampedUser> users = this.findUsersUpdatedBefore(synchStartDate);
                for (TimestampedUser internalUser : users.values()) {
                    String userName = internalUser.getName();
                    if (remoteUsernames.contains(userName)) continue;
                    logger.debug("user [ {} ] not found, deleting", (Object)userName);
                    usersToDelete.add(userName);
                }
            }
            finally {
                logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for delete in DB cache in [ {0} ]"));
            }
            if (!usersToDelete.isEmpty()) {
                this.deleteCachedUsers(usersToDelete);
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned for deleted users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedUsers(Set<String> usernames) throws OperationFailedException {
        this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.deleting.users", new Serializable[]{Integer.valueOf(usernames.size())});
        logger.info("deleting [ {} ] users", (Object)usernames.size());
        TimerStack.push();
        try {
            this.internalDirectory.removeAllUsers(usernames);
        }
        finally {
            logger.info(TimerStack.pop("deleted [ " + usernames.size() + " ] users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedGroups(List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        block38: {
            HashSet<Object> groupsToAdd = new HashSet<Object>();
            HashSet<GroupTemplate> groupsToUpdate = new HashSet<GroupTemplate>();
            HashMap<String, GroupTemplate> groupsToReplace = new HashMap<String, GroupTemplate>();
            logger.info("scanning [ {} ] groups to add or update", (Object)remoteGroups.size());
            TimerStack.push();
            try {
                TimerStack.push();
                try {
                    Map<String, InternalDirectoryGroup> groups = this.findGroupsUpdatedBefore(syncStartDate);
                    for (Group group : remoteGroups) {
                        InternalDirectoryGroup internalGroup = groups.get(group.getName());
                        if (internalGroup == null) {
                            logger.debug("group [ {} ] not found, adding", (Object)group.getName());
                            groupsToAdd.add(this.makeGroupTemplate(group));
                            continue;
                        }
                        if (internalGroup.getUpdatedDate() == null) {
                            logger.warn("group [ {} ] in directory [ {} ] has no updated date", (Object)group.getName(), (Object)this.getDirectoryId());
                        } else if (syncStartDate != null && internalGroup.getUpdatedDate().getTime() > syncStartDate.getTime()) {
                            logger.debug("group [ {} ] in directory [ {} ] modified after synchronisation start, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                            continue;
                        }
                        if (internalGroup.isLocal()) {
                            logger.debug("group [ {} ] in directory [ {} ] matches local group of same name, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                            continue;
                        }
                        if (group.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP) {
                            logger.debug("role [ {} ] in directory [ {} ] matches local group of same name, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                            continue;
                        }
                        if (group.getType() == GroupType.GROUP && internalGroup.getType() == GroupType.LEGACY_ROLE) {
                            logger.debug("role [ {} ] in directory [ {} ] matches legacy role of same name, replacing", (Object)internalGroup.getName(), (Object)this.getDirectoryId());
                            groupsToReplace.put(internalGroup.getName(), this.makeGroupTemplate(group));
                            continue;
                        }
                        if (this.hasChanged(group, (Group)internalGroup)) {
                            groupsToUpdate.add(this.makeGroupTemplate(group));
                            continue;
                        }
                        logger.trace("group [ {} ] unmodified, skipping", (Object)group.getName());
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for update in DB cache in [ {0} ]"));
                }
                logger.debug("replacing [ {} ] groups", (Object)groupsToReplace.size());
                if (!groupsToReplace.isEmpty()) {
                    TimerStack.push();
                    try {
                        for (Map.Entry entry : groupsToReplace.entrySet()) {
                            try {
                                this.internalDirectory.removeGroup((String)entry.getKey());
                            }
                            catch (GroupNotFoundException groupNotFoundException) {
                                logger.warn("Could not find group: " + groupNotFoundException.getGroupName(), (Throwable)groupNotFoundException);
                            }
                            catch (ReadOnlyGroupException readOnlyGroupException) {
                                logger.warn("Group is read-only and not allowed to be modified: " + readOnlyGroupException.getGroupName(), (Throwable)readOnlyGroupException);
                            }
                            groupsToAdd.add(entry.getValue());
                        }
                    }
                    finally {
                        logger.info(TimerStack.pop("replaced [ " + groupsToReplace.size() + " ] groups in [ {0} ]"));
                    }
                }
                logger.debug("adding [ {} ] groups", (Object)groupsToAdd.size());
                logger.debug("updating [ {} ] groups", (Object)groupsToUpdate.size());
                if (!groupsToAdd.isEmpty()) {
                    this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.adding.groups", new Serializable[]{Integer.valueOf(groupsToAdd.size())});
                    TimerStack.push();
                    try {
                        this.internalDirectory.addAllGroups(groupsToAdd);
                    }
                    finally {
                        logger.info(TimerStack.pop("added [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
                    }
                }
                if (groupsToUpdate.isEmpty()) break block38;
                this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.updating.groups", new Serializable[]{Integer.valueOf(groupsToUpdate.size())});
                try {
                    TimerStack.push();
                    for (GroupTemplate groupTemplate : groupsToUpdate) {
                        try {
                            this.internalDirectory.updateGroup(groupTemplate);
                        }
                        catch (InvalidGroupException invalidGroupException) {
                            logger.warn("Unable to synchronise group " + groupTemplate.getName() + " with remote directory: " + invalidGroupException.getMessage(), (Throwable)invalidGroupException);
                        }
                        catch (ReadOnlyGroupException readOnlyGroupException) {
                            logger.warn("Unable to update read-only group " + groupTemplate.getName() + " with remote directory: " + readOnlyGroupException.getMessage(), (Throwable)readOnlyGroupException);
                        }
                        catch (GroupNotFoundException groupNotFoundException) {
                            logger.warn("Unable to find group " + groupTemplate.getName() + " on update with remote directory: " + groupNotFoundException.getMessage(), (Throwable)groupNotFoundException);
                        }
                    }
                }
                finally {
                    logger.info(TimerStack.pop("updated [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
                }
            }
            finally {
                logger.info(TimerStack.pop("synchronized [ " + remoteGroups.size() + " ] groups in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        HashSet<String> groupsToRemove = new HashSet<String>();
        try {
            TimerStack.push();
            HashSet<String> remoteGroupnames = new HashSet<String>(remoteGroups.size());
            for (Group group : remoteGroups) {
                remoteGroupnames.add(group.getName());
            }
            Map<String, InternalDirectoryGroup> groups = this.findGroupsUpdatedBefore(syncStartDate);
            for (InternalDirectoryGroup internalGroup : groups.values()) {
                if (internalGroup.isLocal()) continue;
                if (internalGroup.getCreatedDate() == null) {
                    logger.warn("group [ " + internalGroup.getName() + " ] in directory [ " + this.getDirectoryId() + " ] has no created date, skipping");
                } else if (syncStartDate != null && internalGroup.getCreatedDate().getTime() > syncStartDate.getTime()) {
                    logger.debug("group [ " + internalGroup.getName() + " ] created after synchronisation start, skipping");
                    continue;
                }
                if (remoteGroupnames.contains(internalGroup.getName())) continue;
                logger.debug("group [ " + internalGroup.getName() + " ] not found, deleting");
                groupsToRemove.add(internalGroup.getName());
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for delete in DB cache in [ {0} ]"));
        }
        if (!groupsToRemove.isEmpty()) {
            this.deleteCachedGroups(groupsToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.deleting.groups", new Serializable[]{Integer.valueOf(groupnames.size())});
        logger.info("removing [ " + groupnames.size() + " ] groups");
        try {
            TimerStack.push();
            this.internalDirectory.removeAllGroups(groupnames);
        }
        finally {
            logger.info(TimerStack.pop("removed [ " + groupnames.size() + " ] groups in [ {0} ]"));
        }
    }

    private boolean hasChanged(User remoteUser, User internalUser) {
        return this.different(remoteUser.getFirstName(), internalUser.getFirstName()) || this.different(remoteUser.getLastName(), internalUser.getLastName()) || this.different(remoteUser.getDisplayName(), internalUser.getDisplayName()) || this.different(remoteUser.getEmailAddress(), internalUser.getEmailAddress()) || this.remoteDirectory.supportsInactiveAccounts() && remoteUser.isActive() != internalUser.isActive();
    }

    private boolean hasChanged(Group remoteGroup, Group internalGroup) {
        return this.different(remoteGroup.getDescription(), internalGroup.getDescription());
    }

    private boolean different(String remoteString, String internalString) {
        if (StringUtils.isEmpty((String)remoteString)) {
            return StringUtils.isNotEmpty((String)internalString);
        }
        return !InternalEntityUtils.truncateValue((String)remoteString).equals(internalString);
    }

    private UserTemplate makeUserTemplate(User user) {
        UserTemplate template = new UserTemplate(user);
        template.setFirstName(user.getFirstName());
        template.setLastName(user.getLastName());
        template.setDisplayName(user.getDisplayName());
        template.setEmailAddress(user.getEmailAddress());
        return template;
    }

    private GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUserMembershipsForGroup(Group group, List<String> remoteUsers) throws OperationFailedException {
        block27: {
            TimerStack.push();
            try {
                if (this.ignoreGroupOnSynchroniseMemberships(group)) {
                    return;
                }
                HashSet<String> usersToAdd = new HashSet<String>();
                HashSet<String> usersToRemove = new HashSet<String>();
                try {
                    TimerStack.push();
                    this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.user.memberships", new Serializable[]{Integer.valueOf(remoteUsers.size()), group.getName()});
                    logger.debug("synchronising [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ]");
                    List internalMembers = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
                    logger.debug("internal directory has [ " + internalMembers.size() + " ] members");
                    for (String remoteUser : remoteUsers) {
                        if (internalMembers.contains(remoteUser)) continue;
                        usersToAdd.add(remoteUser);
                    }
                    for (String internalUser : internalMembers) {
                        if (remoteUsers.contains(internalUser)) continue;
                        usersToRemove.add(internalUser);
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
                }
                logger.debug("adding [ " + usersToAdd.size() + " ] users to group [ " + group.getName() + " ]");
                logger.debug("removing [ " + usersToRemove.size() + " ] users from group [ " + group.getName() + " ]");
                if (!usersToAdd.isEmpty()) {
                    int usersAdded;
                    Collection failedUsernames = null;
                    try {
                        TimerStack.push();
                        failedUsernames = this.internalDirectory.addAllUsersToGroup(usersToAdd, group.getName());
                        if (!failedUsernames.isEmpty()) {
                            logger.warn("Could not add the following missing users to group [ " + group.getName() + " ]: " + failedUsernames);
                        }
                        usersAdded = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                    }
                    catch (GroupNotFoundException e) {
                        int usersAdded2;
                        try {
                            logger.warn("Could not add users to group. Group [" + group.getName() + "] was not found.", (Throwable)e);
                            usersAdded2 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                        }
                        catch (Throwable throwable) {
                            int usersAdded3 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                            logger.info(TimerStack.pop("added [ " + usersAdded3 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                            throw throwable;
                        }
                        logger.info(TimerStack.pop("added [ " + usersAdded2 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                    }
                    logger.info(TimerStack.pop("added [ " + usersAdded + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                }
                if (usersToRemove.isEmpty()) break block27;
                int failureCount = 0;
                try {
                    TimerStack.push();
                    for (String username : usersToRemove) {
                        try {
                            this.internalDirectory.removeUserFromGroup(username, group.getName());
                        }
                        catch (UserNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. User was not found.", (Throwable)e);
                        }
                        catch (GroupNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. Group was not found.", (Throwable)e);
                        }
                        catch (MembershipNotFoundException e) {
                        }
                        catch (ReadOnlyGroupException e) {
                            ++failureCount;
                            logger.info("Could not remove user [" + username + "] from read-only group [" + group.getName() + "].", (Throwable)e);
                        }
                    }
                }
                finally {
                    int usersRemoved = usersToRemove.size() - failureCount;
                    logger.info(TimerStack.pop("removed [ " + usersRemoved + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
                }
            }
            finally {
                logger.debug(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ] in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncGroupMembershipsForGroup(Group parentGroup, List<String> remoteGroups) throws OperationFailedException {
        block29: {
            if (this.ignoreGroupOnSynchroniseMemberships(parentGroup)) {
                return;
            }
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.group.memberships", new Serializable[]{Integer.valueOf(remoteGroups.size()), parentGroup.getName()});
            TimerStack.push();
            try {
                logger.debug("synchronising [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ]");
                ArrayList<String> groupsToAdd = new ArrayList<String>();
                ArrayList<String> groupsToRemove = new ArrayList<String>();
                try {
                    TimerStack.push();
                    List internalGroups = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroup.getName()).returningAtMost(-1));
                    for (String remoteGroup : remoteGroups) {
                        if (internalGroups.contains(remoteGroup)) continue;
                        groupsToAdd.add(remoteGroup);
                    }
                    for (String internalGroup : internalGroups) {
                        if (remoteGroups.contains(internalGroup)) continue;
                        groupsToRemove.add(internalGroup);
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
                }
                logger.debug("adding [ " + groupsToAdd.size() + " ] group members from group [ " + parentGroup.getName() + " ]");
                logger.debug("removing [ " + groupsToRemove.size() + " ] group members to group [ " + parentGroup.getName() + " ]");
                if (!groupsToAdd.isEmpty()) {
                    int failureCount = 0;
                    try {
                        TimerStack.push();
                        for (String groupname : groupsToAdd) {
                            try {
                                this.internalDirectory.addGroupToGroup(groupname, parentGroup.getName());
                            }
                            catch (GroupNotFoundException e) {
                                ++failureCount;
                                logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                            }
                            catch (InvalidMembershipException e) {
                                ++failureCount;
                                logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                            }
                            catch (ReadOnlyGroupException e) {
                                ++failureCount;
                                logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. " + e.getGroupName() + " is a read-only group.", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        int groupsAdded = groupsToAdd.size() - failureCount;
                        logger.info(TimerStack.pop("added [ " + groupsAdded + " ] group members to [ " + parentGroup.getName() + " ] in [ {0} ]"));
                    }
                }
                if (groupsToRemove.isEmpty()) break block29;
                int failureCount = 0;
                try {
                    TimerStack.push();
                    for (String groupname : groupsToRemove) {
                        try {
                            this.internalDirectory.removeGroupFromGroup(groupname, parentGroup.getName());
                        }
                        catch (GroupNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                        }
                        catch (InvalidMembershipException e) {
                            ++failureCount;
                            logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                        }
                        catch (MembershipNotFoundException e) {
                            ++failureCount;
                            logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership already doesn't exist", (Throwable)e);
                        }
                        catch (ReadOnlyGroupException e) {
                            ++failureCount;
                            logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. " + e.getGroupName() + " is a read-only group.", (Throwable)e);
                        }
                    }
                }
                finally {
                    int groupsRemoved = groupsToRemove.size() - failureCount;
                    logger.info(TimerStack.pop("removed [ " + groupsRemoved + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
                }
            }
            finally {
                logger.debug(TimerStack.pop("synchronised [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ] in [ {0} ]"));
            }
        }
    }

    private boolean ignoreGroupOnSynchroniseMemberships(Group remoteGroup) throws OperationFailedException {
        try {
            InternalDirectoryGroup internalGroup = this.internalDirectory.findGroupByName(remoteGroup.getName());
            return remoteGroup.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP || internalGroup.isLocal();
        }
        catch (GroupNotFoundException ex) {
            return true;
        }
    }

    private AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> getUsersToAddAndUpdate(List<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        HashSet usersToAdd = Sets.newHashSet();
        HashSet usersToUpdate = Sets.newHashSet();
        int count = 0;
        Map<String, TimestampedUser> users = this.findUsersUpdatedBefore(syncStartDate);
        logger.info("scanning [ {} ] users to add or update", (Object)remoteUsers.size());
        for (User user : remoteUsers) {
            if (remoteUsers.size() > 100 && count % 100 == 0) {
                logger.info("scanned [ {}% ] users", (Object)Percentage.get((int)count, (int)remoteUsers.size()));
            }
            ++count;
            TimestampedUser internalUser = users.get(user.getName());
            if (internalUser != null) {
                if (this.hasChanged(user, (User)internalUser)) {
                    UserTemplate userToUpdate = this.makeUserTemplate(user);
                    if (!this.remoteDirectory.supportsInactiveAccounts()) {
                        userToUpdate.setActive(internalUser.isActive());
                    }
                    usersToUpdate.add(userToUpdate);
                    continue;
                }
                logger.trace("user [ {} ] unmodified, skipping", (Object)user.getName());
                continue;
            }
            logger.debug("user [ {} ] not found, adding", (Object)user.getName());
            usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.makeUserTemplate(user), PasswordCredential.encrypted((String)"nopass")));
        }
        return new AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate>(usersToAdd, usersToUpdate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddUpdateSets<A, U> {
        private final Set<A> toAddSet;
        private final Set<U> toUpdateSet;

        private AddUpdateSets(Set<A> addSet, Set<U> updateSet) {
            this.toAddSet = addSet;
            this.toUpdateSet = updateSet;
        }

        private Set<A> getToAddSet() {
            return this.toAddSet;
        }

        private Set<U> getToUpdateSet() {
            return this.toUpdateSet;
        }
    }
}

