/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.AliasQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatingApplicationService
implements ApplicationService {
    private final ApplicationService applicationService;
    private final AliasManager aliasManager;

    public TranslatingApplicationService(ApplicationService applicationService, AliasManager aliasManager) {
        this.applicationService = applicationService;
        this.aliasManager = aliasManager;
    }

    public User authenticateUser(Application application, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        User user = this.applicationService.authenticateUser(application, unaliasedUsername, passwordCredential);
        return this.buildApplicationUser(application, user);
    }

    public boolean isUserAuthorised(Application application, String username) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.applicationService.isUserAuthorised(application, unaliasedUsername);
    }

    public void addAllUsers(Application application, Collection<UserTemplateWithCredentialAndAttributes> users) throws ApplicationPermissionException, OperationFailedException, BulkAddFailedException {
        this.applicationService.addAllUsers(application, users);
    }

    public User findUserByName(Application application, String name) throws UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, name);
        User user = this.applicationService.findUserByName(application, unaliasedUsername);
        return this.buildApplicationUser(application, user);
    }

    public UserWithAttributes findUserWithAttributesByName(Application application, String name) throws UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, name);
        UserWithAttributes user = this.applicationService.findUserWithAttributesByName(application, unaliasedUsername);
        return this.buildApplicationUserWithAttributes(application, user, name);
    }

    public User addUser(Application application, UserTemplate user, PasswordCredential credential) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException {
        return this.buildApplicationUser(application, this.applicationService.addUser(application, user, credential));
    }

    public User updateUser(Application application, UserTemplate user) throws InvalidUserException, OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, user.getName());
        UserTemplate unaliasedUser = new UserTemplate((User)user);
        unaliasedUser.setName(unaliasedUsername);
        User updatedUser = this.applicationService.updateUser(application, unaliasedUser);
        return this.buildApplicationUser(application, updatedUser);
    }

    public void updateUserCredential(Application application, String username, PasswordCredential credential) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.updateUserCredential(application, unaliasedUsername, credential);
    }

    public void resetUserCredential(Application application, String username) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.resetUserCredential(application, unaliasedUsername);
    }

    public void storeUserAttributes(Application application, String username, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.storeUserAttributes(application, unaliasedUsername, attributes);
    }

    public void removeUserAttributes(Application application, String username, String attributeName) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.removeUserAttributes(application, unaliasedUsername, attributeName);
    }

    public void removeUser(Application application, String user) throws OperationFailedException, UserNotFoundException, ApplicationPermissionException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, user);
        this.applicationService.removeUser(application, unaliasedUsername);
    }

    public <T> List<T> searchUsers(Application application, EntityQuery<T> query) {
        if (!application.isAliasingEnabled()) {
            return this.buildApplicationList(application, this.applicationService.searchUsers(application, query), query.getReturnType(), query.getEntityDescriptor());
        }
        EntityQuery<User> userQuery = this.convertToUnboundUserQuery((Query<?>)query);
        Collection<User> users = this.searchUsersInternal(application, userQuery, new UserSearcher(){

            @Override
            public List<User> searchUsers(Application application, EntityQuery<User> query) {
                return TranslatingApplicationService.this.applicationService.searchUsers(application, query);
            }
        });
        List<User> applicationUserList = this.buildApplicationList(application, users, User.class, EntityDescriptor.user());
        List<User> uniqueUserList = this.pruneDuplicates(applicationUserList);
        return this.convertToType(SearchResultsUtil.constrainResults(uniqueUserList, (int)query.getStartIndex(), (int)query.getMaxResults()), query.getReturnType());
    }

    public List<User> searchUsersAllowingDuplicateNames(Application application, EntityQuery<User> query) {
        if (!application.isAliasingEnabled()) {
            return this.buildApplicationList(application, this.applicationService.searchUsersAllowingDuplicateNames(application, query), query.getReturnType(), query.getEntityDescriptor());
        }
        EntityQuery<User> userQuery = this.convertToUnboundUserQuery((Query<?>)query);
        Collection<User> results = this.searchUsersInternal(application, userQuery, new UserSearcher(){

            @Override
            public List<User> searchUsers(Application application, EntityQuery<User> query) {
                return TranslatingApplicationService.this.applicationService.searchUsersAllowingDuplicateNames(application, query);
            }
        });
        List<User> applicationList = this.buildApplicationList(application, results, query.getReturnType(), query.getEntityDescriptor());
        return SearchResultsUtil.constrainResults(applicationList, (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    public Group findGroupByName(Application application, String name) throws GroupNotFoundException {
        return this.buildApplicationGroup(application, this.applicationService.findGroupByName(application, name));
    }

    public GroupWithAttributes findGroupWithAttributesByName(Application application, String name) throws GroupNotFoundException {
        return this.buildApplicationGroupWithAttributes(application, this.applicationService.findGroupWithAttributesByName(application, name));
    }

    public Group addGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException {
        return this.buildApplicationGroup(application, this.applicationService.addGroup(application, group));
    }

    public Group updateGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        return this.buildApplicationGroup(application, this.applicationService.updateGroup(application, group));
    }

    public void storeGroupAttributes(Application application, String groupname, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.applicationService.storeGroupAttributes(application, groupname, attributes);
    }

    public void removeGroupAttributes(Application application, String groupname, String attributeName) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.applicationService.removeGroupAttributes(application, groupname, attributeName);
    }

    public void removeGroup(Application application, String group) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException {
        this.applicationService.removeGroup(application, group);
    }

    public <T> List<T> searchGroups(Application application, EntityQuery<T> query) {
        return this.buildApplicationList(application, this.applicationService.searchGroups(application, query), query.getReturnType(), query.getEntityDescriptor());
    }

    public void addUserToGroup(Application application, String username, String groupName) throws OperationFailedException, UserNotFoundException, GroupNotFoundException, ApplicationPermissionException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.addUserToGroup(application, unaliasedUsername, groupName);
    }

    public void addGroupToGroup(Application application, String childGroupName, String parentGroupName) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidMembershipException {
        this.applicationService.addGroupToGroup(application, childGroupName, parentGroupName);
    }

    public void removeUserFromGroup(Application application, String username, String groupName) throws OperationFailedException, GroupNotFoundException, UserNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.applicationService.removeUserFromGroup(application, unaliasedUsername, groupName);
    }

    public void removeGroupFromGroup(Application application, String childGroup, String parentGroup) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        this.applicationService.removeGroupFromGroup(application, childGroup, parentGroup);
    }

    public boolean isUserDirectGroupMember(Application application, String username, String groupName) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.applicationService.isUserDirectGroupMember(application, unaliasedUsername, groupName);
    }

    public boolean isGroupDirectGroupMember(Application application, String childGroup, String parentGroup) {
        return this.applicationService.isGroupDirectGroupMember(application, childGroup, parentGroup);
    }

    public boolean isUserNestedGroupMember(Application application, String username, String groupName) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.applicationService.isUserNestedGroupMember(application, unaliasedUsername, groupName);
    }

    public boolean isGroupNestedGroupMember(Application application, String childGroup, String parentGroup) {
        return this.applicationService.isGroupNestedGroupMember(application, childGroup, parentGroup);
    }

    public <T> List<T> searchDirectGroupRelationships(Application application, MembershipQuery<T> query) {
        MembershipQuery<T> unaliasedQuery = this.buildUnaliasedMembershipQuery(application, query);
        List result = this.applicationService.searchDirectGroupRelationships(application, unaliasedQuery);
        return this.buildApplicationList(application, result, query.getReturnType(), query.getEntityToReturn());
    }

    public <T> List<T> searchNestedGroupRelationships(Application application, MembershipQuery<T> query) {
        MembershipQuery<T> unaliasedQuery = this.buildUnaliasedMembershipQuery(application, query);
        List result = this.applicationService.searchNestedGroupRelationships(application, unaliasedQuery);
        return this.buildApplicationList(application, result, query.getReturnType(), query.getEntityToReturn());
    }

    private <T> List<T> convertToType(List<User> applicationList, Class<T> returnType) {
        QueryUtils.checkAssignableFrom(returnType, (Class[])new Class[]{String.class, User.class});
        if (String.class.isAssignableFrom(returnType)) {
            return SearchResultsUtil.convertEntitiesToNames(applicationList);
        }
        return applicationList;
    }

    private Collection<User> searchUsersInternal(Application application, EntityQuery<User> query, UserSearcher searcher) {
        SearchRestriction searchRestrictions = this.replaceAliasesWithUsernames(application, query.getSearchRestriction());
        EntityQuery aliasedQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)searchRestrictions, (int)query.getStartIndex(), (int)query.getMaxResults());
        return this.doSearchUsers(application, (EntityQuery<User>)aliasedQuery, searcher);
    }

    private List<User> pruneDuplicates(Collection<User> users) {
        TreeSet<User> pruned = new TreeSet<User>(NameComparator.of(User.class));
        pruned.addAll(users);
        return new ArrayList<User>(pruned);
    }

    private SearchRestriction replaceAliasesWithUsernames(Application application, SearchRestriction restrictions) {
        PropertyRestriction restriction;
        if (restrictions instanceof BooleanRestriction) {
            BooleanRestriction restriction2 = (BooleanRestriction)restrictions;
            ArrayList<SearchRestriction> childRestrictions = new ArrayList<SearchRestriction>(restriction2.getRestrictions().size());
            for (SearchRestriction childRestriction : restriction2.getRestrictions()) {
                childRestrictions.add(this.replaceAliasesWithUsernames(application, childRestriction));
            }
            return new BooleanRestrictionImpl(restriction2.getBooleanLogic(), childRestrictions);
        }
        if (restrictions instanceof PropertyRestriction && UserTermKeys.USERNAME.equals((restriction = (PropertyRestriction)restrictions).getProperty()) && restriction.getMatchMode().isExact()) {
            String username = this.aliasManager.findUsernameByAlias(application, (String)restriction.getValue());
            return new TermRestriction(UserTermKeys.USERNAME, restriction.getMatchMode(), (Object)username);
        }
        return restrictions;
    }

    private Collection<User> doSearchUsers(Application application, EntityQuery<User> query, UserSearcher searcher) {
        SearchRestriction restrictions = query.getSearchRestriction();
        if (this.containsNonExactUsernameRestrictions(restrictions)) {
            if (restrictions instanceof BooleanRestriction) {
                BooleanRestriction restriction = (BooleanRestriction)restrictions;
                ResultCombiner<User> combiner = new ResultCombiner<User>(restriction.getBooleanLogic());
                for (SearchRestriction childRestriction : restriction.getRestrictions()) {
                    EntityQuery childQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)childRestriction, (int)0, (int)-1);
                    Collection<User> childResults = this.doSearchUsers(application, (EntityQuery<User>)childQuery, searcher);
                    combiner.combine(childResults);
                }
                return combiner.getValues();
            }
            if (restrictions instanceof PropertyRestriction) {
                PropertyRestriction usernameRestriction = (PropertyRestriction)restrictions;
                return this.searchWithNonExactUsernameRestriction(application, (PropertyRestriction<String>)usernameRestriction, searcher);
            }
            throw new IllegalArgumentException("Unexpected restriction");
        }
        return searcher.searchUsers(application, query);
    }

    private boolean containsNonExactUsernameRestrictions(SearchRestriction restrictions) {
        PropertyRestriction restriction;
        if (restrictions instanceof BooleanRestriction) {
            BooleanRestriction restriction2 = (BooleanRestriction)restrictions;
            for (SearchRestriction childRestriction : restriction2.getRestrictions()) {
                if (!this.containsNonExactUsernameRestrictions(childRestriction)) continue;
                return true;
            }
        } else if (restrictions instanceof PropertyRestriction && UserTermKeys.USERNAME.equals((restriction = (PropertyRestriction)restrictions).getProperty()) && !restriction.getMatchMode().isExact()) {
            return true;
        }
        return false;
    }

    private Collection<User> searchWithNonExactUsernameRestriction(Application application, PropertyRestriction<String> restriction, UserSearcher searcher) {
        ArrayList<User> users = new ArrayList<User>();
        BooleanRestrictionImpl aliasRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{new TermRestriction(AliasTermKeys.ALIAS, restriction.getMatchMode(), restriction.getValue()), new TermRestriction(AliasTermKeys.APPLICATION_ID, MatchMode.EXACTLY_MATCHES, (Object)application.getId())});
        AliasQuery aliasQuery = new AliasQuery((SearchRestriction)aliasRestriction, 0, -1);
        for (String aliasMatchUsername : this.aliasManager.search((EntityQuery)aliasQuery)) {
            EntityQuery aliasedUserQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)aliasMatchUsername), (int)0, (int)-1);
            users.addAll(searcher.searchUsers(application, (EntityQuery<User>)aliasedUserQuery));
        }
        UserQuery userQuery = new UserQuery(User.class, restriction, 0, -1);
        List<User> matchingUsers = searcher.searchUsers(application, (EntityQuery<User>)userQuery);
        for (User user : matchingUsers) {
            if (this.aliasExists(application, user)) continue;
            users.add(user);
        }
        return users;
    }

    private boolean aliasExists(Application application, User user) {
        String alias = this.aliasManager.findAliasByUsername(application, user.getName());
        return !user.getName().equalsIgnoreCase(alias);
    }

    private <T> MembershipQuery<T> buildUnaliasedMembershipQuery(Application application, MembershipQuery<T> query) {
        if (query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            String username = this.aliasManager.findUsernameByAlias(application, query.getEntityNameToMatch());
            return QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)username);
        }
        return query;
    }

    private <T> List<T> buildApplicationList(Application application, Collection<T> collection, Class<T> returnType, EntityDescriptor entityToReturn) {
        if (EntityDescriptor.user().equals((Object)entityToReturn) && String.class.isAssignableFrom(returnType)) {
            return this.buildApplicationUsernames(application, collection);
        }
        if (User.class.isAssignableFrom(returnType)) {
            return this.buildApplicationUsers(application, collection);
        }
        if (EntityDescriptor.group().equals((Object)entityToReturn) && String.class.isAssignableFrom(returnType)) {
            return this.buildApplicationGroupNames(application, collection);
        }
        if (Group.class.isAssignableFrom(returnType)) {
            return this.buildApplicationGroups(application, collection);
        }
        return this.asList(collection);
    }

    private <T> List<T> asList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    private List<String> buildApplicationUsernames(Application application, Collection<String> usernames) {
        ArrayList<String> applicationUsernames = new ArrayList<String>(usernames.size());
        for (String username : usernames) {
            String alias = this.aliasManager.findAliasByUsername(application, username);
            String applicationUsername = application.isLowerCaseOutput() ? IdentifierUtils.toLowerCase((String)alias) : alias;
            applicationUsernames.add(applicationUsername);
        }
        Collections.sort(applicationUsernames);
        return applicationUsernames;
    }

    private List<User> buildApplicationUsers(Application application, Collection<User> users) {
        ArrayList<User> applicationUsers = new ArrayList<User>(users.size());
        for (User user : users) {
            applicationUsers.add(this.buildApplicationUser(application, user));
        }
        Collections.sort(applicationUsers, new UserComparator(application));
        return applicationUsers;
    }

    private User buildApplicationUser(Application application, User user) {
        String applicationUsername;
        String alias = this.aliasManager.findAliasByUsername(application, user.getName());
        String string = applicationUsername = application.isLowerCaseOutput() ? IdentifierUtils.toLowerCase((String)alias) : alias;
        if (user.getName().equals(applicationUsername)) {
            return user;
        }
        UserTemplate applicationUser = new UserTemplate(user);
        applicationUser.setName(applicationUsername);
        return applicationUser;
    }

    private UserWithAttributes buildApplicationUserWithAttributes(Application application, UserWithAttributes user, String alias) {
        String applicationUsername;
        String string = applicationUsername = application.isLowerCaseOutput() ? IdentifierUtils.toLowerCase((String)alias) : alias;
        if (user.getName().equals(applicationUsername)) {
            return user;
        }
        UserTemplateWithAttributes applicationUser = new UserTemplateWithAttributes(user);
        applicationUser.setName(applicationUsername);
        return applicationUser;
    }

    private List<String> buildApplicationGroupNames(Application application, Collection<String> groupNames) {
        if (application.isLowerCaseOutput()) {
            ArrayList<String> lowerCaseGroupNames = new ArrayList<String>(groupNames.size());
            for (String groupName : groupNames) {
                lowerCaseGroupNames.add(IdentifierUtils.toLowerCase((String)groupName));
            }
            return lowerCaseGroupNames;
        }
        return this.asList(groupNames);
    }

    private List<Group> buildApplicationGroups(Application application, Collection<Group> groups) {
        if (application.isLowerCaseOutput()) {
            ArrayList<Group> lowerCaseGroups = new ArrayList<Group>(groups.size());
            for (Group group : groups) {
                lowerCaseGroups.add(this.buildApplicationGroup(application, group));
            }
            return lowerCaseGroups;
        }
        return this.asList(groups);
    }

    private Group buildApplicationGroup(Application application, Group group) {
        if (application.isLowerCaseOutput()) {
            GroupTemplate groupTemplate = new GroupTemplate(group);
            groupTemplate.setName(IdentifierUtils.toLowerCase((String)group.getName()));
            return groupTemplate;
        }
        return group;
    }

    private GroupWithAttributes buildApplicationGroupWithAttributes(Application application, GroupWithAttributes group) {
        if (application.isLowerCaseOutput()) {
            GroupTemplateWithAttributes groupTemplate = new GroupTemplateWithAttributes(group);
            groupTemplate.setName(IdentifierUtils.toLowerCase((String)group.getName()));
            return groupTemplate;
        }
        return group;
    }

    private EntityQuery<User> convertToUnboundUserQuery(Query<?> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, User.class});
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserComparator
    implements Comparator<User> {
        private final Map<Long, Integer> directoryIdToIndex = new HashMap<Long, Integer>();

        UserComparator(Application application) {
            for (int i = 0; i < application.getDirectoryMappings().size(); ++i) {
                this.directoryIdToIndex.put(((DirectoryMapping)application.getDirectoryMappings().get(i)).getDirectory().getId(), i);
            }
        }

        @Override
        public int compare(User o1, User o2) {
            int nameComparison = NameComparator.of(User.class).compare(o1, o2);
            if (nameComparison != 0) {
                return nameComparison;
            }
            Integer directoryOrderO1 = this.directoryIdToIndex.get(o1.getDirectoryId());
            Integer directoryOrderO2 = this.directoryIdToIndex.get(o2.getDirectoryId());
            return directoryOrderO1.compareTo(directoryOrderO2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface UserSearcher {
        public List<User> searchUsers(Application var1, EntityQuery<User> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultCombiner<T> {
        private final BooleanRestriction.BooleanLogic logic;
        private Set<T> values = null;

        ResultCombiner(BooleanRestriction.BooleanLogic logic) {
            this.logic = logic;
        }

        void combine(Collection<T> newValues) {
            if (this.values == null) {
                this.values = Sets.newHashSet(newValues);
            } else if (this.logic == BooleanRestriction.BooleanLogic.AND) {
                this.values.retainAll(newValues);
            } else if (this.logic == BooleanRestriction.BooleanLogic.OR) {
                this.values.addAll(newValues);
            }
        }

        Set<T> getValues() {
            return this.values == null ? Collections.emptySet() : this.values;
        }
    }
}

