/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserAuthenticationFailedInvalidAuthenticationEvent;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.EntityComparator;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServiceGeneric
implements ApplicationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DirectoryManager directoryManager;
    private final PermissionManager permissionManager;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final EventPublisher eventPublisher;

    public ApplicationServiceGeneric(DirectoryManager directoryManager, PermissionManager permissionManager, DirectoryInstanceLoader directoryInstanceLoader, EventPublisher eventPublisher) {
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.eventPublisher = eventPublisher;
    }

    public com.atlassian.crowd.model.user.User authenticateUser(Application application, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException {
        if (application.getDirectoryMappings() == null || application.getDirectoryMappings().isEmpty()) {
            throw new InvalidAuthenticationException("Unable to authenticate user as there are no directories mapped to the application " + application.getName());
        }
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.authenticateUser(directory.getId().longValue(), username, passwordCredential);
            }
            catch (UserNotFoundException e) {
            }
            catch (InvalidAuthenticationException e) {
                this.eventPublisher.publish((Object)new UserAuthenticationFailedInvalidAuthenticationEvent((Object)this, directory, username));
                throw e;
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        throw new InvalidAuthenticationException("User with username <" + username + "> does not exist in any of the assigned directories of application <" + application.getName() + ">");
    }

    public boolean isUserAuthorised(Application application, String username) {
        try {
            com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
            return this.isAllowedToAuthenticate(username, user.getDirectoryId(), application);
        }
        catch (OperationFailedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping removed while determining if the user is authorised to authenticate with an application");
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    public void addAllUsers(Application application, Collection<UserTemplateWithCredentialAndAttributes> userTemplates) throws ApplicationPermissionException, OperationFailedException, BulkAddFailedException {
        this.logger.debug("Adding users for application {}", (Object)application);
        HashSet<String> failedUsers = new HashSet<String>();
        HashSet<String> existingUsers = new HashSet<String>();
        Directory directory = this.findFirstDirectoryWithCreateUserPermission(application);
        if (directory == null) {
            throw new ApplicationPermissionException("Application '" + application.getName() + "' has no directories that allow adding of users.");
        }
        try {
            for (UserTemplateWithCredentialAndAttributes userTemplate : userTemplates) {
                userTemplate.setDirectoryId(directory.getId().longValue());
            }
            BulkAddResult result = this.directoryManager.addAllUsers(directory.getId().longValue(), userTemplates, false);
            for (com.atlassian.crowd.model.user.User user : result.getExistingEntities()) {
                existingUsers.add(user.getName());
            }
            for (com.atlassian.crowd.model.user.User user : result.getFailedEntities()) {
                failedUsers.add(user.getName());
            }
        }
        catch (DirectoryPermissionException ex) {
            throw new ApplicationPermissionException("Permission Exception when trying to add users to directory '" + directory.getName() + "'. " + ex.getMessage(), (Throwable)ex);
        }
        catch (DirectoryNotFoundException ex) {
            throw new OperationFailedException("Directory Not Found when trying to add users to directory '" + directory.getName() + "'.", (Throwable)ex);
        }
        if (failedUsers.size() > 0 || existingUsers.size() > 0) {
            throw new BulkAddFailedException(failedUsers, existingUsers);
        }
    }

    private Directory findFirstDirectoryWithCreateUserPermission(Application application) {
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, OperationType.CREATE_USER)) continue;
            return directory;
        }
        return null;
    }

    public com.atlassian.crowd.model.user.User findUserByName(Application application, String name) throws UserNotFoundException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findUserByName(directory.getId().longValue(), name);
            }
            catch (UserNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new UserNotFoundException(name);
    }

    private com.atlassian.crowd.model.user.User fastFailingFindUser(Application application, String name) throws UserNotFoundException, OperationFailedException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findUserByName(directory.getId().longValue(), name);
            }
            catch (UserNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        throw new UserNotFoundException(name);
    }

    public UserWithAttributes findUserWithAttributesByName(Application application, String name) throws UserNotFoundException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findUserWithAttributesByName(directory.getId().longValue(), name);
            }
            catch (UserNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        throw new UserNotFoundException(name);
    }

    public com.atlassian.crowd.model.user.User addUser(Application application, UserTemplate user, PasswordCredential credential) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException {
        this.logger.debug("Adding user <{}> for application <{}>", (Object)user.getName(), (Object)application.getName());
        try {
            this.fastFailingFindUser(application, user.getName());
            throw new InvalidUserException((User)user, "User already exists");
        }
        catch (UserNotFoundException e) {
            Directory directory = this.findFirstDirectoryWithCreateUserPermission(application);
            if (directory == null) {
                throw new ApplicationPermissionException("Application '" + application.getName() + "' has no directories that allow adding of users.");
            }
            try {
                user.setDirectoryId(directory.getId().longValue());
                com.atlassian.crowd.model.user.User newUser = this.directoryManager.addUser(directory.getId().longValue(), user, credential);
                this.logger.debug("User '{}' was added to directory '{}'.", new Object[]{user.getName(), directory.getName(), user.getName()});
                return newUser;
            }
            catch (DirectoryPermissionException dpe) {
                throw new ApplicationPermissionException("Permission Exception when trying to add user '" + user.getName() + "' to directory '" + directory.getName() + "'. " + dpe.getMessage(), (Throwable)dpe);
            }
            catch (DirectoryNotFoundException de) {
                throw new OperationFailedException("Directory not found when trying to add user '" + user.getName() + "' to directory '" + directory.getName() + "'.", (Throwable)de);
            }
            catch (UserAlreadyExistsException e2) {
                throw new OperationFailedException("User " + user.getName() + " already exists.");
            }
        }
    }

    public com.atlassian.crowd.model.user.User updateUser(Application application, UserTemplate user) throws InvalidUserException, OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        this.logger.debug("Updating user <{}> for application <{}>", (Object)user.getName(), (Object)application.getName());
        com.atlassian.crowd.model.user.User existingUser = this.fastFailingFindUser(application, user.getName());
        if (user.getDirectoryId() <= 0L) {
            user.setDirectoryId(existingUser.getDirectoryId());
        } else if (user.getDirectoryId() != existingUser.getDirectoryId()) {
            throw new InvalidUserException((User)user, "Attempted to update user '" + user.getName() + "' with invalid directory ID " + user.getDirectoryId() + ", we expected ID " + existingUser.getDirectoryId() + ".");
        }
        Directory directory = this.findDirectoryById(existingUser.getDirectoryId());
        if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            throw new ApplicationPermissionException("Cannot update user '" + user.getName() + "' because directory '" + directory.getName() + "' does not allow updates.");
        }
        try {
            return this.directoryManager.updateUser(directory.getId().longValue(), user);
        }
        catch (DirectoryPermissionException dpe) {
            throw new ApplicationPermissionException("Permission Exception when trying to update user '" + user.getName() + "' in directory '" + directory.getName() + "'.", (Throwable)dpe);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while updating user: " + e.getMessage());
        }
    }

    public void updateUserCredential(Application application, String username, PasswordCredential credential) throws OperationFailedException, InvalidCredentialException, ApplicationPermissionException, UserNotFoundException {
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            try {
                this.directoryManager.updateUserCredential(user.getDirectoryId(), username, credential);
            }
            catch (DirectoryPermissionException e) {
                throw new ApplicationPermissionException((Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while updating user credential: " + e.getMessage());
            }
        } else {
            throw new ApplicationPermissionException("Not allowed to update user '" + user.getName() + "' in directory '" + directory.getName() + "'.");
        }
    }

    public void resetUserCredential(Application application, String username) throws OperationFailedException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException, UserNotFoundException {
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            try {
                this.directoryManager.resetPassword(user.getDirectoryId(), username);
            }
            catch (DirectoryPermissionException e) {
                throw new ApplicationPermissionException((Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while resetting the user credential: " + e.getMessage());
            }
        } else {
            throw new ApplicationPermissionException("Not allowed to update user '" + user.getName() + "' in directory '" + directory.getName() + "'.");
        }
    }

    public void storeUserAttributes(Application application, String username, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        this.logger.debug("Storing user attributes for user <{}> and application <{}>", (Object)username, (Object)application.getName());
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new ApplicationPermissionException("Not allowed to update user attributes '" + user.getName() + "' in directory '" + directory.getName() + "'.");
        }
        try {
            this.directoryManager.storeUserAttributes(directory.getId().longValue(), username, attributes);
        }
        catch (DirectoryPermissionException ex) {
            throw new ApplicationPermissionException((Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while storing the user attributes: " + e.getMessage());
        }
    }

    public void removeUserAttributes(Application application, String username, String attributeName) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        this.logger.debug("Removing user attributes for user <{}> and application <{}>", (Object)username, (Object)application.getName());
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER_ATTRIBUTE)) {
            throw new ApplicationPermissionException("Not allowed to update user attributes '" + user.getName() + "' in directory '" + directory.getName() + "'.");
        }
        try {
            this.directoryManager.removeUserAttributes(directory.getId().longValue(), username, attributeName);
        }
        catch (DirectoryPermissionException ex) {
            throw new ApplicationPermissionException((Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while removing the user attributes: " + e.getMessage());
        }
    }

    public void removeUser(Application application, String username) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (!this.permissionManager.hasPermission(application, directory, OperationType.DELETE_USER)) {
            throw new ApplicationPermissionException("Not allowed to delete user '" + user.getName() + "' from directory '" + directory.getName() + "'.");
        }
        try {
            this.directoryManager.removeUser(directory.getId().longValue(), username);
        }
        catch (DirectoryPermissionException ex) {
            throw new ApplicationPermissionException((Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while removing the user: " + e.getMessage());
        }
    }

    public <T> List<T> searchUsers(Application application, EntityQuery<T> query) {
        return this.searchUsers(application, query, this.getAggregatingAndSortingComparatorFor(query.getReturnType()));
    }

    public List<com.atlassian.crowd.model.user.User> searchUsersAllowingDuplicateNames(Application application, EntityQuery<com.atlassian.crowd.model.user.User> query) {
        return this.searchUsers(application, query, EntityComparator.of(com.atlassian.crowd.model.user.User.class));
    }

    private <T> List<T> searchUsers(Application application, EntityQuery<T> query, Comparator<? super T> comparator) {
        boolean isAllResults = query.getMaxResults() == -1;
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, com.atlassian.crowd.model.user.User.class});
        TreeSet<T> results = new TreeSet<T>(comparator);
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (isAllResults) {
            totalResults = -1;
        }
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                EntityQuery totalQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)totalResults);
                List users = this.directoryManager.searchUsers(directory.getId().longValue(), totalQuery);
                results.addAll(users);
                if (isAllResults || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList<T>(results), (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    public Group findGroupByName(Application application, String name) throws GroupNotFoundException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findGroupByName(directory.getId().longValue(), name);
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new GroupNotFoundException(name);
    }

    private Group getGroup(Application application, String name) throws OperationFailedException, GroupNotFoundException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findGroupByName(directory.getId().longValue(), name);
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        throw new GroupNotFoundException(name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(Application application, String name) throws GroupNotFoundException {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                return this.directoryManager.findGroupWithAttributesByName(directory.getId().longValue(), name);
            }
            catch (GroupNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        throw new GroupNotFoundException(name);
    }

    public Group addGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException {
        this.logger.debug("Adding group <{}> for application <{}>", (Object)group.getName(), (Object)application.getName());
        try {
            this.getGroup(application, group.getName());
            throw new InvalidGroupException((Group)group, "Group already exists");
        }
        catch (GroupNotFoundException e) {
            OperationType operationType = this.getCreateOperationType((Group)group);
            for (Directory directory : this.getActiveDirectories(application)) {
                if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
                try {
                    group.setDirectoryId(directory.getId().longValue());
                    this.directoryManager.addGroup(directory.getId().longValue(), group);
                }
                catch (DirectoryPermissionException dpe) {
                    this.logger.info("Could not add group <{}> to directory <{}>", (Object)group.getName(), (Object)directory.getName());
                    this.logger.info(dpe.getMessage());
                }
                catch (DirectoryNotFoundException onfe) {
                    this.logger.error(onfe.getMessage(), (Throwable)onfe);
                }
            }
            try {
                return this.getGroup(application, group.getName());
            }
            catch (GroupNotFoundException e2) {
                throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow adding of groups");
            }
        }
    }

    public Group updateGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.logger.debug("Updating group <{}> for application <{}>", (Object)group.getName(), (Object)application.getName());
        Group groupToUpdate = this.getGroup(application, group.getName());
        OperationType operationType = this.getUpdateOperationType(groupToUpdate);
        boolean atleastOneDirectoryHasPermission = false;
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                group.setDirectoryId(directory.getId().longValue());
                this.directoryManager.updateGroup(directory.getId().longValue(), group);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info("Could not update group <{}> to directory <{}>", (Object)group.getName(), (Object)directory.getName());
                this.logger.info(dpe.getMessage());
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (ReadOnlyGroupException e) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(MessageFormatter.format((String)"Could not update group <{}> to directory <{}> because the group is read-only.", (Object)group.getName(), (Object)directory.getName()), (Throwable)e);
            }
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group modifications");
        }
        return this.getGroup(application, group.getName());
    }

    public void storeGroupAttributes(Application application, String groupname, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.logger.debug("Storing group attributes for group <{}> and application <{}>", (Object)groupname, (Object)application.getName());
        Group groupToUpdate = this.getGroup(application, groupname);
        OperationType operationType = this.getUpdateAttributeOperationType(groupToUpdate);
        boolean atleastOneDirectoryHasPermission = false;
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.storeGroupAttributes(directory.getId().longValue(), groupname, attributes);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info("Could not update group <{}> to directory <{}>", (Object)groupname, (Object)directory.getName());
                this.logger.info(dpe.getMessage());
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group attribute modifications");
        }
    }

    public void removeGroupAttributes(Application application, String groupname, String attributeName) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.logger.debug("Removing group attributes for group <{}> and application <{}>", (Object)groupname, (Object)application.getName());
        Group groupToUpdate = this.getGroup(application, groupname);
        boolean atleastOneDirectoryHasPermission = false;
        OperationType operationType = this.getUpdateAttributeOperationType(groupToUpdate);
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeGroupAttributes(directory.getId().longValue(), groupname, attributeName);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info("Could not update group <{}> to directory <{}>", (Object)groupname, (Object)directory.getName());
                this.logger.info(dpe.getMessage());
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group attribute modifications");
        }
    }

    public void removeGroup(Application application, String groupname) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        Group groupToRemove = this.getGroup(application, groupname);
        boolean permissibleByAnyDirectory = false;
        OperationType operationType = this.getDeleteOperationType(groupToRemove);
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeGroup(directory.getId().longValue(), groupname);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info("Could not remove group <{}> from directory <{}>", (Object)groupname, (Object)directory.getName());
            }
            catch (GroupNotFoundException e) {
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (ReadOnlyGroupException e) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(MessageFormatter.format((String)"Could not update group <{}> to directory <{}> because the group is read-only.", (Object)groupname, (Object)directory.getName()), (Throwable)e);
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group removal");
        }
    }

    public <T> List<T> searchGroups(Application application, EntityQuery<T> query) {
        boolean isAllResults;
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class});
        TreeSet<T> results = new TreeSet<T>(this.getAggregatingAndSortingComparatorFor(query.getReturnType()));
        int totalResults = query.getStartIndex() + query.getMaxResults();
        boolean bl = isAllResults = query.getMaxResults() == -1;
        if (isAllResults) {
            totalResults = -1;
        }
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                EntityQuery totalQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)totalResults);
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), totalQuery);
                results.addAll(groups);
                if (isAllResults || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList<T>(results), (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    public void addUserToGroup(Application application, String username, String groupName) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException {
        Group group;
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        try {
            group = this.ensureGroupExistsInDirectory(user.getDirectoryId(), groupName, application);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while adding user to a group: " + e.getMessage());
        }
        OperationType operationType = this.getUpdateOperationType(group);
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (!this.permissionManager.hasPermission(application, directory, operationType)) {
            throw new ApplicationPermissionException("Cannot update group '" + groupName + "' because directory '" + directory.getName() + "' does not allow updates.");
        }
        try {
            this.directoryManager.addUserToGroup(directory.getId().longValue(), username, groupName);
        }
        catch (DirectoryPermissionException ex) {
            throw new ApplicationPermissionException("Permission Exception when trying to update group '" + groupName + "' in directory '" + directory.getName() + "'.", (Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while adding user to a group: " + e.getMessage());
        }
        catch (ReadOnlyGroupException e) {
            throw new ApplicationPermissionException(String.format("Could not add user %s to group %s in directory %s because the it is read-only.", username, groupName, directory.getName()));
        }
    }

    private Directory findDirectoryById(long directoryId) throws ConcurrentModificationException {
        try {
            return this.directoryManager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
        }
    }

    private Group ensureGroupExistsInDirectory(long directoryId, String groupName, Application application) throws GroupNotFoundException, ApplicationPermissionException, OperationFailedException, DirectoryNotFoundException {
        try {
            return this.directoryManager.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException ex) {
            Group group = this.findGroupByName(application, groupName);
            try {
                this.logger.info("Creating group '{}' in directory {} so membership can be added", (Object)groupName, (Object)directoryId);
                return this.directoryManager.addGroup(directoryId, new GroupTemplate(groupName, directoryId, group.getType()));
            }
            catch (DirectoryPermissionException ex2) {
                throw new ApplicationPermissionException("Group '" + groupName + "' does not exist in the directory of the user and cannot be added.");
            }
            catch (InvalidGroupException e) {
                throw new OperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addGroupToGroup(Application application, String childGroupName, String parentGroupName) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException, InvalidMembershipException {
        Group parentGroup = this.getGroup(application, parentGroupName);
        Group childGroup = this.getGroup(application, childGroupName);
        if (parentGroup.getType() != childGroup.getType()) {
            throw new InvalidMembershipException("Cannot add group of type " + childGroup.getType().name() + " to group of type " + parentGroup.getType().name());
        }
        if (childGroupName.equals(parentGroupName)) {
            throw new InvalidMembershipException("Cannot add a group to itself.");
        }
        if (this.isGroupNestedGroupMember(application, parentGroupName, childGroupName)) {
            throw new InvalidMembershipException("Cannot add child group '" + childGroupName + "' to parent group '" + parentGroupName + "' - this would cause a circular dependency.");
        }
        OperationType operationType = this.getUpdateOperationType(parentGroup);
        boolean applicationHasPermission = false;
        boolean success = false;
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            applicationHasPermission = true;
            try {
                this.directoryManager.addGroupToGroup(directory.getId().longValue(), childGroupName, parentGroupName);
                success = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.warn("Could not add child group <{}> to parent group <{}> in directory <{}> - unexpected DirectoryPermissionException", new Object[]{childGroup, parentGroup, directory.getName()});
            }
            catch (NestedGroupsNotSupportedException e) {
                this.logger.debug("Could not add child group <{}> to parent group <{}> in directory <{}> - Nested Groups not supported.", new Object[]{childGroup, parentGroup, directory.getName()});
            }
            catch (GroupNotFoundException e) {
            }
            catch (InvalidMembershipException e) {
                this.logger.info("Could not add child group <{}> to parent group <{}> in directory <{}>: {}", new Object[]{childGroup, parentGroup, directory.getName(), e.getMessage()});
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (ReadOnlyGroupException e) {
                this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
        if (success) {
            return;
        }
        if (applicationHasPermission) {
            throw new ApplicationPermissionException("Could not add child group '" + childGroupName + "' to parent group '" + childGroupName + "'.");
        }
        throw new ApplicationPermissionException("Application '" + application.getName() + "' does not allow group modifications.");
    }

    public void removeUserFromGroup(Application application, String username, String groupName) throws OperationFailedException, ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, GroupNotFoundException {
        Group groupToUpdate;
        com.atlassian.crowd.model.user.User user = this.fastFailingFindUser(application, username);
        try {
            groupToUpdate = this.directoryManager.findGroupByName(user.getDirectoryId(), groupName);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory was removed while processing directory: " + e.getMessage());
        }
        OperationType operationType = this.getUpdateOperationType(groupToUpdate);
        if (!this.isUserDirectGroupMember(application, username, groupName)) {
            throw new MembershipNotFoundException(username, groupName);
        }
        Directory directory = this.findDirectoryById(user.getDirectoryId());
        if (this.permissionManager.hasPermission(application, directory, operationType)) {
            try {
                this.directoryManager.removeUserFromGroup(directory.getId().longValue(), username, groupName);
            }
            catch (DirectoryPermissionException e) {
                throw new ConcurrentModificationException("Directory permissions changed while processing directory: " + e.getMessage());
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while processing directory: " + e.getMessage());
            }
            catch (ReadOnlyGroupException e) {
                throw new ApplicationPermissionException(String.format("Could not add user %s to group %s in directory %s because the it is read-only.", username, groupName, directory.getName()));
            }
        } else {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group modifications");
        }
    }

    public void removeGroupFromGroup(Application application, String childGroup, String parentGroup) throws OperationFailedException, ApplicationPermissionException, MembershipNotFoundException, GroupNotFoundException {
        boolean permissibleByAnyDirectory = false;
        if (!this.isGroupDirectGroupMember(application, childGroup, parentGroup)) {
            throw new MembershipNotFoundException(childGroup, parentGroup);
        }
        Group parentGroupToModify = this.getGroup(application, parentGroup);
        OperationType operationType = this.getUpdateOperationType(parentGroupToModify);
        for (Directory directory : this.getActiveDirectories(application)) {
            if (!this.permissionManager.hasPermission(application, directory, operationType) || !this.getDirectoryImplementation(directory).supportsNestedGroups()) continue;
            try {
                this.directoryManager.removeGroupFromGroup(directory.getId().longValue(), childGroup, parentGroup);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info("Could not remove child group <{}> to parent group <{}> from directory <{}>", new Object[]{childGroup, parentGroup, directory.getName()});
            }
            catch (GroupNotFoundException e) {
                permissibleByAnyDirectory = true;
            }
            catch (InvalidMembershipException e) {
                this.logger.info("Could not remove child group <{}> from parent group <{}> from directory <{}>: {}", new Object[]{childGroup, parentGroup, directory.getName(), e.getMessage()});
            }
            catch (DirectoryNotFoundException e) {
                throw new ConcurrentModificationException("Directory mapping was removed while iterating through directories: " + e.getMessage());
            }
            catch (ReadOnlyGroupException e) {
                this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException("Application \"" + application.getName() + "\" does not allow group modifications");
        }
    }

    public boolean isUserDirectGroupMember(Application application, String username, String groupName) {
        try {
            com.atlassian.crowd.model.user.User user = this.findUserByName(application, username);
            return this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), username, groupName);
        }
        catch (UserNotFoundException e) {
        }
        catch (OperationFailedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while determining if the user is a direct group member: " + e.getMessage());
        }
        return false;
    }

    public boolean isGroupDirectGroupMember(Application application, String childGroup, String parentGroup) {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                if (!this.directoryManager.isGroupDirectGroupMember(directory.getId().longValue(), childGroup, parentGroup)) continue;
                return true;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean isUserNestedGroupMember(Application application, String username, String groupName) {
        try {
            com.atlassian.crowd.model.user.User user = this.findUserByName(application, username);
            return this.directoryManager.isUserNestedGroupMember(user.getDirectoryId(), username, groupName);
        }
        catch (UserNotFoundException e) {
        }
        catch (OperationFailedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while determining if user is a nested group member: " + e.getMessage());
        }
        return false;
    }

    public boolean isGroupNestedGroupMember(Application application, String childGroup, String parentGroup) {
        for (Directory directory : this.getActiveDirectories(application)) {
            try {
                if (!this.directoryManager.isGroupNestedGroupMember(directory.getId().longValue(), childGroup, parentGroup)) continue;
                return true;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public <T> List<T> searchDirectGroupRelationships(Application application, MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, com.atlassian.crowd.model.user.User.class});
        TreeSet<T> results = new TreeSet<T>(this.getAggregatingAndSortingComparatorFor(query.getReturnType()));
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            try {
                com.atlassian.crowd.model.user.User user = this.findUserByName(application, query.getEntityNameToMatch());
                results.addAll(this.doDirectDirectoryMembershipQuery(query, totalResults, user.getDirectoryId()));
            }
            catch (UserNotFoundException e) {}
        } else {
            for (Directory directory : this.getActiveDirectories(application)) {
                results.addAll(this.doDirectDirectoryMembershipQuery(query, totalResults, directory.getId()));
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList<T>(results), (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    private <T> List<T> doDirectDirectoryMembershipQuery(MembershipQuery<T> query, int totalResults, Long directoryId) {
        try {
            MembershipQuery totalQuery = QueryBuilder.createMembershipQuery((int)totalResults, (int)0, (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
            return this.directoryManager.searchDirectGroupRelationships(directoryId.longValue(), totalQuery);
        }
        catch (DirectoryNotFoundException e) {
        }
        catch (OperationFailedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList();
    }

    public <T> List<T> searchNestedGroupRelationships(Application application, MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, com.atlassian.crowd.model.user.User.class});
        TreeSet<T> results = new TreeSet<T>(this.getAggregatingAndSortingComparatorFor(query.getReturnType()));
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            try {
                com.atlassian.crowd.model.user.User user = this.findUserByName(application, query.getEntityNameToMatch());
                results.addAll(this.doNestedDirectoryMembershipQuery(query, totalResults, user.getDirectoryId()));
            }
            catch (UserNotFoundException e) {}
        } else {
            for (Directory directory : this.getActiveDirectories(application)) {
                results.addAll(this.doNestedDirectoryMembershipQuery(query, totalResults, directory.getId()));
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList<T>(results), (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    private <T> List<T> doNestedDirectoryMembershipQuery(MembershipQuery<T> query, int totalResults, Long directoryId) {
        try {
            MembershipQuery totalQuery = QueryBuilder.createMembershipQuery((int)totalResults, (int)0, (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
            return this.directoryManager.searchNestedGroupRelationships(directoryId.longValue(), totalQuery);
        }
        catch (DirectoryNotFoundException e) {
        }
        catch (OperationFailedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList();
    }

    private OperationType getCreateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.CREATE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.CREATE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getUpdateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.UPDATE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getUpdateAttributeOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP_ATTRIBUTE;
            }
            case LEGACY_ROLE: {
                return OperationType.UPDATE_ROLE_ATTRIBUTE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getDeleteOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.DELETE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.DELETE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private RemoteDirectory getDirectoryImplementation(Directory directory) throws DirectoryInstantiationException {
        return this.directoryInstanceLoader.getDirectory(directory);
    }

    private Iterable<Directory> getActiveDirectories(Application application) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)application.getDirectoryMappings(), (Function)DirectoryResolver.INSTANCE), (Predicate)ActiveDirectorFilter.INSTANCE);
    }

    private <T> Comparator<T> getAggregatingAndSortingComparatorFor(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return NameComparator.of(type);
        }
        if (com.atlassian.crowd.model.user.User.class.isAssignableFrom(type)) {
            return NameComparator.of(type);
        }
        if (Group.class.isAssignableFrom(type)) {
            return NameComparator.of(type);
        }
        throw new IllegalArgumentException("Cannot find comparator for type: " + type.getCanonicalName());
    }

    private boolean isAllowedToAuthenticate(String username, long directoryId, Application application) throws OperationFailedException, DirectoryNotFoundException {
        if (!application.isActive()) {
            this.logger.debug("User does not have access to application '{}' as the application is inactive", (Object)application.getName());
            return false;
        }
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping != null) {
            if (directoryMapping.isAllowAllToAuthenticate()) {
                return true;
            }
            for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                if (!this.directoryManager.isUserNestedGroupMember(directoryId, username, groupMapping.getGroupName())) continue;
                return true;
            }
        }
        this.logger.debug("User does not have access to application '{}' as the directory is not allow all to authenticate and the user is not a member of any of the authorised groups", (Object)application.getName());
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActiveDirectorFilter implements Predicate<Directory>
    {
        INSTANCE;


        public boolean apply(Directory from) {
            return from.isActive();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DirectoryResolver implements Function<DirectoryMapping, Directory>
    {
        INSTANCE;


        public Directory apply(DirectoryMapping from) {
            return from.getDirectory();
        }
    }
}

