/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreStartedEvent;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationInformationStore;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class SynchronisationStatusManagerImpl
implements SynchronisationStatusManager {
    private final DirectorySynchronisationInformationStore store;

    public SynchronisationStatusManagerImpl(DirectorySynchronisationInformationStore store, EventPublisher eventPublisher) {
        this.store = store;
        eventPublisher.register((Object)this);
    }

    public void syncStarted(Directory directory) {
        DirectorySynchronisationInformation info = this.getDirectorySynchronisationInformation(directory);
        DirectorySynchronisationRoundInformation activeRound = new DirectorySynchronisationRoundInformation(System.currentTimeMillis(), 0L, "directory.caching.sync.started", Collections.emptyList());
        this.store.set(directory.getId(), new DirectorySynchronisationInformation(info.getLastRound(), activeRound));
    }

    public void syncStatus(long directoryId, String key, Serializable ... parameters) {
        DirectorySynchronisationInformation info = this.store.get(directoryId);
        if (info.getActiveRound() == null) {
            throw new IllegalStateException("Cannot update status for a directory that is not currently synchronising");
        }
        DirectorySynchronisationRoundInformation activeRound = new DirectorySynchronisationRoundInformation(info.getActiveRound().getStartTime(), 0L, key, (List)ImmutableList.copyOf((Object[])parameters));
        this.store.set(directoryId, new DirectorySynchronisationInformation(info.getLastRound(), activeRound));
    }

    public void syncFinished(long directoryId) {
        DirectorySynchronisationInformation info = this.store.get(directoryId);
        if (info.getActiveRound() == null) {
            return;
        }
        DirectorySynchronisationRoundInformation lastRound = new DirectorySynchronisationRoundInformation(info.getActiveRound().getStartTime(), System.currentTimeMillis() - info.getActiveRound().getStartTime(), info.getActiveRound().getStatusKey(), info.getActiveRound().getStatusParameters());
        this.store.set(directoryId, new DirectorySynchronisationInformation(lastRound, null));
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(Directory directory) {
        DirectorySynchronisationInformation info = this.store.get(directory.getId());
        if (info == null) {
            long startTime = NumberUtils.toLong((String)directory.getValue("com.atlassian.crowd.directory.sync.laststartsynctime"), (long)0L);
            long duration = NumberUtils.toLong((String)directory.getValue("com.atlassian.crowd.directory.sync.lastdurationms"), (long)0L);
            DirectorySynchronisationRoundInformation lastRound = startTime == 0L ? null : new DirectorySynchronisationRoundInformation(startTime, duration, null, null);
            return new DirectorySynchronisationInformation(lastRound, null);
        }
        if (info.getActiveRound() != null) {
            DirectorySynchronisationRoundInformation activeRound = new DirectorySynchronisationRoundInformation(info.getActiveRound().getStartTime(), System.currentTimeMillis() - info.getActiveRound().getStartTime(), info.getActiveRound().getStatusKey(), info.getActiveRound().getStatusParameters());
            return new DirectorySynchronisationInformation(info.getLastRound(), activeRound);
        }
        return info;
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        this.store.clear(event.getDirectoryId());
    }

    @EventListener
    public void handleEvent(XMLRestoreStartedEvent event) {
        this.store.clear();
    }
}

