/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.AbstractInMemorySearchStrategy;
import com.atlassian.crowd.manager.application.ResultsAggregator;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.List;

public class InMemoryAggregatingSearchStrategy
extends AbstractInMemorySearchStrategy {
    public InMemoryAggregatingSearchStrategy(DirectoryManager directoryManager, List<Directory> activeDirectories) {
        super(directoryManager, activeDirectories);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator<T> results = ResultsAggregator.with(InMemoryAggregatingSearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        for (Directory directory : this.activeDirectories) {
            results.addAll(this.doDirectDirectoryMembershipQuery(query, directory.getId()));
        }
        return results.constrainResults();
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator<T> results = ResultsAggregator.with(InMemoryAggregatingSearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        for (Directory directory : this.activeDirectories) {
            results.addAll(this.doNestedDirectoryMembershipQuery(query, directory.getId()));
        }
        return results.constrainResults();
    }
}

