/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class EventStoreGeneric
implements EventStore {
    private static final String SEPARATOR = ":";
    private static final Random random = new Random();
    private final long maxStoredEvents;
    private final ConcurrentNavigableMap<Long, OperationEvent> events = new ConcurrentSkipListMap<Long, OperationEvent>();
    private final String instanceId = String.valueOf(random.nextLong());
    private long eventNumber = 0L;

    public String getCurrentEventToken() {
        return this.toEventToken((Long)this.events.lastKey());
    }

    public EventStoreGeneric(long maxStoredEvents) {
        this.maxStoredEvents = maxStoredEvents + 1L;
        this.storeEvent(new ResetEvent());
    }

    public Events getNewEvents(String eventToken) throws EventTokenExpiredException {
        Long currentEventNumber = this.toEventNumber(eventToken);
        Iterator eventsSince = this.events.tailMap((Object)currentEventNumber).entrySet().iterator();
        if (!eventsSince.hasNext() || !((Long)eventsSince.next().getKey()).equals(currentEventNumber)) {
            throw new EventTokenExpiredException();
        }
        ArrayList events = new ArrayList();
        Long newEventNumber = currentEventNumber;
        while (eventsSince.hasNext()) {
            Map.Entry eventEntry = eventsSince.next();
            OperationEvent event = (OperationEvent)eventEntry.getValue();
            if (event instanceof ResetEvent) {
                throw new EventTokenExpiredException(((ResetEvent)event).getResetReason());
            }
            newEventNumber = (Long)eventEntry.getKey();
            events.add(eventEntry.getValue());
        }
        return new Events(events, this.toEventToken(newEventNumber));
    }

    public synchronized void storeEvent(OperationEvent event) {
        long currentEventNumber;
        if ((currentEventNumber = ++this.eventNumber) > this.maxStoredEvents) {
            this.events.remove(this.events.firstKey());
        }
        this.events.put(currentEventNumber, event);
    }

    public void invalidateEvents() {
        this.storeEvent(new ResetEvent());
    }

    public void invalidateEvents(Class unsupportedEventSource) {
        this.storeEvent(ResetEvent.fromUnsupportedEvent(unsupportedEventSource));
    }

    public void invalidateEvents(String reason) {
        this.storeEvent(ResetEvent.withReason(reason));
    }

    private Long toEventNumber(String eventToken) throws EventTokenExpiredException {
        String[] parts = eventToken.split(SEPARATOR);
        if (parts.length != 2 || !parts[0].equals(this.instanceId)) {
            throw new EventTokenExpiredException();
        }
        return Long.valueOf(parts[1]);
    }

    private String toEventToken(long eventNumber) {
        return this.instanceId + SEPARATOR + eventNumber;
    }

    private static class ResetEvent
    implements OperationEvent {
        private final String resetReason;

        public ResetEvent() {
            this.resetReason = null;
        }

        public ResetEvent(String resetReason) {
            this.resetReason = resetReason;
        }

        public String getResetReason() {
            return this.resetReason;
        }

        public static ResetEvent fromUnsupportedEvent(Class unsupportedEvent) {
            return ResetEvent.withReason(unsupportedEvent.getName() + " is not supported by incremental sync.");
        }

        public static ResetEvent withReason(String reason) {
            return new ResetEvent(reason);
        }

        public Operation getOperation() {
            return null;
        }

        public Directory getDirectory() {
            return null;
        }
    }
}

