/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.directory.DirectoryCacheChangeOperations;
import com.atlassian.crowd.directory.DirectoryCacheFactoryImpl;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionalDirectoryCacheFactory
extends DirectoryCacheFactoryImpl {
    private final TransactionInterceptor transactionInterceptor;

    public TransactionalDirectoryCacheFactory(DirectoryDao directoryDao, SynchronisationStatusManager synchronisationStatusManager, MultiEventPublisher eventPublisher, TransactionInterceptor transactionInterceptor) {
        super(directoryDao, synchronisationStatusManager, eventPublisher);
        this.transactionInterceptor = transactionInterceptor;
    }

    @Override
    public DirectoryCacheChangeOperations createDirectoryCacheChangeOperations(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor((Advisor)new TransactionAttributeSourceAdvisor(this.transactionInterceptor));
        proxyFactory.setInterfaces(new Class[]{DirectoryCacheChangeOperations.class});
        proxyFactory.setTarget((Object)super.createDirectoryCacheChangeOperations(remoteDirectory, internalDirectory));
        return (DirectoryCacheChangeOperations)proxyFactory.getProxy();
    }
}

