package com.atlassian.crowd.manager.directory.monitor;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import static com.google.common.base.Preconditions.checkNotNull;

public final class DirectoryMonitorStarter {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryMonitorStarter.class);

    private final EventPublisher eventPublisher;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectoryManager directoryManager;

    public DirectoryMonitorStarter(EventPublisher eventPublisher, DirectoryInstanceLoader directoryInstanceLoader, DirectoryManager directoryManager) {
        this.eventPublisher = checkNotNull(eventPublisher);
        this.directoryInstanceLoader = checkNotNull(directoryInstanceLoader);
        this.directoryManager = checkNotNull(directoryManager);
        this.eventPublisher.register(this);
    }

    @EventListener
    @SuppressWarnings("unused")
    public void readyDirectoriesForSynchronization(ApplicationReadyEvent event) {
        logger.debug("Starting monitoring for all directories.");
        for (Directory directory : directoryManager.findAllDirectories()) {
            try {
                // Loads the directory so that a monitor is added if necessary.
                directoryInstanceLoader.getDirectory(directory);
            } catch (DirectoryInstantiationException e) {
                logger.error("Error loading directory " + directory.getName() + "[" + directory.getId() + "]", e);
            }
        }

        // we're done
        eventPublisher.unregister(this);
    }
}
