package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DirectorySynchronisationInformationStoreImpl implements DirectorySynchronisationInformationStore {
    private final ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus;

    public DirectorySynchronisationInformationStoreImpl() {
        this(new ConcurrentHashMap<Long, DirectorySynchronisationInformation>());
    }

    /**
     * Construct a {@link DirectorySynchronisationInformationStoreImpl} which is backed by a concurrent map.
     * <p>
     * This constructor can be used to achieve cluster safety in cluster-capable applications by providing a
     * cluster-aware implementation
     *
     * @since 2.8
     */
    public DirectorySynchronisationInformationStoreImpl(ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus) {
        this.syncStatus = syncStatus;
    }

    public DirectorySynchronisationInformation get(long directoryId) {
        return syncStatus.get(directoryId);
    }

    public void set(long directoryId, DirectorySynchronisationInformation syncInfo) {
        syncStatus.put(directoryId, syncInfo);
    }

    public void clear(long directoryId) {
        syncStatus.remove(directoryId);
    }

    public void clear() {
        syncStatus.clear();
    }
}
