package com.atlassian.crowd.manager.application;

import java.util.Collections;
import java.util.List;

import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;

/**
 * A {@link SearchStrategy} for an application with no active directories associated.
 *
 * @since 2.9
 */
public enum NoDirectorySearchStrategy implements SearchStrategy {
    INSTANCE;

    @Override
    public <T> List<T> searchUsers(EntityQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchGroups(EntityQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        return Collections.emptyList();
    }
}
