package com.atlassian.crowd.core.event;

import java.util.Collection;

import com.atlassian.event.api.EventPublisher;

/**
 * An extension to {@link EventPublisher} that allows special handling for sets of many events sent at the same time.
 */
public interface MultiEventPublisher extends EventPublisher {
    /**
     * Publish events that will be consumed by their respective registered listeners.
     * This should be equivalent with calling {@link #publish(Object)} for every event in the collection.
     */
    void publishAll(Collection<Object> events);
}
