/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.support;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.support.SupportInformationBuilder;
import com.atlassian.crowd.support.SupportInformationService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;

public class SupportInformationServiceImpl
implements SupportInformationService {
    private final DirectoryManager directoryManager;
    @Nullable
    private ApplicationManager applicationManager;

    public SupportInformationServiceImpl(DirectoryManager directoryManager) {
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
    }

    public String getSupportInformation(@Nullable User currentUser) {
        SupportInformationBuilder builder = new SupportInformationBuilder();
        this.addCurrentUserInformation(builder, currentUser);
        this.addDirectoryConfiguration(builder);
        this.addApplicationConfiguration(builder);
        return builder.build();
    }

    private void addCurrentUserInformation(SupportInformationBuilder builder, @Nullable User currentUser) {
        if (currentUser != null) {
            builder.addHeading("Current user");
            builder.addField("Directory ID", currentUser.getDirectoryId());
            builder.addField("Username", currentUser.getName());
            builder.addField("Display name", currentUser.getDisplayName());
            builder.addField("Email address", currentUser.getEmailAddress());
            builder.newLine();
        }
    }

    private void addDirectoryConfiguration(SupportInformationBuilder builder) {
        List directories = this.directoryManager.findAllDirectories();
        if (directories != null) {
            builder.addHeading("Directories configured");
            for (Directory directory : directories) {
                builder.addField("Directory ID", directory.getId());
                builder.addField("Name", directory.getName());
                builder.addField("Active", directory.isActive());
                builder.addField("Type", directory.getType());
                builder.addField("Created date", directory.getCreatedDate());
                builder.addField("Updated date", directory.getUpdatedDate());
                builder.addField("Allowed operations", directory.getAllowedOperations());
                builder.addField("Implementation class", directory.getImplementationClass());
                builder.addField("Encryption type", directory.getEncryptionType());
                builder.addAttributes("Attributes", directory.getAttributes());
                builder.newLine();
            }
        }
    }

    private void addApplicationConfiguration(SupportInformationBuilder builder) {
        if (this.applicationManager != null) {
            builder.addHeading("Applications configured");
            for (Application application : this.applicationManager.findAll()) {
                builder.addField("Application ID", application.getId());
                builder.addField("Name", application.getName());
                builder.addField("Active", application.isActive());
                builder.addField("Type", application.getType());
                builder.addField("Is lowercase output", application.isLowerCaseOutput());
                builder.addField("Is aliasing enabled", application.isAliasingEnabled());
                builder.addField("Remote addresses", Iterables.transform((Iterable)application.getRemoteAddresses(), RemoteAddress::getAddress));
                builder.addField("Created date", application.getCreatedDate());
                builder.addField("Updated date", application.getUpdatedDate());
                builder.addAttributes("Attributes", application.getAttributes());
                for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                    builder.addField("Mapped to directory ID", directoryMapping.getDirectory().getId());
                    builder.addField("    Allow all to authenticate", directoryMapping.isAllowAllToAuthenticate());
                    builder.addField("    Mapped groups", Iterables.transform((Iterable)directoryMapping.getAuthorisedGroups(), GroupMapping::getGroupName));
                    builder.addField("    Allowed operations", directoryMapping.getAllowedOperations());
                }
                builder.newLine();
            }
        }
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }
}

