/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.application.ResultsAggregator;
import com.atlassian.crowd.manager.application.SearchStrategy;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.base.Function;
import java.util.List;

public abstract class AbstractInMemorySearchStrategy
implements SearchStrategy {
    protected final DirectoryManager directoryManager;
    protected final List<Directory> activeDirectories;

    public AbstractInMemorySearchStrategy(DirectoryManager directoryManager, List<Directory> activeDirectories) {
        this.directoryManager = directoryManager;
        this.activeDirectories = activeDirectories;
    }

    @Override
    public <T> List<T> searchUsers(EntityQuery<T> query) {
        return this.searchUsers(query, AbstractInMemorySearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()));
    }

    private <T, K extends Comparable<? super K>> List<T> searchUsers(EntityQuery<T> query, Function<? super T, K> comparator) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, User.class});
        ResultsAggregator results = ResultsAggregator.with(comparator, query);
        EntityQuery totalQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)-1);
        for (Directory directory : this.activeDirectories) {
            List users = new SingleDirectorySearchStrategy(this.directoryManager, directory.getId()).searchUsers(totalQuery);
            results.addAll(users);
        }
        return results.constrainResults();
    }

    @Override
    public <T> List<T> searchGroups(EntityQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class});
        ResultsAggregator results = ResultsAggregator.with(AbstractInMemorySearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        EntityQuery totalQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)-1);
        for (Directory directory : this.activeDirectories) {
            List groups = new SingleDirectorySearchStrategy(this.directoryManager, directory.getId()).searchGroups(totalQuery);
            results.addAll(groups);
        }
        return results.constrainResults();
    }

    protected <T> List<T> doDirectDirectoryMembershipQuery(MembershipQuery<T> query, long directoryId) {
        MembershipQuery totalQuery = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
        return new SingleDirectorySearchStrategy(this.directoryManager, directoryId).searchDirectGroupRelationships(totalQuery);
    }

    protected <T> List<T> doNestedDirectoryMembershipQuery(MembershipQuery<T> query, long directoryId) {
        MembershipQuery totalQuery = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
        return new SingleDirectorySearchStrategy(this.directoryManager, directoryId).searchNestedGroupRelationships(totalQuery);
    }

    protected static <T> Function<T, String> getAggregatingAndSortingComparatorFor(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return NameComparator.normaliserOf(type);
        }
        if (User.class.isAssignableFrom(type)) {
            return NameComparator.normaliserOf(type);
        }
        if (Group.class.isAssignableFrom(type)) {
            return NameComparator.normaliserOf(type);
        }
        throw new IllegalArgumentException("Cannot find normaliser for type: " + type.getCanonicalName());
    }
}

