/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event;

import com.atlassian.crowd.attribute.AttributePredicates;
import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.manager.webhook.WebhookService;
import com.atlassian.crowd.model.event.AliasEvent;
import com.atlassian.crowd.model.event.GroupEvent;
import com.atlassian.crowd.model.event.GroupMembershipEvent;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.atlassian.crowd.model.event.UserEvent;
import com.atlassian.crowd.model.event.UserMembershipEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StoringEventListener {
    private final EventStore eventStore;
    private final WebhookService webhookService;

    public StoringEventListener(EventStore eventStore, EventPublisher eventPublisher, WebhookService webhookService) {
        this.eventStore = eventStore;
        this.webhookService = webhookService;
        eventPublisher.register((Object)this);
    }

    private void storeEventAndNotifyWebhooks(OperationEvent event) {
        this.eventStore.storeEvent(event);
        this.webhookService.notifyWebhooks();
    }

    private void invalidateEventsAndNotifyWebhooks(Class unsupportedEventType) {
        this.eventStore.invalidateEvents(unsupportedEventType);
        this.webhookService.notifyWebhooks();
    }

    @EventListener
    public void handleEvent(UserCreatedEvent event) {
        this.storeEventAndNotifyWebhooks((OperationEvent)new UserEvent(Operation.CREATED, event.getDirectory(), event.getUser(), null, null));
    }

    @EventListener
    public void handleEvent(UserUpdatedEvent event) {
        Map<String, Set> storedAttributes = null;
        Set<String> deletedAttributes = null;
        if (event instanceof UserAttributeStoredEvent) {
            UserAttributeStoredEvent userAttributeStoredEvent = (UserAttributeStoredEvent)event;
            storedAttributes = userAttributeStoredEvent.getAttributeNames().stream().filter(AttributePredicates.SYNCING_ATTRIBUTE).collect(Collectors.toMap(attrName -> attrName, arg_0 -> ((UserAttributeStoredEvent)userAttributeStoredEvent).getAttributeValues(arg_0)));
            if (storedAttributes.isEmpty()) {
                return;
            }
        } else if (event instanceof UserAttributeDeletedEvent) {
            String attributeName = ((UserAttributeDeletedEvent)event).getAttributeName();
            if (!AttributePredicates.SYNCING_ATTRIBUTE.test(attributeName)) {
                return;
            }
            deletedAttributes = Collections.singleton(attributeName);
        } else if (event instanceof UserRenamedEvent) {
            this.invalidateEventsAndNotifyWebhooks(UserRenamedEvent.class);
            return;
        }
        this.storeEventAndNotifyWebhooks((OperationEvent)new UserEvent(Operation.UPDATED, event.getDirectory(), event.getUser(), storedAttributes, deletedAttributes));
    }

    @EventListener
    public void handleEvent(UserDeletedEvent event) {
        UserTemplate user = new UserTemplate(event.getUsername(), event.getDirectory().getId().longValue());
        this.storeEventAndNotifyWebhooks((OperationEvent)new UserEvent(Operation.DELETED, event.getDirectory(), (User)user, null, null));
    }

    @EventListener
    public void handleEvent(GroupCreatedEvent event) {
        this.storeEventAndNotifyWebhooks((OperationEvent)new GroupEvent(Operation.CREATED, event.getDirectory(), event.getGroup(), null, null));
    }

    @EventListener
    public void handleEvent(GroupUpdatedEvent event) {
        Map<String, Set> storedAttributes = null;
        Set<String> deletedAttributes = null;
        if (event instanceof GroupAttributeStoredEvent) {
            GroupAttributeStoredEvent groupAttributeStoredEvent = (GroupAttributeStoredEvent)event;
            storedAttributes = groupAttributeStoredEvent.getAttributeNames().stream().filter(AttributePredicates.SYNCING_ATTRIBUTE).collect(Collectors.toMap(attrName -> attrName, arg_0 -> ((GroupAttributeStoredEvent)groupAttributeStoredEvent).getAttributeValues(arg_0)));
            if (storedAttributes.isEmpty()) {
                return;
            }
        } else if (event instanceof GroupAttributeDeletedEvent) {
            String attributeName = ((GroupAttributeDeletedEvent)event).getAttributeName();
            if (!AttributePredicates.SYNCING_ATTRIBUTE.test(attributeName)) {
                return;
            }
            deletedAttributes = Collections.singleton(attributeName);
        }
        this.storeEventAndNotifyWebhooks((OperationEvent)new GroupEvent(Operation.UPDATED, event.getDirectory(), event.getGroup(), storedAttributes, deletedAttributes));
    }

    @EventListener
    public void handleEvent(GroupDeletedEvent event) {
        GroupTemplate group = new GroupTemplate(event.getGroupName(), event.getDirectoryId().longValue());
        this.storeEventAndNotifyWebhooks((OperationEvent)new GroupEvent(Operation.DELETED, event.getDirectory(), (Group)group, null, null));
    }

    @EventListener
    public void handleEvent(GroupMembershipsCreatedEvent event) {
        Stream<OperationEvent> eventStream;
        switch (event.getMembershipType()) {
            case GROUP_USER: {
                eventStream = event.getEntityNames().stream().map(entityName -> new UserMembershipEvent(Operation.CREATED, event.getDirectory(), entityName, event.getGroupName()));
                break;
            }
            case GROUP_GROUP: {
                eventStream = event.getEntityNames().stream().map(entityName -> new GroupMembershipEvent(Operation.CREATED, event.getDirectory(), entityName, event.getGroupName()));
                break;
            }
            default: {
                throw new IllegalArgumentException("MembershipType " + event.getMembershipType() + " is not supported");
            }
        }
        eventStream.forEach(arg_0 -> ((EventStore)this.eventStore).storeEvent(arg_0));
        this.webhookService.notifyWebhooks();
    }

    @EventListener
    public void handleEvent(GroupMembershipDeletedEvent event) {
        if (event.getMembershipType() == MembershipType.GROUP_USER) {
            this.storeEventAndNotifyWebhooks((OperationEvent)new UserMembershipEvent(Operation.DELETED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else if (event.getMembershipType() == MembershipType.GROUP_GROUP) {
            this.storeEventAndNotifyWebhooks((OperationEvent)new GroupMembershipEvent(Operation.DELETED, event.getDirectory(), event.getEntityName(), event.getGroupName()));
        } else {
            throw new IllegalArgumentException("MembershipType " + event.getMembershipType() + " is not supported");
        }
    }

    @EventListener
    public void handleEvent(AliasEvent event) {
        this.eventStore.storeEvent((OperationEvent)event);
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(DirectoryUpdatedEvent.class);
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(DirectoryDeletedEvent.class);
    }

    @EventListener
    public void handleEvent(XMLRestoreFinishedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(XMLRestoreFinishedEvent.class);
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryAddedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(ApplicationDirectoryAddedEvent.class);
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryRemovedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(ApplicationDirectoryRemovedEvent.class);
    }

    @EventListener
    public void handleEvent(ApplicationDirectoryOrderUpdatedEvent event) {
        this.invalidateEventsAndNotifyWebhooks(ApplicationDirectoryOrderUpdatedEvent.class);
    }

    @EventListener
    public void handleEvent(ApplicationUpdatedEvent event) {
        this.eventStore.invalidateEvents(ApplicationUpdatedEvent.class);
    }
}

