package com.atlassian.crowd.manager.application;

import java.util.List;
import java.util.Optional;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.application.Application;

/**
 * A factory which may be able to create a {@link SearchStrategy} for a given {@link Application} and its associated active
 * {@link Directory directories}
 *
 * @see SearchStrategy
 * @since 2.9
 */
public interface SearchStrategyFactory {
    /**
     * Attempts to create a {@link SearchStrategy} for the specified {@code application} and
     * associated {@code activeDirectories}.
     * <p>
     * If the factory cannot create a {@link SearchStrategy} for the specified application or directory configuration
     * {@code Optional.empty()} should be returned
     *
     * @param application       the application
     * @param activeDirectories the collection of active directories associated with the application
     * @return a {@link SearchStrategy} for the application and directories or {@code Optional.empty()}
     */
    Optional<SearchStrategy> createSearchStrategy(Application application, List<Directory> activeDirectories);
}
