package com.atlassian.crowd.cache;

import com.atlassian.cache.Cache;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;

import static org.apache.commons.lang3.StringEscapeUtils.escapeJson;

/**
 * Default implementation of UserAuthorisationCache in Crowd.
 *
 * @since v2.2
 */
public class UserAuthorisationCacheImpl implements UserAuthorisationCache {
    private final Cache<String, Boolean> cache;

    public UserAuthorisationCacheImpl(Cache<String, Boolean> cache) {
        this.cache = cache;
    }

    public void setPermitted(final String userName, final String applicationName, final boolean permitted) {
        cache.put(getCacheKey(userName, applicationName), permitted);
    }

    public Boolean isPermitted(final String userName, final String applicationName) {
        return cache.get(getCacheKey(userName, applicationName));
    }

    public void clear() {
        cache.removeAll();
    }

    public void clear(final String userName, final String applicationName) {
        cache.remove(getCacheKey(userName, applicationName));
    }

    /**
     * Returns the cache key based on the username and application name. Use a <code>String</code> to allow
     * use with any cache implementation, rather than an in-memory Java one.
     *
     * @param userName        username
     * @param applicationName name of the application
     * @return cache key
     */
    static String getCacheKey(final String userName, final String applicationName) {
        return "[\"" + escapeJson(IdentifierUtils.toLowerCase(userName)) + "\",\""
                + escapeJson(IdentifierUtils.toLowerCase(applicationName)) + "\"]";
    }
}
