/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor;

import com.atlassian.crowd.directory.DbCachingDirectoryPoller;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.monitor.DirectoryMonitorCreationException;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorAlreadyRegisteredException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorManager;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitorManagerImpl
implements DirectoryMonitorManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DirectoryPollerManager directoryPollerManager;
    private final DirectorySynchroniser directorySynchroniser;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public DirectoryMonitorManagerImpl(DirectoryPollerManager directoryPollerManager, DirectorySynchroniser directorySynchroniser, EventPublisher eventPublisher) {
        this.directoryPollerManager = directoryPollerManager;
        this.directorySynchroniser = directorySynchroniser;
        eventPublisher.register((Object)this);
    }

    public void addMonitor(RemoteDirectory remoteDirectory) throws DirectoryInstantiationException, DirectoryMonitorCreationException, DirectoryMonitorRegistrationException, DirectoryMonitorAlreadyRegisteredException {
        this.logger.info("Attempting to add monitor for directory with id: " + remoteDirectory.getDirectoryId());
        if (this.hasMonitor(remoteDirectory.getDirectoryId())) {
            throw new DirectoryMonitorAlreadyRegisteredException("Remove existing monitor to add a monitor");
        }
        this.readWriteLock.writeLock().lock();
        try {
            if (this.hasMonitor(remoteDirectory.getDirectoryId())) {
                throw new DirectoryMonitorAlreadyRegisteredException("Remove existing monitor to add a monitor");
            }
            if (remoteDirectory instanceof SynchronisableDirectory) {
                this.logger.info("Directory is synchronisable. Adding poller.");
                DbCachingDirectoryPoller poller = new DbCachingDirectoryPoller(this.directorySynchroniser, (SynchronisableDirectory)remoteDirectory);
                this.directoryPollerManager.addPoller(poller);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitor(long directoryID) throws DirectoryMonitorUnregistrationException {
        this.logger.info("Attempting to remove monitor for directory with id: " + directoryID);
        this.readWriteLock.writeLock().lock();
        try {
            if (this.directoryPollerManager.hasPoller(directoryID)) {
                this.logger.info("Directory is registered with a poller, removing poller");
                boolean bl = this.directoryPollerManager.removePoller(directoryID);
                return bl;
            }
            this.logger.info("Directory is not registered with a poller or listener");
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMonitor(long directoryID) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.directoryPollerManager.hasPoller(directoryID);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    protected void removeAllMonitors() {
        this.readWriteLock.writeLock().lock();
        try {
            this.directoryPollerManager.removeAllPollers();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        this.handleEvent((DirectoryEvent)event);
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        this.handleEvent((DirectoryEvent)event);
    }

    private void handleEvent(DirectoryEvent event) {
        long directoryID = event.getDirectoryId();
        try {
            if (this.hasMonitor(directoryID)) {
                this.removeMonitor(directoryID);
            }
        }
        catch (DirectoryMonitorUnregistrationException e) {
            this.logger.error("Unable to remove monitor for directory with ID: " + directoryID);
        }
    }

    @EventListener
    public void handleEvent(XMLRestoreFinishedEvent event) {
        this.removeAllMonitors();
    }
}

