/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.UserCapabilities;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.AbstractDelegatingApplicationService;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.application.ResultsAggregator;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.event.AliasEvent;
import com.atlassian.crowd.model.event.GroupEvent;
import com.atlassian.crowd.model.event.GroupMembershipEvent;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.atlassian.crowd.model.event.UserEvent;
import com.atlassian.crowd.model.event.UserMembershipEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.AliasQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TranslatingApplicationService
extends AbstractDelegatingApplicationService {
    private final AliasManager aliasManager;

    public TranslatingApplicationService(ApplicationService applicationService, AliasManager aliasManager) {
        super(applicationService);
        this.aliasManager = aliasManager;
    }

    @Override
    public User authenticateUser(Application application, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        User user = this.getApplicationService().authenticateUser(application, unaliasedUsername, passwordCredential);
        return this.buildUserForApplication(application, user);
    }

    @Override
    public boolean isUserAuthorised(Application application, String username) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.getApplicationService().isUserAuthorised(application, unaliasedUsername);
    }

    public boolean isUserAuthorised(Application application, User user) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, user.getName());
        return this.getApplicationService().isUserAuthorised(application, unaliasedUsername);
    }

    @Override
    public User findUserByName(Application application, String name) throws UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, name);
        User user = this.getApplicationService().findUserByName(application, unaliasedUsername);
        return this.buildUserForApplication(application, user);
    }

    @Override
    public UserWithAttributes findUserWithAttributesByName(Application application, String name) throws UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, name);
        UserWithAttributes user = this.getApplicationService().findUserWithAttributesByName(application, unaliasedUsername);
        return this.buildUserWithAttributesForApplication(application, user);
    }

    @Override
    public User addUser(Application application, UserTemplate user, PasswordCredential credential) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException {
        return this.addUser(application, UserTemplateWithAttributes.toUserWithNoAttributes((User)user), credential);
    }

    @Override
    public UserWithAttributes addUser(Application application, UserTemplateWithAttributes user, PasswordCredential credential) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException {
        return this.buildUserWithAttributesForApplication(application, this.getApplicationService().addUser(application, user, credential));
    }

    @Override
    public User updateUser(Application application, UserTemplate user) throws InvalidUserException, OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, user.getName());
        UserTemplate unaliasedUser = new UserTemplate((User)user);
        unaliasedUser.setName(unaliasedUsername);
        User updatedUser = this.getApplicationService().updateUser(application, unaliasedUser);
        return this.buildUserForApplication(application, updatedUser);
    }

    @Override
    public User renameUser(Application application, String oldUserName, String newUsername) throws UserNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidUserException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, oldUserName);
        return this.buildUserForApplication(application, this.getApplicationService().renameUser(application, unaliasedUsername, newUsername));
    }

    @Override
    public void updateUserCredential(Application application, String username, PasswordCredential credential) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.getApplicationService().updateUserCredential(application, unaliasedUsername, credential);
    }

    @Override
    public void storeUserAttributes(Application application, String username, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.getApplicationService().storeUserAttributes(application, unaliasedUsername, attributes);
    }

    @Override
    public void removeUserAttributes(Application application, String username, String attributeName) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.getApplicationService().removeUserAttributes(application, unaliasedUsername, attributeName);
    }

    @Override
    public void removeUser(Application application, String user) throws OperationFailedException, UserNotFoundException, ApplicationPermissionException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, user);
        this.getApplicationService().removeUser(application, unaliasedUsername);
    }

    @Override
    public <T> List<T> searchUsers(Application application, EntityQuery<T> query) {
        if (!application.isAliasingEnabled()) {
            return this.buildListForApplication(application, this.getApplicationService().searchUsers(application, query), query.getReturnType(), query.getEntityDescriptor());
        }
        EntityQuery<User> userQuery = this.convertToUnboundUserQuery((Query<?>)query);
        Collection<User> users = this.searchUsersInternal(application, userQuery, new UserSearcher(){

            @Override
            public List<User> searchUsers(Application application, EntityQuery<User> query) {
                return TranslatingApplicationService.this.getApplicationService().searchUsers(application, query);
            }
        });
        List<User> applicationUserList = this.buildListForApplication(application, users, User.class, EntityDescriptor.user());
        List<User> uniqueUserList = this.pruneDuplicates(applicationUserList);
        return this.convertToType(SearchResultsUtil.constrainResults(uniqueUserList, (int)query.getStartIndex(), (int)query.getMaxResults()), query.getReturnType());
    }

    @Override
    public Group findGroupByName(Application application, String name) throws GroupNotFoundException {
        return this.buildGroupForApplication(application, this.getApplicationService().findGroupByName(application, name));
    }

    @Override
    public GroupWithAttributes findGroupWithAttributesByName(Application application, String name) throws GroupNotFoundException {
        return this.buildGroupWithAttributesForApplication(application, this.getApplicationService().findGroupWithAttributesByName(application, name));
    }

    @Override
    public Group addGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException {
        return this.buildGroupForApplication(application, this.getApplicationService().addGroup(application, group));
    }

    @Override
    public Group updateGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        return this.buildGroupForApplication(application, this.getApplicationService().updateGroup(application, group));
    }

    @Override
    public <T> List<T> searchGroups(Application application, EntityQuery<T> query) {
        return this.buildListForApplication(application, this.getApplicationService().searchGroups(application, query), query.getReturnType(), query.getEntityDescriptor());
    }

    @Override
    public void addUserToGroup(Application application, String username, String groupName) throws OperationFailedException, UserNotFoundException, GroupNotFoundException, ApplicationPermissionException, MembershipAlreadyExistsException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.getApplicationService().addUserToGroup(application, unaliasedUsername, groupName);
    }

    @Override
    public void removeUserFromGroup(Application application, String username, String groupName) throws OperationFailedException, GroupNotFoundException, UserNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        this.getApplicationService().removeUserFromGroup(application, unaliasedUsername, groupName);
    }

    @Override
    public boolean isUserDirectGroupMember(Application application, String username, String groupName) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.getApplicationService().isUserDirectGroupMember(application, unaliasedUsername, groupName);
    }

    @Override
    public boolean isUserNestedGroupMember(Application application, String username, String groupName) {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        return this.getApplicationService().isUserNestedGroupMember(application, unaliasedUsername, groupName);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(Application application, MembershipQuery<T> query) {
        MembershipQuery<T> unaliasedQuery = this.buildUnaliasedMembershipQuery(application, query);
        List result = this.getApplicationService().searchDirectGroupRelationships(application, unaliasedQuery);
        return this.buildListForApplication(application, result, query.getReturnType(), query.getEntityToReturn());
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(Application application, MembershipQuery<T> query) {
        MembershipQuery<T> unaliasedQuery = this.buildUnaliasedMembershipQuery(application, query);
        List result = this.getApplicationService().searchNestedGroupRelationships(application, unaliasedQuery);
        return this.buildListForApplication(application, result, query.getReturnType(), query.getEntityToReturn());
    }

    @Override
    public Events getNewEvents(Application application, String eventToken) throws EventTokenExpiredException, OperationFailedException {
        Events result = this.getApplicationService().getNewEvents(application, eventToken);
        if (!application.isAliasingEnabled() && !application.isLowerCaseOutput()) {
            return result;
        }
        ArrayList<UserEvent> applicationEvents = new ArrayList<UserEvent>();
        for (OperationEvent event : result.getEvents()) {
            UserEvent applicationEvent;
            if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                if (application.isAliasingEnabled() && userEvent.getOperation() == Operation.DELETED) {
                    throw new EventTokenExpiredException("User deleted events invalidate incremental synchronisation, try a full synchronisation");
                }
                User applicationUser = this.buildUserForApplication(application, userEvent.getUser());
                applicationEvent = new UserEvent(event.getOperation(), event.getDirectory(), applicationUser, userEvent.getStoredAttributes(), userEvent.getDeletedAttributes());
            } else if (event instanceof GroupEvent) {
                GroupEvent groupEvent = (GroupEvent)event;
                Group applicationGroup = this.buildGroupForApplication(application, groupEvent.getGroup());
                applicationEvent = new GroupEvent(event.getOperation(), event.getDirectory(), applicationGroup, groupEvent.getStoredAttributes(), groupEvent.getDeletedAttributes());
            } else if (event instanceof UserMembershipEvent) {
                UserMembershipEvent userMembershipEvent = (UserMembershipEvent)event;
                String applicationChildUsername = this.resolveUsernameForApplication(application, userMembershipEvent.getChildUsername());
                ImmutableSet applicationGroupNames = ImmutableSet.copyOf(this.buildGroupNamesForApplication(application, userMembershipEvent.getParentGroupNames()));
                applicationEvent = new UserMembershipEvent(event.getOperation(), event.getDirectory(), applicationChildUsername, (Set)applicationGroupNames);
            } else if (event instanceof GroupMembershipEvent) {
                GroupMembershipEvent groupMembershipEvent = (GroupMembershipEvent)event;
                String applicationGroupName = this.lowercaseNameIfNecessary(application, groupMembershipEvent.getGroupName());
                ImmutableSet applicationParentGroupNames = ImmutableSet.copyOf(this.buildGroupNamesForApplication(application, groupMembershipEvent.getParentGroupNames()));
                ImmutableSet applicationChildGroupNames = ImmutableSet.copyOf(this.buildGroupNamesForApplication(application, groupMembershipEvent.getChildGroupNames()));
                applicationEvent = new GroupMembershipEvent(event.getOperation(), event.getDirectory(), applicationGroupName, (Set)applicationParentGroupNames, (Set)applicationChildGroupNames);
            } else {
                if (event instanceof AliasEvent) {
                    AliasEvent aliasEvent = (AliasEvent)event;
                    if (!application.getId().equals(aliasEvent.getApplication().getId())) continue;
                    throw new EventTokenExpiredException("Alias events invalidate incremental synchronisation, try a full synchronisation");
                }
                throw new IllegalArgumentException("Event type " + event.getClass() + " not supported.");
            }
            applicationEvents.add(applicationEvent);
        }
        return new Events(applicationEvents, result.getNewEventToken());
    }

    @Override
    public UserCapabilities getCapabilitiesForNewUsers(Application application) {
        return this.getApplicationService().getCapabilitiesForNewUsers(application);
    }

    public User userAuthenticated(Application application, String username) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        String unaliasedUsername = this.aliasManager.findUsernameByAlias(application, username);
        User updatedUser = this.getApplicationService().userAuthenticated(application, unaliasedUsername);
        return this.buildUserForApplication(application, updatedUser);
    }

    private <T> List<T> convertToType(List<User> applicationList, Class<T> returnType) {
        QueryUtils.checkAssignableFrom(returnType, (Class[])new Class[]{String.class, User.class});
        if (String.class.isAssignableFrom(returnType)) {
            return SearchResultsUtil.convertEntitiesToNames(applicationList);
        }
        return applicationList;
    }

    private Collection<User> searchUsersInternal(Application application, EntityQuery<User> query, UserSearcher searcher) {
        SearchRestriction searchRestrictions = this.replaceAliasesWithUsernames(application, query.getSearchRestriction());
        EntityQuery aliasedQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)searchRestrictions, (int)query.getStartIndex(), (int)query.getMaxResults());
        return this.doSearchUsers(application, (EntityQuery<User>)aliasedQuery, searcher);
    }

    private List<User> pruneDuplicates(Collection<User> users) {
        ResultsAggregator<User> aggregator = ResultsAggregator.with(NameComparator.normaliserOf(User.class), 0, -1);
        aggregator.addAll(users);
        return aggregator.constrainResults();
    }

    private SearchRestriction replaceAliasesWithUsernames(Application application, SearchRestriction restrictions) {
        PropertyRestriction restriction;
        if (restrictions instanceof BooleanRestriction) {
            BooleanRestriction restriction2 = (BooleanRestriction)restrictions;
            ArrayList<SearchRestriction> childRestrictions = new ArrayList<SearchRestriction>(restriction2.getRestrictions().size());
            for (SearchRestriction childRestriction : restriction2.getRestrictions()) {
                childRestrictions.add(this.replaceAliasesWithUsernames(application, childRestriction));
            }
            return new BooleanRestrictionImpl(restriction2.getBooleanLogic(), childRestrictions);
        }
        if (restrictions instanceof PropertyRestriction && UserTermKeys.USERNAME.equals((restriction = (PropertyRestriction)restrictions).getProperty()) && restriction.getMatchMode().isExact() && restriction.getValue() != null) {
            String username = this.aliasManager.findUsernameByAlias(application, (String)restriction.getValue());
            return new TermRestriction(UserTermKeys.USERNAME, restriction.getMatchMode(), (Object)username);
        }
        return restrictions;
    }

    private Collection<User> doSearchUsers(Application application, EntityQuery<User> query, UserSearcher searcher) {
        SearchRestriction restrictions = query.getSearchRestriction();
        if (this.containsNonExactUsernameRestrictions(restrictions)) {
            if (restrictions instanceof BooleanRestriction) {
                BooleanRestriction restriction = (BooleanRestriction)restrictions;
                ResultCombiner<User> combiner = new ResultCombiner<User>(restriction.getBooleanLogic());
                for (SearchRestriction childRestriction : restriction.getRestrictions()) {
                    EntityQuery childQuery = QueryBuilder.queryFor((Class)query.getReturnType(), (EntityDescriptor)query.getEntityDescriptor(), (SearchRestriction)childRestriction, (int)0, (int)-1);
                    Collection<User> childResults = this.doSearchUsers(application, (EntityQuery<User>)childQuery, searcher);
                    combiner.combine(childResults);
                }
                return combiner.getValues();
            }
            if (restrictions instanceof PropertyRestriction) {
                PropertyRestriction usernameRestriction = (PropertyRestriction)restrictions;
                return this.searchWithNonExactUsernameRestriction(application, (PropertyRestriction<String>)usernameRestriction, searcher);
            }
            throw new IllegalArgumentException("Unexpected restriction");
        }
        return searcher.searchUsers(application, query);
    }

    private boolean containsNonExactUsernameRestrictions(SearchRestriction restrictions) {
        PropertyRestriction restriction;
        if (restrictions instanceof BooleanRestriction) {
            BooleanRestriction restriction2 = (BooleanRestriction)restrictions;
            for (SearchRestriction childRestriction : restriction2.getRestrictions()) {
                if (!this.containsNonExactUsernameRestrictions(childRestriction)) continue;
                return true;
            }
        } else if (restrictions instanceof PropertyRestriction && UserTermKeys.USERNAME.equals((restriction = (PropertyRestriction)restrictions).getProperty()) && !restriction.getMatchMode().isExact()) {
            return true;
        }
        return false;
    }

    private Collection<User> searchWithNonExactUsernameRestriction(Application application, PropertyRestriction<String> restriction, UserSearcher searcher) {
        ArrayList<User> users = new ArrayList<User>();
        BooleanRestrictionImpl aliasRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{new TermRestriction(AliasTermKeys.ALIAS, restriction.getMatchMode(), restriction.getValue()), new TermRestriction(AliasTermKeys.APPLICATION_ID, MatchMode.EXACTLY_MATCHES, (Object)application.getId())});
        AliasQuery aliasQuery = new AliasQuery((SearchRestriction)aliasRestriction, 0, -1);
        for (String aliasMatchUsername : this.aliasManager.search((EntityQuery)aliasQuery)) {
            EntityQuery aliasedUserQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)aliasMatchUsername), (int)0, (int)-1);
            users.addAll(searcher.searchUsers(application, (EntityQuery<User>)aliasedUserQuery));
        }
        UserQuery userQuery = new UserQuery(User.class, restriction, 0, -1);
        List<User> matchingUsers = searcher.searchUsers(application, (EntityQuery<User>)userQuery);
        for (User user : matchingUsers) {
            if (this.aliasExists(application, user)) continue;
            users.add(user);
        }
        return users;
    }

    private boolean aliasExists(Application application, User user) {
        String alias = this.aliasManager.findAliasByUsername(application, user.getName());
        return !user.getName().equalsIgnoreCase(alias);
    }

    private <T> MembershipQuery<T> buildUnaliasedMembershipQuery(Application application, MembershipQuery<T> query) {
        if (query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            String username = this.aliasManager.findUsernameByAlias(application, query.getEntityNameToMatch());
            return QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)username);
        }
        return query;
    }

    private <T> List<T> buildListForApplication(Application application, Collection<T> collection, Class<T> returnType, EntityDescriptor entityToReturn) {
        if (EntityDescriptor.user().equals((Object)entityToReturn) && String.class.isAssignableFrom(returnType)) {
            return this.buildUsernamesForApplication(application, collection);
        }
        if (User.class.isAssignableFrom(returnType)) {
            return this.buildUsersForApplication(application, collection);
        }
        if (EntityDescriptor.group().equals((Object)entityToReturn) && String.class.isAssignableFrom(returnType)) {
            return this.buildGroupNamesForApplication(application, collection);
        }
        if (GroupWithAttributes.class.isAssignableFrom(returnType)) {
            return this.buildGroupsWithAttributesForApplication(application, collection);
        }
        if (Group.class.isAssignableFrom(returnType)) {
            return this.buildGroupsForApplication(application, collection);
        }
        return this.asList(collection);
    }

    private <T> List<T> asList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    private List<String> buildUsernamesForApplication(Application application, Collection<String> usernames) {
        ArrayList<String> applicationUsernames = new ArrayList<String>(usernames.size());
        Map aliasesForUsers = this.aliasManager.findAliasesByUsernames(application, applicationUsernames);
        for (String username : usernames) {
            applicationUsernames.add(this.resolveUsernameForApplication(application, username, Optional.ofNullable(aliasesForUsers.get(username))));
        }
        Collections.sort(applicationUsernames);
        return applicationUsernames;
    }

    private String resolveUsernameForApplication(Application application, String username) {
        String alias = this.aliasManager.findAliasByUsername(application, username);
        return this.resolveUsernameForApplication(application, username, Optional.of(alias));
    }

    private String resolveUsernameForApplication(Application application, String username, Optional<String> aliasOptional) {
        String applicationUsername = aliasOptional.orElse(username);
        return this.lowercaseNameIfNecessary(application, applicationUsername);
    }

    private String lowercaseNameIfNecessary(Application application, String alias) {
        return application.isLowerCaseOutput() ? IdentifierUtils.toLowerCase((String)alias) : alias;
    }

    private List<User> buildUsersForApplication(Application application, Collection<User> users) {
        ResultsAggregator<User> aggregator = ResultsAggregator.with(UserComparator.KEY_MAKER, 0, -1);
        Map aliasesForUsers = this.aliasManager.findAliasesByUsernames(application, Iterables.transform(users, Principal::getName));
        for (User user : users) {
            aggregator.add(this.buildUserForApplication(application, user, Optional.ofNullable(aliasesForUsers.get(user.getName()))));
        }
        return aggregator.constrainResults();
    }

    private User buildUserForApplication(Application application, User user) {
        String alias = this.aliasManager.findAliasByUsername(application, user.getName());
        return this.buildUserForApplication(application, user, Optional.of(alias));
    }

    private User buildUserForApplication(Application application, User user, Optional<String> aliasOptional) {
        String applicationUsername = this.resolveUsernameForApplication(application, user.getName(), aliasOptional);
        if (user.getName().equals(applicationUsername)) {
            return user;
        }
        UserTemplate applicationUser = new UserTemplate(user);
        applicationUser.setName(applicationUsername);
        return applicationUser;
    }

    private UserWithAttributes buildUserWithAttributesForApplication(Application application, UserWithAttributes user) {
        String applicationUsername = this.resolveUsernameForApplication(application, user.getName());
        if (user.getName().equals(applicationUsername)) {
            return user;
        }
        UserTemplateWithAttributes applicationUser = new UserTemplateWithAttributes(user);
        applicationUser.setName(applicationUsername);
        return applicationUser;
    }

    private List<String> buildGroupNamesForApplication(Application application, Collection<String> groupNames) {
        if (application.isLowerCaseOutput()) {
            ArrayList<String> lowerCaseGroupNames = new ArrayList<String>(groupNames.size());
            for (String groupName : groupNames) {
                lowerCaseGroupNames.add(IdentifierUtils.toLowerCase((String)groupName));
            }
            return lowerCaseGroupNames;
        }
        return this.asList(groupNames);
    }

    private List<Group> buildGroupsForApplication(Application application, Collection<Group> groups) {
        if (application.isLowerCaseOutput()) {
            ArrayList<Group> lowerCaseGroups = new ArrayList<Group>(groups.size());
            for (Group group : groups) {
                lowerCaseGroups.add(this.buildGroupForApplication(application, group));
            }
            return lowerCaseGroups;
        }
        return this.asList(groups);
    }

    private List<Group> buildGroupsWithAttributesForApplication(Application application, Collection<Group> groups) {
        if (application.isLowerCaseOutput()) {
            ArrayList<Group> lowerCaseGroups = new ArrayList<Group>(groups.size());
            for (Group group : groups) {
                if (group instanceof GroupWithAttributes) {
                    lowerCaseGroups.add((Group)this.buildGroupWithAttributesForApplication(application, (GroupWithAttributes)group));
                    continue;
                }
                lowerCaseGroups.add(this.buildGroupForApplication(application, group));
            }
            return lowerCaseGroups;
        }
        return this.asList(groups);
    }

    private Group buildGroupForApplication(Application application, Group group) {
        if (application.isLowerCaseOutput()) {
            GroupTemplate groupTemplate = new GroupTemplate(group);
            groupTemplate.setName(IdentifierUtils.toLowerCase((String)group.getName()));
            return groupTemplate;
        }
        return group;
    }

    private GroupWithAttributes buildGroupWithAttributesForApplication(Application application, GroupWithAttributes group) {
        if (application.isLowerCaseOutput()) {
            GroupTemplateWithAttributes groupTemplate = new GroupTemplateWithAttributes(group);
            groupTemplate.setName(IdentifierUtils.toLowerCase((String)group.getName()));
            return groupTemplate;
        }
        return group;
    }

    private EntityQuery<User> convertToUnboundUserQuery(Query<?> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, User.class});
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)query.getSearchRestriction(), (int)0, (int)-1);
    }

    private static interface UserSearcher {
        public List<User> searchUsers(Application var1, EntityQuery<User> var2);
    }

    private static class ResultCombiner<T> {
        private final BooleanRestriction.BooleanLogic logic;
        private Set<T> values = null;

        ResultCombiner(BooleanRestriction.BooleanLogic logic) {
            this.logic = logic;
        }

        void combine(Collection<T> newValues) {
            if (this.values == null) {
                this.values = Sets.newHashSet(newValues);
            } else if (this.logic == BooleanRestriction.BooleanLogic.AND) {
                this.values.retainAll(newValues);
            } else if (this.logic == BooleanRestriction.BooleanLogic.OR) {
                this.values.addAll(newValues);
            }
        }

        Set<T> getValues() {
            return this.values == null ? Collections.emptySet() : this.values;
        }
    }
}

