/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.SystemInfoHelper;
import com.atlassian.crowd.util.build.BuildUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.springframework.web.context.ServletContextAware;

public class SystemInfoHelperImpl
implements SystemInfoHelper,
ServletContextAware {
    private ServletContext servletContext;
    private PropertyManager propertyManager;
    private CrowdBootstrapManager bootstrapManager;
    private DirectoryManager directoryManager;

    public SystemInfoHelperImpl() {
    }

    public SystemInfoHelperImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public String getApplicationServer() {
        String applicationServer = null;
        if (this.servletContext != null) {
            applicationServer = this.servletContext.getServerInfo();
        } else if (ServletActionContext.getServletContext() != null) {
            applicationServer = ServletActionContext.getServletContext().getServerInfo();
        }
        return applicationServer;
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public long getUsedMemory() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public String getOperatingSystem() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaRuntime() {
        return System.getProperty("java.vm.name");
    }

    public String getApplicationUsername() {
        return System.getProperty("user.name");
    }

    public String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public String getCrowdVersion() {
        return BuildUtils.getVersion();
    }

    public String getTimeZone() {
        return Calendar.getInstance().getTimeZone().getDisplayName();
    }

    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getServerId() {
        return this.getBootstrapManager().getServerID();
    }

    public String getDatabaseJdbcDriver() {
        return this.getBootstrapManager().getString("hibernate.connection.driver_class");
    }

    public String getDatabaseJdbcUsername() {
        return this.getBootstrapManager().getString("hibernate.connection.username");
    }

    public String getDatabaseJdbcUrl() {
        return this.getBootstrapManager().getString("hibernate.connection.url");
    }

    public String getDatabaseHibernateDialect() {
        return this.getBootstrapManager().getString("hibernate.dialect");
    }

    public String getDatabaseDatasourceJndiName() {
        return this.getBootstrapManager().getString("hibernate.connection.datasource");
    }

    public boolean isDatabaseDatasource() {
        return this.getDatabaseDatasourceJndiName() != null;
    }

    public void printMinimalSystemInfo(Logger logger) {
        logger.info((Object)"System Information:");
        logger.info((Object)("\tTimezone: " + this.getTimeZone()));
        logger.info((Object)("\tJava Version: " + this.getJavaVersion()));
        logger.info((Object)("\tJava Vendor: " + this.getJavaVendor()));
        logger.info((Object)("\tJVM Version: " + this.getJavaVMVersion()));
        logger.info((Object)("\tJVM Vendor: " + this.getJavaVMVendor()));
        logger.info((Object)("\tJVM Runtime: " + this.getJavaRuntime()));
        logger.info((Object)("\tUsername: " + this.getApplicationUsername()));
        logger.info((Object)("\tOperating System: " + this.getOperatingSystem()));
        logger.info((Object)("\tArchitecture: " + this.getArchitecture()));
        logger.info((Object)"JVM Statistics:");
        logger.info((Object)("\tTotal Memory: " + this.getTotalMemory() + "MB"));
        logger.info((Object)("\tUsed Memory: " + this.getUsedMemory() + "MB"));
        logger.info((Object)("\tFree Memory: " + this.getFreeMemory() + "MB"));
        logger.info((Object)"Runtime Information:");
        logger.info((Object)"\tVersion: 2.0.7");
        logger.info((Object)"\tBuild Number: 416");
        logger.info((Object)"\tBuild Date: 12-08-2010");
    }

    public void printSystemInfo(Logger logger) {
        this.printMinimalSystemInfo(logger);
        logger.info((Object)("\tApplication Server: " + this.getApplicationServer()));
        logger.info((Object)"Database Information:");
        if (this.isDatabaseDatasource()) {
            logger.info((Object)("\tDatasource JNDI: " + this.getDatabaseDatasourceJndiName()));
        } else {
            logger.info((Object)("\tJDBC URL: " + this.getDatabaseJdbcUrl()));
            logger.info((Object)("\tJDBC Driver: " + this.getDatabaseJdbcDriver()));
            logger.info((Object)("\tJDBC Username: " + this.getDatabaseJdbcUsername()));
        }
        logger.info((Object)("\tHibernate Dialect: " + this.getDatabaseHibernateDialect()));
        logger.info((Object)"License Information:");
        logger.info((Object)("\tLicense Server ID: " + this.getServerId()));
        logger.info((Object)"Directories:");
        List directories = this.getDirectoryManager().searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        Iterator directoryIterator = directories.iterator();
        while (directoryIterator.hasNext()) {
            StringBuffer directoryList = new StringBuffer();
            Directory directory = (Directory)directoryIterator.next();
            String directoryType = directory.getImplementationClass();
            directoryType = directoryType.substring(directoryType.lastIndexOf(".") + 1, directoryType.length());
            directoryList.append("\t").append(directory.getName()).append(" (").append(directoryType).append(")");
            logger.info((Object)directoryList.toString());
        }
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public CrowdBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

