/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.util.I18nHelper;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class I18nHelperImpl
implements InitializingBean,
I18nHelper {
    private static final Logger LOG = Logger.getLogger(I18nHelperImpl.class);
    private Locale locale = null;
    private List i18nLocations = null;
    private String defaultResourceLocation = null;

    public String getText(String key) {
        return this.getText(key, new Object[0]);
    }

    public String getText(String key, String value1) {
        return this.getText(key, EasyList.build((Object)value1));
    }

    public String getText(String key, String value1, String value2) {
        return this.getText(key, EasyList.build((Object)value1, (Object)value2));
    }

    public String getText(String key, Object parameters) {
        MessageFormat mf;
        Object[] params = parameters instanceof List ? ((List)parameters).toArray() : (parameters instanceof Object[] ? (Object[])parameters : new Object[]{parameters});
        String message = this.getUnescapedText(key);
        try {
            mf = new MessageFormat(message);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Error rendering '" + message + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return mf.format(params);
    }

    public String getUnescapedText(String key) {
        for (String i18nLocation : this.getI18nLocations()) {
            try {
                ResourceBundle rb = this.getResourceBundle(i18nLocation);
                if (key.startsWith("'") && key.endsWith("'")) {
                    key = key.substring(1, key.length() - 1);
                }
                try {
                    return rb.getString(key);
                }
                catch (MissingResourceException e) {
                }
            }
            catch (MissingResourceException e) {
                LOG.error((Object)("Cannot load resource bundle with location '" + i18nLocation + "'."), (Throwable)e);
            }
        }
        return key;
    }

    public List getI18nLocations() {
        return this.i18nLocations;
    }

    public void setI18nLocations(List i18nLocations) {
        this.i18nLocations = i18nLocations;
    }

    public void afterPropertiesSet() throws Exception {
        this.defaultResourceLocation = "com.atlassian.crowd.console.action.BaseAction";
        this.locale = Locale.getDefault();
        this.i18nLocations = EasyList.build((Object)this.defaultResourceLocation);
    }

    private ResourceBundle getResourceBundle(String i18nLocation) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle(i18nLocation, this.getLocale(), classLoader);
    }

    private Locale getLocale() {
        return this.locale;
    }
}

