/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap;

import com.atlassian.crowd.integration.SearchContext;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.AttributeAware;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.integration.service.soap.ObjectTranslator;
import com.atlassian.crowd.integration.service.soap.server.SecurityServer;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MultiTermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.service.soap.SOAPService;
import com.google.common.collect.Sets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServerGeneric
implements SecurityServer {
    private static final Logger logger = Logger.getLogger(SecurityServerGeneric.class);
    private final SOAPService soapService;
    private final ApplicationManager applicationManager;
    private final ApplicationService applicationService;
    private final AliasManager aliasManager;
    private final DirectoryManager directoryManager;
    private final PropertyManager propertyManager;

    public SecurityServerGeneric(SOAPService soapService, ApplicationManager applicationManager, ApplicationService applicationService, AliasManager aliasManager, DirectoryManager directoryManager, PropertyManager propertyManager) {
        this.soapService = soapService;
        this.applicationManager = applicationManager;
        this.applicationService = applicationService;
        this.aliasManager = aliasManager;
        this.directoryManager = directoryManager;
        this.propertyManager = propertyManager;
    }

    public String createPrincipalToken(AuthenticatedToken applicationToken, String username, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InactiveAccountException, RemoteException, InvalidAuthenticationException, ApplicationAccessDeniedException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
            userAuthenticationContext.setApplication(applicationToken.getName());
            PasswordCredential passwordCredential = new PasswordCredential((String)null);
            userAuthenticationContext.setCredential(passwordCredential);
            userAuthenticationContext.setValidationFactors(validationFactors);
            userAuthenticationContext.setName(this.aliasManager.findUsernameByAlias(application, username));
            Token principalToken = this.applicationService.authenticateUserWithoutValidatingPassword(userAuthenticationContext);
            return principalToken.getRandomHash();
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
    }

    public String authenticatePrincipalSimple(AuthenticatedToken applicationToken, String username, String password) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
            userAuthenticationContext.setApplication(applicationToken.getName());
            PasswordCredential passwordCredential = new PasswordCredential(password);
            userAuthenticationContext.setCredential(passwordCredential);
            userAuthenticationContext.setValidationFactors(new ValidationFactor[0]);
            userAuthenticationContext.setName(this.aliasManager.findUsernameByAlias(application, username));
            Token principalToken = this.applicationService.authenticateUser(userAuthenticationContext);
            return principalToken.getRandomHash();
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
    }

    public AuthenticatedToken authenticateApplication(ApplicationAuthenticationContext authenticationContext) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException {
        ValidationFactor[] validationFactors = this.soapService.getApplicationClientValidationFactors(authenticationContext.getName());
        authenticationContext.setValidationFactors(validationFactors);
        Token token = this.applicationService.authenticateApplication(authenticationContext);
        AuthenticatedToken applicationToken = new AuthenticatedToken(token.getName(), token.getRandomHash());
        this.soapService.validateSOAPService(applicationToken);
        return applicationToken;
    }

    public String authenticatePrincipal(AuthenticatedToken applicationToken, UserAuthenticationContext authenticateContext) throws RemoteException, InvalidAuthenticationException, InactiveAccountException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException, ExpiredCredentialException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            authenticateContext.setName(this.aliasManager.findUsernameByAlias(application, authenticateContext.getName()));
            Token principalToken = this.applicationService.authenticateUser(authenticateContext);
            return principalToken.getRandomHash();
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
    }

    public boolean isValidPrincipalToken(AuthenticatedToken applicationToken, String principalToken, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            this.applicationService.validateUserToken(principalToken, validationFactors, application.getName());
            return true;
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (InvalidTokenException e) {
            return false;
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
    }

    public void invalidatePrincipalToken(AuthenticatedToken applicationToken, String token) throws RemoteException, InvalidAuthorizationTokenException {
        this.soapService.validateSOAPService(applicationToken);
        this.directoryManager.invalidateToken(token);
    }

    public SOAPGroup[] searchGroups(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        SearchContext.PopulateMemberships population = SearchContext.PopulateMemberships.ALL;
        String groupNameRestriction = null;
        String usernameRestriction = null;
        Boolean activeRestriction = null;
        int maxResults = -1;
        int startIndex = 0;
        if (searchRestrictions != null) {
            for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                if (restriction.getName().equals("group.populate.direct.sub.groups") || restriction.getName().equals("group.populate.memberships") || restriction.getName().equals("role.populate.memberships")) {
                    population = SearchContext.PopulateMemberships.parseString((String)restriction.getValue());
                    continue;
                }
                if (restriction.getName().equals("group.name")) {
                    groupNameRestriction = restriction.getValue().toLowerCase();
                    continue;
                }
                if (restriction.getName().equals("group.active")) {
                    activeRestriction = Boolean.valueOf(restriction.getValue().toLowerCase());
                    continue;
                }
                if (!restriction.getName().equals("group.principal.member")) continue;
                usernameRestriction = restriction.getValue();
            }
        }
        List groups = null;
        ArrayList<SOAPGroup> soapGroups = new ArrayList<SOAPGroup>();
        if (usernameRestriction != null) {
            try {
                groups = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).membershipsOf(EntityDescriptor.user()).withName(usernameRestriction).startingAt(startIndex).returningAtMost(maxResults));
                for (Group group : groups) {
                    SOAPGroup soapGroup = new SOAPGroup(group.getName(), new String[0]);
                    soapGroups.add(soapGroup);
                }
            }
            catch (DirectoryAccessException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }
        ArrayList<TermRestriction> restrictions = new ArrayList<TermRestriction>();
        if (groupNameRestriction != null) {
            restrictions.add(Restriction.on((Property)GroupTermKeys.NAME).containing(groupNameRestriction));
        }
        if (activeRestriction != null) {
            restrictions.add(Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching(activeRestriction));
        }
        GroupQuery query = null;
        if (restrictions.isEmpty()) {
            query = new GroupQuery(GroupType.GROUP, (SearchRestriction)new NullRestriction(), startIndex, maxResults);
        } else {
            MultiTermRestriction multiRestriction = new MultiTermRestriction(MultiTermRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new TermRestriction[restrictions.size()]));
            query = new GroupQuery((SearchRestriction)multiRestriction, startIndex, maxResults);
        }
        try {
            groups = this.applicationService.searchGroups(application, (EntityQuery)query);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        boolean aliasingEnabled = application.isAliasingEnabled();
        for (Group group : groups) {
            List members;
            switch (population) {
                case NONE: {
                    members = Collections.emptyList();
                    break;
                }
                case DIRECT: {
                    try {
                        members = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1).asNames());
                        break;
                    }
                    catch (DirectoryAccessException e) {
                        logger.info((Object)e.getMessage(), (Throwable)e);
                        throw new RemoteException(e.getMessage(), e);
                    }
                }
                default: {
                    try {
                        members = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1).asNames());
                        break;
                    }
                    catch (DirectoryAccessException e) {
                        logger.info((Object)e.getMessage(), (Throwable)e);
                        throw new RemoteException(e.getMessage(), e);
                    }
                }
            }
            if (!members.isEmpty() && aliasingEnabled) {
                members = this.getAliasedNamesForUsers(application, members);
            }
            SOAPGroup soapGroup = new SOAPGroup(group.getName(), members.toArray(new String[members.size()]));
            soapGroups.add(soapGroup);
        }
        return ObjectTranslator.processSOAPGroupAndMemberNames((SOAPGroup[])soapGroups.toArray(new SOAPGroup[soapGroups.size()]), (boolean)application.isLowerCaseOutput());
    }

    private List<String> getAliasedNamesForUsers(Application application, List<String> members) {
        ArrayList<String> aliasedusernames = new ArrayList<String>(members.size());
        for (String member : members) {
            aliasedusernames.add(this.aliasManager.findAliasByUsername(application, member));
        }
        return aliasedusernames;
    }

    public SOAPPrincipal[] searchPrincipals(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        List<User> finalMatchingUsers;
        Application application = this.soapService.validateSOAPService(applicationToken);
        UserQuery userQuery = this.buildUserQuery(application, searchRestrictions);
        if (!application.isAliasingEnabled()) {
            try {
                finalMatchingUsers = this.applicationService.searchUsers(application, (EntityQuery)userQuery);
            }
            catch (DirectoryAccessException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        List nonAliasedUsers = null;
        com.atlassian.crowd.integration.soap.SearchRestriction usernameRestriction = this.findUsernameSearchRestriction(searchRestrictions);
        if (usernameRestriction != null) {
            try {
                nonAliasedUsers = this.searchAliasedUsers(application, userQuery, usernameRestriction);
            }
            catch (DirectoryAccessException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        try {
            nonAliasedUsers = this.applicationService.searchUsers(application, (EntityQuery)userQuery);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        finalMatchingUsers = this.buildAliasedUsers(application, nonAliasedUsers);
        return ObjectTranslator.processUsers((Collection)finalMatchingUsers, (boolean)application.isLowerCaseOutput());
    }

    protected List<User> searchAliasedUsers(Application application, UserQuery userQuery, com.atlassian.crowd.integration.soap.SearchRestriction usernameRestriction) throws DirectoryAccessException {
        TreeSet matchingNonUsernameResults = Sets.newTreeSet((Iterable)this.applicationService.searchUsers(application, userQuery.asNames()));
        EntityQuery aliasQuery = this.buildAliasQuery(application, usernameRestriction);
        TreeSet matchingAliasedUsernames = Sets.newTreeSet((Iterable)this.aliasManager.search(aliasQuery));
        EntityQuery usernameQuery = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameRestriction.getValue().toLowerCase())).returningAtMost(-1);
        TreeSet matchingUsernames = Sets.newTreeSet((Iterable)this.applicationService.searchUsers(application, usernameQuery.asNames()));
        SortedSet<String> amalgamatedUsernames = this.amalgamateAliasedUsernames(application, matchingNonUsernameResults, matchingAliasedUsernames, matchingUsernames);
        ArrayList<User> nonAliasedUsers = new ArrayList<User>(matchingNonUsernameResults.size());
        for (String username : amalgamatedUsernames) {
            try {
                User user = this.applicationService.findUserByName(application, username);
                nonAliasedUsers.add(user);
            }
            catch (ObjectNotFoundException e) {}
        }
        return nonAliasedUsers;
    }

    protected List<User> buildAliasedUsers(Application application, List<User> finalUserResults) {
        ArrayList<User> aliasedUsers = new ArrayList<User>(finalUserResults.size());
        for (User nonAliasedUser : finalUserResults) {
            UserTemplate user = new UserTemplate(nonAliasedUser);
            user.setName(this.aliasManager.findAliasByUsername(application, user.getName()));
            aliasedUsers.add((User)user);
        }
        return aliasedUsers;
    }

    protected SortedSet<String> amalgamateAliasedUsernames(Application application, SortedSet<String> matchingNonUsernames, SortedSet<String> matchingAliasUsernames, SortedSet<String> matchingUsernames) {
        matchingNonUsernames.addAll(matchingAliasUsernames);
        Iterator it = matchingUsernames.iterator();
        while (it.hasNext()) {
            String matchingUsername = (String)it.next();
            String alias = this.aliasManager.findAliasByUsername(application, matchingUsername);
            if (alias.equals(matchingUsername)) continue;
            it.remove();
        }
        matchingNonUsernames.addAll(matchingUsernames);
        return matchingNonUsernames;
    }

    protected com.atlassian.crowd.integration.soap.SearchRestriction findUsernameSearchRestriction(com.atlassian.crowd.integration.soap.SearchRestriction ... searchRestrictions) {
        com.atlassian.crowd.integration.soap.SearchRestriction usernameRestriction = null;
        for (com.atlassian.crowd.integration.soap.SearchRestriction searchRestriction : searchRestrictions) {
            if (!"principal.name".equals(searchRestriction.getName()) && !"username".equals(searchRestriction.getName()) || !StringUtils.isNotBlank((String)searchRestriction.getValue())) continue;
            usernameRestriction = searchRestriction;
            break;
        }
        return usernameRestriction;
    }

    protected EntityQuery buildAliasQuery(Application application, com.atlassian.crowd.integration.soap.SearchRestriction usernameSearchRestriction) {
        EntityQuery aliasQuery = null;
        if ("principal.name".equals(usernameSearchRestriction.getName()) || "username".equals(usernameSearchRestriction.getName())) {
            aliasQuery = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.alias()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)AliasTermKeys.ALIAS).containing((Object)usernameSearchRestriction.getValue().toLowerCase()), Restriction.on((Property)AliasTermKeys.APPLICATION_ID).exactlyMatching((Object)application.getId())})).returningAtMost(-1).asNames();
        }
        return aliasQuery;
    }

    protected UserQuery buildUserQuery(Application application, com.atlassian.crowd.integration.soap.SearchRestriction ... searchRestrictions) {
        boolean aliasingEnabled = application.isAliasingEnabled();
        String nameRestriction = null;
        String emailRestriction = null;
        String fullNameRestriction = null;
        Boolean activeRestriction = null;
        int maxResults = -1;
        int startIndex = 0;
        if (searchRestrictions != null) {
            for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                if (!aliasingEnabled && restriction.getName().equals("principal.name") || restriction.getName().equals("username")) {
                    nameRestriction = restriction.getValue().toLowerCase();
                    continue;
                }
                if (restriction.getName().equals("principal.active")) {
                    activeRestriction = Boolean.valueOf(restriction.getValue().toLowerCase());
                    continue;
                }
                if (restriction.getName().equals("principal.email") || restriction.getName().equals("mail")) {
                    emailRestriction = restriction.getValue().toLowerCase();
                    continue;
                }
                if (!restriction.getName().equals("principal.fullname") && !restriction.getName().equals("displayName")) continue;
                fullNameRestriction = restriction.getValue().toLowerCase();
            }
        }
        ArrayList<TermRestriction> restrictions = new ArrayList<TermRestriction>();
        if (nameRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.USERNAME).containing(nameRestriction));
        }
        if (activeRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching(activeRestriction));
        }
        if (emailRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.EMAIL).containing(emailRestriction));
        }
        if (fullNameRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing(fullNameRestriction));
        }
        UserQuery query = null;
        if (restrictions.isEmpty()) {
            query = new UserQuery((SearchRestriction)new NullRestriction(), startIndex, maxResults);
        } else {
            MultiTermRestriction multiRestriction = new MultiTermRestriction(MultiTermRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new TermRestriction[restrictions.size()]));
            query = new UserQuery((SearchRestriction)multiRestriction, startIndex, maxResults);
        }
        return query;
    }

    public SOAPRole[] searchRoles(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        SearchContext.PopulateMemberships population = SearchContext.PopulateMemberships.ALL;
        String groupNameRestriction = null;
        Boolean activeRestriction = null;
        int maxResults = -1;
        int startIndex = 0;
        if (searchRestrictions != null) {
            for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                if (restriction.getName().equals("group.populate.direct.sub.groups") || restriction.getName().equals("group.populate.memberships") || restriction.getName().equals("role.populate.memberships")) {
                    population = SearchContext.PopulateMemberships.parseString((String)restriction.getValue());
                    continue;
                }
                if (restriction.getName().equals("role.name")) {
                    groupNameRestriction = restriction.getValue().toLowerCase();
                    continue;
                }
                if (!restriction.getName().equals("role.active")) continue;
                activeRestriction = Boolean.valueOf(restriction.getValue().toLowerCase());
            }
        }
        ArrayList<TermRestriction> restrictions = new ArrayList<TermRestriction>();
        if (groupNameRestriction != null) {
            restrictions.add(Restriction.on((Property)GroupTermKeys.NAME).containing(groupNameRestriction));
        }
        if (activeRestriction != null) {
            restrictions.add(Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching(activeRestriction));
        }
        GroupQuery query = null;
        if (restrictions.isEmpty()) {
            query = new GroupQuery(GroupType.LEGACY_ROLE, (SearchRestriction)new NullRestriction(), startIndex, maxResults);
        } else {
            MultiTermRestriction multiRestriction = new MultiTermRestriction(MultiTermRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new TermRestriction[restrictions.size()]));
            query = new GroupQuery((SearchRestriction)multiRestriction, startIndex, maxResults);
        }
        List groups = null;
        try {
            groups = this.applicationService.searchGroups(application, (EntityQuery)query);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        ArrayList<SOAPRole> soapRoles = new ArrayList<SOAPRole>(groups.size());
        boolean aliasingEnabled = application.isAliasingEnabled();
        for (Group group : groups) {
            List members;
            switch (population) {
                case NONE: {
                    members = Collections.emptyList();
                    break;
                }
                default: {
                    try {
                        members = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(group.getName()).returningAtMost(-1).asNames());
                        break;
                    }
                    catch (DirectoryAccessException e) {
                        logger.info((Object)e.getMessage(), (Throwable)e);
                        throw new RemoteException(e.getMessage(), e);
                    }
                }
            }
            if (!members.isEmpty() && aliasingEnabled) {
                members = this.getAliasedNamesForUsers(application, members);
            }
            SOAPRole soapRole = new SOAPRole(group.getName(), members.toArray(new String[members.size()]));
            soapRoles.add(soapRole);
        }
        return ObjectTranslator.processSOAPRoleAndMemberNames((SOAPRole[])soapRoles.toArray(new SOAPRole[soapRoles.size()]), (boolean)application.isLowerCaseOutput());
    }

    public SOAPGroup addGroup(AuthenticatedToken applicationToken, SOAPGroup soapGroup) throws RemoteException, InvalidAuthorizationTokenException, InvalidGroupException, ApplicationPermissionException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            Group remoteGroup = this.applicationService.addGroup(application, ObjectTranslator.processGroup((SOAPGroup)soapGroup));
            List<String> nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1).asNames());
            if (!nestedMemberNames.isEmpty() && application.isAliasingEnabled()) {
                nestedMemberNames = this.getAliasedNamesForUsers(application, nestedMemberNames);
            }
            return ObjectTranslator.processGroup((Group)remoteGroup, (List)nestedMemberNames, (boolean)application.isLowerCaseOutput());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void updateGroup(AuthenticatedToken authenticatedToken, String groupName, String description, boolean active) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        Application application = this.soapService.validateSOAPService(authenticatedToken);
        GroupTemplate groupTemplate = new GroupTemplate(groupName, null, GroupType.GROUP);
        groupTemplate.setActive(active);
        groupTemplate.setDescription(description);
        try {
            this.applicationService.updateGroup(application, groupTemplate);
        }
        catch (InvalidGroupException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPGroup findGroupByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        Group remoteGroup = null;
        try {
            remoteGroup = this.applicationService.findGroupByName(application, name);
            if (remoteGroup.getType() != GroupType.GROUP) {
                throw new ObjectNotFoundException(Group.class, (Object)name);
            }
            List<String> nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1).asNames());
            if (!nestedMemberNames.isEmpty() && application.isAliasingEnabled()) {
                nestedMemberNames = this.getAliasedNamesForUsers(application, nestedMemberNames);
            }
            return ObjectTranslator.processGroup((Group)remoteGroup, (List)nestedMemberNames, (boolean)application.isLowerCaseOutput());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPGroup findGroupWithAttributesByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            GroupWithAttributes remoteGroup = this.applicationService.findGroupWithAttributesByName(application, name);
            if (remoteGroup.getType() != GroupType.GROUP) {
                throw new ObjectNotFoundException(Group.class, (Object)name);
            }
            List<String> nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1).asNames());
            if (!nestedMemberNames.isEmpty() && application.isAliasingEnabled()) {
                nestedMemberNames = this.getAliasedNamesForUsers(application, nestedMemberNames);
            }
            return ObjectTranslator.processGroupWithAttributes((GroupWithAttributes)remoteGroup, (List)nestedMemberNames, (boolean)application.isLowerCaseOutput());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPRole addRole(AuthenticatedToken applicationToken, SOAPRole soapRole) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        Group remoteRole = null;
        try {
            remoteRole = this.applicationService.addGroup(application, ObjectTranslator.processRole((SOAPRole)soapRole));
            List<String> directMemberNames = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(remoteRole.getName()).returningAtMost(-1).asNames());
            if (!directMemberNames.isEmpty() && application.isAliasingEnabled()) {
                directMemberNames = this.getAliasedNamesForUsers(application, directMemberNames);
            }
            return ObjectTranslator.processRole((Group)remoteRole, (List)directMemberNames, (boolean)application.isLowerCaseOutput());
        }
        catch (InvalidGroupException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPRole findRoleByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        Group remoteRole = null;
        try {
            remoteRole = this.applicationService.findGroupByName(application, name);
            if (remoteRole.getType() != GroupType.LEGACY_ROLE) {
                throw new ObjectNotFoundException(Group.class, (Object)name);
            }
            List<String> directMemberNames = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(remoteRole.getName()).returningAtMost(-1).asNames());
            if (!directMemberNames.isEmpty() && application.isAliasingEnabled()) {
                directMemberNames = this.getAliasedNamesForUsers(application, directMemberNames);
            }
            return ObjectTranslator.processRole((Group)remoteRole, (List)directMemberNames, (boolean)application.isLowerCaseOutput());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPPrincipal findPrincipalByToken(AuthenticatedToken applicationToken, String key) throws InvalidAuthorizationTokenException, RemoteException, InvalidTokenException {
        User user;
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            user = this.directoryManager.findUserByToken(key);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        SOAPPrincipal soapPrincipal = ObjectTranslator.processUser((User)user, (boolean)application.isLowerCaseOutput());
        String username = this.aliasManager.findAliasByUsername(application, user.getName());
        soapPrincipal.setName(ObjectTranslator.processDirectoryEntityName((String)username, (boolean)application.isLowerCaseOutput()));
        return soapPrincipal;
    }

    public void updatePrincipalAttribute(AuthenticatedToken applicationToken, String name, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, name);
        try {
            this.storePrincipalAttribute(application, username, attribute);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (InvalidUserException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void updateGroupAttribute(AuthenticatedToken applicationToken, String group, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            String groupname = this.applicationService.findGroupByName(application, group).getName();
            this.storeCustomGroupAttribute(application, groupname, attribute);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPPrincipal findPrincipalByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            String username = this.aliasManager.findUsernameByAlias(application, name);
            User remotePrincipal = this.applicationService.findUserByName(application, username);
            SOAPPrincipal principal = ObjectTranslator.processUser((User)remotePrincipal, (boolean)application.isLowerCaseOutput());
            principal.setName(ObjectTranslator.processDirectoryEntityName((String)name, (boolean)application.isLowerCaseOutput()));
            return principal;
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPPrincipal findPrincipalWithAttributesByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            String username = this.aliasManager.findUsernameByAlias(application, name);
            UserWithAttributes remotePrincipal = this.applicationService.findUserWithAttributesByName(application, username);
            SOAPPrincipal principal = ObjectTranslator.processUserWithAttributes((UserWithAttributes)remotePrincipal, (boolean)application.isLowerCaseOutput());
            principal.setName(ObjectTranslator.processDirectoryEntityName((String)name, (boolean)application.isLowerCaseOutput()));
            return principal;
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public SOAPPrincipal addPrincipal(AuthenticatedToken applicationToken, SOAPPrincipal principal, PasswordCredential credential) throws InvalidAuthorizationTokenException, RemoteException, InvalidCredentialException, ApplicationPermissionException {
        SOAPPrincipal soapPrincipal;
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            User user = this.applicationService.addUser(application, ObjectTranslator.processUser((SOAPPrincipal)principal), credential);
            soapPrincipal = ObjectTranslator.processUser((User)user, (boolean)application.isLowerCaseOutput());
            Map attributes = ObjectTranslator.buildUserAttributeMap((SOAPPrincipal)principal);
            if (!attributes.isEmpty()) {
                this.applicationService.storeUserAttributes(application, user.getName(), attributes);
                UserWithAttributes userWithAttributes = this.applicationService.findUserWithAttributesByName(application, user.getName());
                soapPrincipal = ObjectTranslator.processUserWithAttributes((UserWithAttributes)userWithAttributes, (boolean)application.isLowerCaseOutput());
            }
        }
        catch (InvalidUserException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        return soapPrincipal;
    }

    public void addAllPrincipals(AuthenticatedToken applicationToken, SOAPPrincipalWithCredential[] principals) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        ArrayList<UserTemplateWithCredentialAndAttributes> userTemplates = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        for (int i = 0; i < principals.length; ++i) {
            SOAPPrincipalWithCredential principalWithCredential = principals[i];
            SOAPPrincipal principal = principalWithCredential.getPrincipal();
            UserTemplate user = ObjectTranslator.processUser((SOAPPrincipal)principal);
            AttributeAware attibutes = ObjectTranslator.processUserAttributes((SOAPPrincipal)principal);
            UserTemplateWithCredentialAndAttributes userTemplate = new UserTemplateWithCredentialAndAttributes((User)user, attibutes, principalWithCredential.getPasswordCredential());
            userTemplates.add(userTemplate);
        }
        try {
            this.applicationService.addAllUsers(application, userTemplates);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void addPrincipalToGroup(AuthenticatedToken applicationToken, String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.applicationService.addUserToGroup(application, username, group);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void updatePrincipalCredential(AuthenticatedToken applicationToken, String principal, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.applicationService.updateUserCredential(application, username, credential);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void resetPrincipalCredential(AuthenticatedToken applicationToken, String principal) throws RemoteException, InvalidEmailAddressException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.applicationService.resetUserCredential(application, username);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void removeGroup(AuthenticatedToken applicationToken, String group) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            this.applicationService.removeGroup(application, group);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void removeRole(AuthenticatedToken applicationToken, String role) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        this.removeGroup(applicationToken, role);
    }

    public void removePrincipal(AuthenticatedToken applicationToken, String principal) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.applicationService.removeUser(application, username);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void addPrincipalToRole(AuthenticatedToken applicationToken, String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        this.addPrincipalToGroup(applicationToken, principal, role);
    }

    public boolean isGroupMember(AuthenticatedToken applicationToken, String group, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            return this.applicationService.isUserNestedGroupMember(application, username, group);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public boolean isRoleMember(AuthenticatedToken applicationToken, String role, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        return this.isGroupMember(applicationToken, principal, role);
    }

    public void removePrincipalFromGroup(AuthenticatedToken applicationToken, String principal, String group) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.applicationService.removeUserFromGroup(application, username, group);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (MembershipNotFoundException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new ObjectNotFoundException((Throwable)e);
        }
    }

    public void removePrincipalFromRole(AuthenticatedToken applicationToken, String principal, String role) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, ApplicationPermissionException {
        this.removePrincipalFromGroup(applicationToken, principal, role);
    }

    private boolean isPrimaryUserAttribute(String attributeName) {
        return "givenName".equals(attributeName) || "sn".equals(attributeName) || "displayName".equals(attributeName) || "mail".equals(attributeName) || "iconLocation".equals(attributeName) || "active".equals(attributeName);
    }

    private void updatePrimaryUserAttribute(Application application, String username, SOAPAttribute attribute) throws ObjectNotFoundException, DirectoryAccessException, ApplicationPermissionException, InvalidUserException {
        String value;
        User user = this.applicationService.findUserByName(application, username);
        UserTemplate userTemplate = new UserTemplate(user);
        if ((attribute.getValues() == null || attribute.getValues().length > 0) && (value = attribute.getValues()[0]) != null) {
            if ("givenName".equals(attribute.getName())) {
                userTemplate.setFirstName(value);
            } else if ("sn".equals(attribute.getName())) {
                userTemplate.setLastName(value);
            } else if ("displayName".equals(attribute.getName())) {
                userTemplate.setDisplayName(value);
            } else if ("mail".equals(attribute.getName())) {
                userTemplate.setEmailAddress(value);
            } else if ("iconLocation".equals(attribute.getName())) {
                userTemplate.setIconLocation(value);
            } else if ("active".equals(attribute.getName())) {
                userTemplate.setActive(Boolean.valueOf(value).booleanValue());
            }
            this.applicationService.updateUser(application, userTemplate);
        }
    }

    private void storeCustomUserAttribute(Application application, String username, SOAPAttribute attribute) throws ApplicationPermissionException, ObjectNotFoundException, DirectoryAccessException {
        HashMap<String, List<String>> attribs = new HashMap<String, List<String>>();
        attribs.put(attribute.getName(), Arrays.asList(attribute.getValues()));
        this.applicationService.storeUserAttributes(application, username, attribs);
    }

    private void storeCustomGroupAttribute(Application application, String group, SOAPAttribute attribute) throws ApplicationPermissionException, ObjectNotFoundException, DirectoryAccessException {
        HashMap<String, List<String>> attribs = new HashMap<String, List<String>>();
        attribs.put(attribute.getName(), Arrays.asList(attribute.getValues()));
        this.applicationService.storeGroupAttributes(application, group, attribs);
    }

    private void storePrincipalAttribute(Application application, String username, SOAPAttribute attribute) throws ObjectNotFoundException, DirectoryAccessException, ApplicationPermissionException, InvalidUserException {
        if (this.isPrimaryUserAttribute(attribute.getName())) {
            this.updatePrimaryUserAttribute(application, username, attribute);
        } else {
            this.storeCustomUserAttribute(application, username, attribute);
        }
    }

    private void removePrincipalAttribute(Application application, String username, String attributeName) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException, DirectoryAccessException {
        if (this.isPrimaryUserAttribute(attributeName)) {
            throw new RemoteException("Cannot remove the attribute <" + attributeName + "> as it is a primary attribute");
        }
        this.applicationService.removeUserAttributes(application, username, attributeName);
    }

    private void removeGroupAttribute(Application application, String groupname, String attributeName) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException, DirectoryAccessException {
        this.applicationService.removeGroupAttributes(application, groupname, attributeName);
    }

    public void addAttributeToPrincipal(AuthenticatedToken applicationToken, String principal, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        this.updatePrincipalAttribute(applicationToken, principal, attribute);
    }

    public void addAttributeToGroup(AuthenticatedToken applicationToken, String group, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        this.updateGroupAttribute(applicationToken, group, attribute);
    }

    public void removeAttributeFromPrincipal(AuthenticatedToken applicationToken, String principal, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principal);
        try {
            this.removePrincipalAttribute(application, username, attribute);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void removeAttributeFromGroup(AuthenticatedToken applicationToken, String group, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            String groupname = this.applicationService.findGroupByName(application, group).getName();
            this.removeGroupAttribute(application, groupname, attribute);
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public long getCacheTime(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            return this.propertyManager.getCacheTime();
        }
        catch (PropertyManagerException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public boolean isCacheEnabled(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        this.soapService.validateSOAPService(applicationToken);
        return this.propertyManager.isCacheEnabled();
    }

    public String getDomain(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        String domain;
        try {
            this.soapService.validateSOAPService(applicationToken);
            domain = this.propertyManager.getDomain();
        }
        catch (PropertyManagerException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return domain;
    }

    public String[] findAllPrincipalNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        List usernames = null;
        try {
            usernames = this.applicationService.searchUsers(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1).asNames());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        ArrayList<String> normalisedNames = new ArrayList<String>(usernames.size());
        boolean aliasingEnabled = application.isAliasingEnabled();
        boolean lowerCaseOutput = application.isLowerCaseOutput();
        for (String name : usernames) {
            if (aliasingEnabled) {
                name = this.aliasManager.findAliasByUsername(application, name);
            }
            normalisedNames.add(ObjectTranslator.processDirectoryEntityName((String)name, (boolean)lowerCaseOutput));
        }
        return normalisedNames.toArray(new String[normalisedNames.size()]);
    }

    public String[] findAllGroupNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        List groupNames = null;
        try {
            groupNames = this.applicationService.searchGroups(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1).asNames());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        ArrayList<String> normalisedNames = new ArrayList<String>(groupNames.size());
        boolean lowerCaseOutput = application.isLowerCaseOutput();
        for (String name : groupNames) {
            normalisedNames.add(ObjectTranslator.processDirectoryEntityName((String)name, (boolean)lowerCaseOutput));
        }
        return normalisedNames.toArray(new String[normalisedNames.size()]);
    }

    public SOAPNestableGroup[] findAllGroupRelationships(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        try {
            List groups = this.applicationService.searchGroups(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
            ArrayList<SOAPNestableGroup> soapNestableGroups = new ArrayList<SOAPNestableGroup>();
            for (Group group : groups) {
                List childGroups = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).membersOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1).asNames());
                soapNestableGroups.add(new SOAPNestableGroup(group.getName(), childGroups.toArray(new String[childGroups.size()])));
            }
            return ObjectTranslator.processSOAPNestableGroupAndMemberNames(soapNestableGroups, (boolean)application.isLowerCaseOutput());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public String[] findAllRoleNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        return this.findAllGroupNames(applicationToken);
    }

    public String[] findGroupMemberships(AuthenticatedToken applicationToken, String principalName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        List memberships;
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principalName);
        try {
            memberships = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).membershipsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1).asNames());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        memberships = ObjectTranslator.processDirectoryEntityNames((Collection)memberships, (boolean)application.isLowerCaseOutput());
        return memberships.toArray(new String[memberships.size()]);
    }

    public String[] findRoleMemberships(AuthenticatedToken applicationToken, String principalName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        List memberships;
        Application application = this.soapService.validateSOAPService(applicationToken);
        String username = this.aliasManager.findUsernameByAlias(application, principalName);
        try {
            memberships = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).membershipsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1).asNames());
        }
        catch (DirectoryAccessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        memberships = ObjectTranslator.processDirectoryEntityNames((Collection)memberships, (boolean)application.isLowerCaseOutput());
        return memberships.toArray(new String[memberships.size()]);
    }

    public String[] getGrantedAuthorities(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        Application application = this.soapService.validateSOAPService(applicationToken);
        HashSet<String> groupNames = new HashSet<String>();
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                groupNames.add(groupMapping.getGroupName());
            }
        }
        List groupNamesList = ObjectTranslator.processDirectoryEntityNames(groupNames, (boolean)application.isLowerCaseOutput());
        return groupNamesList.toArray(new String[groupNamesList.size()]);
    }

    public SOAPCookieInfo getCookieInfo(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        this.soapService.validateSOAPService(applicationToken);
        SOAPCookieInfo cookieInfo = new SOAPCookieInfo();
        try {
            cookieInfo.setDomain(this.propertyManager.getDomain());
            cookieInfo.setSecure(this.propertyManager.isSecureCookie());
        }
        catch (PropertyManagerException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return cookieInfo;
    }

    protected boolean isLowerCaseOutput(AuthenticatedToken applicationToken) {
        boolean forceLower = false;
        if (applicationToken != null && applicationToken.getName() != null) {
            try {
                Application application = this.applicationManager.findByName(applicationToken.getName());
                forceLower = application.isLowerCaseOutput();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return forceLower;
    }
}

