/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.hibernate;

import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MultiTermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQLQueryTranslater {
    protected static final String HQL_USER_NAME = "lowerName";
    protected static final String HQL_USER_EMAIL_ADDRESS = "lowerEmailAddress";
    protected static final String HQL_USER_FIRST_NAME = "lowerFirstName";
    protected static final String HQL_USER_LAST_NAME = "lowerLastName";
    protected static final String HQL_USER_DISPLAY_NAME = "lowerDisplayName";
    protected static final String HQL_USER_ACTIVE = "active";
    protected static final String HQL_GROUP_NAME = "lowerName";
    protected static final String HQL_GROUP_ACTIVE = "active";
    protected static final String HQL_GROUP_TYPE = "type";
    protected static final String HQL_TOKEN_NAME = "name";
    protected static final String HQL_TOKEN_LAST_ACCESSED_DATE = "lastAccessedDate";
    protected static final String HQL_TOKEN_DIRECTORY_ID = "directoryId";
    protected static final String HQL_TOKEN_RANDOM_NUMBER = "randomNumber";
    protected static final String HQL_DIRECTORY_NAME = "lowerName";
    protected static final String HQL_DIRECTORY_ACTIVE = "active";
    protected static final String HQL_DIRECTORY_TYPE = "type";
    protected static final String HQL_DIRECTORY_IMPLEMENTATION_CLASS = "lowerImplementationClass";
    protected static final String HQL_APPLICATION_NAME = "lowerName";
    protected static final String HQL_APPLICATION_ACTIVE = "active";
    protected static final String HQL_APPLICATION_TYPE = "type";
    protected static final String HQL_ALIAS_NAME = "lowerAlias";
    protected static final String HQL_ALIAS_APPLICATION_ID = "application.id";
    protected static final String HQL_ALIAS_USERNAME = "lowerName";
    protected static final String HQL_ATTRIBUTE_NAME = "name";
    protected static final String HQL_ATTRIBUTE_VALUE = "lowerValue";
    protected static final String HQL_ATTRIBUTE_ALIAS = "attr";
    protected static final String HQL_DIRECTORY_ID = ".directory.id";
    protected static final String HQL_MEMBERSHIP_ALIAS = "mem";
    protected static final String HQL_MEMBERSHIP_TYPE = "membershipType";
    protected static final String HQL_MEMBERSHIP_GROUP_TYPE = "groupType";

    public HQLQuery asHQL(long directoryID, MembershipQuery query) {
        if (query.getReturnType() == ReturnType.NAME) {
            return this.membershipNamesQueryAsHQL(directoryID, query);
        }
        return this.membershipEntityQueryAsHQL(directoryID, query);
    }

    protected HQLQuery membershipNamesQueryAsHQL(long directoryID, MembershipQuery query) {
        HQLQuery hql = new HQLQuery();
        hql.appendSelect(HQL_MEMBERSHIP_ALIAS);
        hql.appendOrderBy(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindMembers()) {
            hql.appendSelect(".childName, ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName");
            hql.appendOrderBy(".lowerChildName");
        } else {
            hql.appendSelect(".parentName, ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName");
            hql.appendOrderBy(".lowerParentName");
        }
        hql.appendFrom(InternalMembership.class.getSimpleName()).append(" ").append(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindMembers()) {
            hql.appendWhere(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName = ?");
        } else {
            hql.appendWhere(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName = ?");
        }
        hql.addParameterValue(query.getEntityNameToMatch().toLowerCase());
        this.appendMembershipTypeAndDirectoryIDAndGroupType(directoryID, query, hql);
        return hql;
    }

    private void appendMembershipTypeAndDirectoryIDAndGroupType(long directoryID, MembershipQuery query, HQLQuery hql) {
        hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".").append(HQL_MEMBERSHIP_TYPE).append(" = ?");
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            hql.addParameterValue(MembershipType.GROUP_GROUP);
        } else {
            hql.addParameterValue(MembershipType.GROUP_USER);
        }
        hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".directory.id = ?");
        hql.addParameterValue(directoryID);
        GroupType groupType = null;
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP) {
            groupType = query.getEntityToMatch().getGroupType();
        }
        if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            if (groupType != null && groupType != query.getEntityToReturn().getGroupType()) {
                throw new IllegalArgumentException("Cannot search memberships of conflicting group types");
            }
            groupType = query.getEntityToReturn().getGroupType();
        }
        if (groupType != null) {
            hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".").append(HQL_MEMBERSHIP_GROUP_TYPE).append(" = ?");
            hql.addParameterValue(groupType);
        }
    }

    protected HQLQuery membershipEntityQueryAsHQL(long directoryID, MembershipQuery query) {
        HQLQuery hql = new HQLQuery();
        String persistedClass = this.transformEntityToPersistedClass(query.getEntityToReturn().getEntityType());
        String alias = this.transformEntityToAlias(query.getEntityToReturn().getEntityType());
        hql.appendSelect(alias);
        hql.appendFrom(persistedClass).append(" ").append(alias).append(", ").append(InternalMembership.class.getSimpleName()).append(" ").append(HQL_MEMBERSHIP_ALIAS);
        hql.appendWhere(alias).append(".id = ").append(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindMembers()) {
            hql.appendWhere(".childId AND ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName = ?");
        } else {
            hql.appendWhere(".parentId AND ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName = ?");
        }
        hql.addParameterValue(query.getEntityNameToMatch().toLowerCase());
        this.appendMembershipTypeAndDirectoryIDAndGroupType(directoryID, query, hql);
        return hql;
    }

    public HQLQuery asHQL(EntityQuery entityQuery) {
        HQLQuery hql = new HQLQuery();
        this.appendQueryAsHQL(entityQuery, hql);
        return hql;
    }

    public HQLQuery asHQL(long directoryID, EntityQuery entityQuery) {
        HQLQuery hql = new HQLQuery();
        String entityAlias = this.transformEntityToAlias(entityQuery.getEntityDescriptor().getEntityType());
        hql.appendWhere(entityAlias).append(HQL_DIRECTORY_ID).append(" = ?");
        hql.addParameterValue(directoryID);
        this.appendQueryAsHQL(entityQuery, hql);
        return hql;
    }

    protected void appendQueryAsHQL(EntityQuery query, HQLQuery hql) {
        String persistedClass = this.transformEntityToPersistedClass(query.getEntityDescriptor().getEntityType());
        String alias = this.transformEntityToAlias(query.getEntityDescriptor().getEntityType());
        hql.appendSelect(alias);
        if (query.getReturnType() == ReturnType.NAME) {
            this.appendSelectProjectionAsNames(hql, query.getEntityDescriptor().getEntityType());
        }
        hql.appendFrom(persistedClass).append(" ").append(alias);
        if (query.getEntityDescriptor().getEntityType() == Entity.GROUP && query.getEntityDescriptor().getGroupType() != null) {
            if (hql.whereRequired) {
                hql.appendWhere(" AND ");
            }
            this.appendGroupTypeRestrictionAsHQL(hql, query.getEntityDescriptor().getGroupType());
        }
        if (!(query.getSearchRestriction() instanceof NullRestriction)) {
            if (hql.whereRequired) {
                hql.appendWhere(" AND ");
            }
            this.appendPropertyRestrictionAsHQL(hql, query.getEntityDescriptor().getEntityType(), query.getSearchRestriction());
        }
        this.appendOrderByClause(hql, query.getEntityDescriptor().getEntityType());
    }

    protected void appendPropertyRestrictionAsHQL(HQLQuery hql, Entity entityType, SearchRestriction restriction) {
        if (!(restriction instanceof NullRestriction)) {
            if (restriction instanceof TermRestriction) {
                TermRestriction termRestriction = (TermRestriction)restriction;
                if (String.class.equals((Object)termRestriction.getType())) {
                    this.appendStringTermRestrictionAsHQL(hql, entityType, (TermRestriction<String>)termRestriction);
                } else if (Boolean.class.equals((Object)termRestriction.getType())) {
                    this.appendBooleanTermRestrictionAsHQL(hql, entityType, (TermRestriction<Boolean>)termRestriction);
                } else if (Enum.class.equals((Object)termRestriction.getType())) {
                    this.appendEnumTermRestrictionAsHQL(hql, entityType, (TermRestriction<Enum>)termRestriction);
                } else if (Date.class.isAssignableFrom(termRestriction.getType())) {
                    this.appendDateTermRestriction(hql, entityType, (TermRestriction<? extends Date>)termRestriction);
                } else if (Number.class.isAssignableFrom(termRestriction.getType())) {
                    this.appendNumberTermRestriction(hql, entityType, (TermRestriction<? extends Number>)termRestriction);
                }
            } else if (restriction instanceof MultiTermRestriction) {
                this.appendMultiTermRestrictionAsHQL(hql, entityType, (MultiTermRestriction)restriction);
            } else {
                throw new IllegalArgumentException("ProperyRestriction unsupported: " + restriction.getClass());
            }
        }
    }

    private void appendNumberTermRestriction(HQLQuery hql, Entity entityType, TermRestriction<? extends Number> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, (PropertyRestriction)restriction);
        this.appendComparableValueAsHQL(hql, restriction);
    }

    protected void appendDateTermRestriction(HQLQuery hql, Entity entityType, TermRestriction<? extends Date> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, (PropertyRestriction)restriction);
        this.appendComparableValueAsHQL(hql, restriction);
    }

    protected void appendBooleanTermRestrictionAsHQL(HQLQuery hql, Entity entityType, TermRestriction<Boolean> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, (PropertyRestriction)restriction);
        hql.appendWhere("= ?");
        hql.addParameterValue(restriction.getValue());
    }

    protected void appendEnumTermRestrictionAsHQL(HQLQuery hql, Entity entityType, TermRestriction<Enum> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, (PropertyRestriction)restriction);
        hql.appendWhere("= ?");
        hql.addParameterValue(restriction.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendMultiTermRestrictionAsHQL(HQLQuery hql, Entity entityType, MultiTermRestriction multiTermRestriction) {
        hql.appendWhere(" (");
        boolean first = true;
        for (SearchRestriction restriction : multiTermRestriction.getRestrictions()) {
            if (!first) {
                if (multiTermRestriction.getBooleanLogic() == MultiTermRestriction.BooleanLogic.AND) {
                    hql.appendWhere(" AND ");
                } else {
                    if (multiTermRestriction.getBooleanLogic() != MultiTermRestriction.BooleanLogic.OR) throw new IllegalArgumentException("BooleanLogic unsupported: " + multiTermRestriction.getBooleanLogic());
                    hql.appendWhere(" OR ");
                }
            } else {
                first = false;
            }
            this.appendPropertyRestrictionAsHQL(hql, entityType, restriction);
        }
        hql.appendWhere(") ");
    }

    protected void appendStringTermRestrictionAsHQL(HQLQuery hql, Entity entityType, TermRestriction<String> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, (PropertyRestriction)restriction);
        this.appendStringValueAsHQL(hql, restriction);
    }

    protected void appendEntityPropertyAsHQL(HQLQuery hql, Entity entityType, PropertyRestriction restriction) {
        switch (entityType) {
            case USER: {
                this.appendUserPropertyAsHQL(hql, restriction);
                break;
            }
            case GROUP: {
                this.appendGroupPropertyAsHQL(hql, restriction);
                break;
            }
            case TOKEN: {
                this.appendTokenPropertyAsHQL(hql, restriction);
                break;
            }
            case DIRECTORY: {
                this.appendDirectoryPropertyAsHQL(hql, restriction);
                break;
            }
            case APPLICATION: {
                this.appendApplicationPropertyAsHQL(hql, restriction);
                break;
            }
            case ALIAS: {
                this.appendAliasPropertyAsHQL(hql, restriction);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot form property restriction for entity of type <" + entityType + ">");
            }
        }
    }

    private void appendAliasPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.ALIAS);
        if (restriction.getProperty().equals((Object)AliasTermKeys.ALIAS)) {
            hql.appendWhere(alias).append(".").append(HQL_ALIAS_NAME);
        } else if (restriction.getProperty().equals((Object)AliasTermKeys.APPLICATION_ID)) {
            hql.appendWhere(alias).append(".").append(HQL_ALIAS_APPLICATION_ID);
        } else {
            throw new IllegalArgumentException("Alias does not support searching by property: " + restriction.getPropertyName());
        }
        hql.appendWhere(" ");
    }

    private void appendApplicationPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.APPLICATION);
        if (restriction.getProperty().equals((Object)DirectoryTermKeys.NAME)) {
            hql.appendWhere(alias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals((Object)DirectoryTermKeys.ACTIVE)) {
            hql.appendWhere(alias).append(".").append("active");
        } else if (restriction.getProperty().equals((Object)DirectoryTermKeys.TYPE)) {
            hql.appendWhere(alias).append(".").append("type");
        } else {
            throw new IllegalArgumentException("Application does not support searching by property: " + restriction.getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendDirectoryPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.DIRECTORY);
        if (restriction.getProperty().equals((Object)DirectoryTermKeys.NAME)) {
            hql.appendWhere(alias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals((Object)DirectoryTermKeys.ACTIVE)) {
            hql.appendWhere(alias).append(".").append("active");
        } else if (restriction.getProperty().equals((Object)DirectoryTermKeys.IMPLEMENTATION_CLASS)) {
            hql.appendWhere(alias).append(".").append(HQL_DIRECTORY_IMPLEMENTATION_CLASS);
        } else if (restriction.getProperty().equals((Object)DirectoryTermKeys.TYPE)) {
            hql.appendWhere(alias).append(".").append("type");
        } else {
            throw new IllegalArgumentException("Directory does not support searching by property: " + restriction.getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendTokenPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String tokenAlias = this.transformEntityToAlias(Entity.TOKEN);
        if (restriction.getProperty().equals((Object)TokenTermKeys.NAME)) {
            hql.appendWhere(tokenAlias).append(".").append("name");
        } else if (restriction.getProperty().equals((Object)TokenTermKeys.LAST_ACCESSED_DATE)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_LAST_ACCESSED_DATE);
        } else if (restriction.getProperty().equals((Object)TokenTermKeys.DIRECTORY_ID)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_DIRECTORY_ID);
        } else if (restriction.getProperty().equals((Object)TokenTermKeys.RANDOM_NUMBER)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_RANDOM_NUMBER);
        } else {
            throw new IllegalArgumentException("Token does not support searching by property: " + restriction.getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendGroupTypeRestrictionAsHQL(HQLQuery hql, GroupType groupType) {
        if (groupType != null) {
            String groupAlias = this.transformEntityToAlias(Entity.GROUP);
            hql.appendWhere(groupAlias).append(".").append("type");
            hql.appendWhere(" = ?");
            hql.addParameterValue(groupType);
        }
    }

    protected void appendGroupPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String groupAlias = this.transformEntityToAlias(Entity.GROUP);
        if (restriction.getProperty().equals((Object)GroupTermKeys.NAME)) {
            hql.appendWhere(groupAlias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals((Object)GroupTermKeys.ACTIVE)) {
            hql.appendWhere(groupAlias).append(".").append("active");
        } else {
            StringBuilder alias = hql.getNextAlias(HQL_ATTRIBUTE_ALIAS);
            hql.appendFrom(", InternalGroupAttribute ").append((CharSequence)alias);
            hql.appendWhere(groupAlias).append(".id = ").append((CharSequence)alias).append(".group.id").append(" AND ").append((CharSequence)alias).append(".").append("name").append(" = ?").append(" AND ").append((CharSequence)alias).append(".").append(HQL_ATTRIBUTE_VALUE);
            hql.addParameterValue(restriction.getProperty().getPropertyName());
            hql.requireDistinct();
        }
        hql.appendWhere(" ");
    }

    protected void appendUserPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String userAlias = this.transformEntityToAlias(Entity.USER);
        if (restriction.getProperty().equals((Object)UserTermKeys.USERNAME)) {
            hql.appendWhere(userAlias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals((Object)UserTermKeys.EMAIL)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_EMAIL_ADDRESS);
        } else if (restriction.getProperty().equals((Object)UserTermKeys.FIRST_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_FIRST_NAME);
        } else if (restriction.getProperty().equals((Object)UserTermKeys.LAST_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_LAST_NAME);
        } else if (restriction.getProperty().equals((Object)UserTermKeys.DISPLAY_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_DISPLAY_NAME);
        } else if (restriction.getProperty().equals((Object)UserTermKeys.ACTIVE)) {
            hql.appendWhere(userAlias).append(".").append("active");
        } else {
            StringBuilder attrAlias = hql.getNextAlias(HQL_ATTRIBUTE_ALIAS);
            hql.appendFrom(", InternalUserAttribute ").append((CharSequence)attrAlias);
            hql.appendWhere(userAlias).append(".id = ").append((CharSequence)attrAlias).append(".user.id").append(" AND ").append((CharSequence)attrAlias).append(".").append("name").append(" = ?").append(" AND ").append((CharSequence)attrAlias).append(".").append(HQL_ATTRIBUTE_VALUE);
            hql.addParameterValue(restriction.getProperty().getPropertyName());
            hql.requireDistinct();
        }
        hql.appendWhere(" ");
    }

    protected void appendStringValueAsHQL(HQLQuery hql, TermRestriction<String> restriction) {
        String lowerValue = ((String)restriction.getValue()).toLowerCase();
        switch (restriction.getMatchMode()) {
            case STARTS_WITH: {
                hql.appendWhere("LIKE ?");
                hql.addParameterValue(lowerValue + "%");
                break;
            }
            case CONTAINS: {
                hql.appendWhere("LIKE ?");
                hql.addParameterValue("%" + lowerValue + "%");
                break;
            }
            default: {
                hql.appendWhere("= ?");
                hql.addParameterValue(lowerValue);
            }
        }
    }

    protected void appendComparableValueAsHQL(HQLQuery hql, TermRestriction restriction) {
        switch (restriction.getMatchMode()) {
            case GREATER_THAN: {
                hql.appendWhere("> ?");
                break;
            }
            case LESS_THAN: {
                hql.appendWhere("< ?");
                break;
            }
            default: {
                hql.appendWhere(" = ?");
            }
        }
        hql.addParameterValue(restriction.getValue());
    }

    private String transformEntityToAlias(Entity entity) {
        switch (entity) {
            case USER: {
                return "usr";
            }
            case GROUP: {
                return "grp";
            }
            case TOKEN: {
                return "token";
            }
            case DIRECTORY: {
                return "directory";
            }
            case APPLICATION: {
                return "application";
            }
            case ALIAS: {
                return "alias";
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private String transformEntityToPersistedClass(Entity entity) {
        switch (entity) {
            case USER: {
                return InternalUser.class.getSimpleName();
            }
            case GROUP: {
                return InternalGroup.class.getSimpleName();
            }
            case TOKEN: {
                return Token.class.getSimpleName();
            }
            case DIRECTORY: {
                return Directory.class.getSimpleName();
            }
            case APPLICATION: {
                return Application.class.getSimpleName();
            }
            case ALIAS: {
                return Alias.class.getSimpleName();
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private String transormEntityToNameField(Entity entity) {
        switch (entity) {
            case USER: {
                return "lowerName";
            }
            case GROUP: {
                return "lowerName";
            }
            case TOKEN: {
                return "name";
            }
            case DIRECTORY: {
                return "lowerName";
            }
            case APPLICATION: {
                return "lowerName";
            }
            case ALIAS: {
                return "lowerName";
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private void appendSelectProjectionAsNames(HQLQuery hql, Entity entity) {
        hql.appendSelect(".name");
        if (entity == Entity.USER || entity == Entity.GROUP || entity == Entity.DIRECTORY || entity == Entity.APPLICATION || entity == Entity.ALIAS) {
            hql.appendSelect(", ").append(this.transformEntityToAlias(entity)).append(".lowerName");
        }
    }

    private void appendOrderByClause(HQLQuery hql, Entity entity) {
        hql.appendOrderBy(this.transformEntityToAlias(entity)).append(".").append(this.transormEntityToNameField(entity));
    }
}

