/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.principal;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.InternalDirectoryEntity;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.integration.model.user.InternalUserAttribute;
import com.atlassian.crowd.integration.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.model.membership.MembershipDAO;
import com.atlassian.crowd.model.principal.UserDAO;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOHibernate
extends HibernateDao
implements UserDAO {
    private DirectoryDAOHibernate directoryDAO;
    private MembershipDAO membershipDAO;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalAttributesHelper internalAttributesHelper;

    @Override
    public Class getPersistentClass() {
        return InternalUser.class;
    }

    public InternalUser findByName(final long directoryID, final String username) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(InternalUser.class).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryID)).add((Criterion)Expression.eq((String)"lowerName", (Object)username.toLowerCase())).uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)("name = " + username + ", directoryID = " + directoryID));
        }
        return (InternalUser)result;
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryID, String username) throws ObjectNotFoundException {
        InternalUser user = this.findByName(directoryID, username);
        List<InternalUserAttribute> attributesList = this.findUserAttributes(user.getId());
        Map<String, List<String>> attributesMap = this.internalAttributesHelper.attributesListToMap(attributesList);
        return new InternalUserWithAttributes(user, attributesMap);
    }

    public List<InternalUserAttribute> findUserAttributes(final long userID) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(InternalUserAttribute.class).add((Criterion)Expression.eq((String)"user.id", (Object)userID)).list();
            }
        });
    }

    public InternalUser add(User user, PasswordCredential credential) throws ObjectNotFoundException {
        InternalUser userToAdd = new InternalUser(user, this.getDirectory(user), credential);
        userToAdd.setCreatedDateToNow();
        userToAdd.setUpdatedDateToNow();
        super.save(userToAdd);
        return userToAdd;
    }

    private Directory getDirectory(User user) throws ObjectNotFoundException {
        Validate.notNull((Object)user.getDirectoryId(), (String)"Cannot add user with null directoryId");
        return (Directory)this.directoryDAO.load(user.getDirectoryId());
    }

    public InternalUser update(User user) throws ObjectNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateDetailsFrom(user);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
        return userToUpdate;
    }

    public InternalUser updateCredential(User user, PasswordCredential credential, int maxPasswordHistory) throws ObjectNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateCredentialTo(credential, maxPasswordHistory);
        userToUpdate.setUpdatedDateToNow();
        super.update(userToUpdate);
        return userToUpdate;
    }

    public InternalUser rename(User user, String newUsername) throws ObjectNotFoundException {
        InternalUser userToRename = this.findByName(user.getDirectoryId(), user.getName());
        String oldName = userToRename.getName();
        userToRename.renameTo(newUsername);
        userToRename.setUpdatedDateToNow();
        super.update(userToRename);
        this.membershipDAO.renameUserRelationships(userToRename.getDirectoryId().longValue(), oldName, userToRename.getName());
        return userToRename;
    }

    public void remove(User user) throws ObjectNotFoundException {
        final InternalUser userToRemove = this.findByName(user.getDirectoryId(), user.getName());
        this.membershipDAO.removeUserMemberships(user.getDirectoryId().longValue(), user.getName());
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllInternalUserAttributes").setEntity("user", (Object)userToRemove).executeUpdate();
            }
        });
        super.remove(userToRemove);
    }

    public void removeAll(final long directoryId) {
        this.membershipDAO.removeAllUserRelationships(directoryId);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("removeInternalUserAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
                session.getNamedQuery("removeCredentialRecordsInDirectory").setLong("directoryId", directoryId).executeUpdate();
                return session.getNamedQuery("removeInternalUsersInDirectory").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public void storeAttributes(User user, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        InternalUser internalUser = this.findByName(user.getDirectoryId(), user.getName());
        List<InternalUserAttribute> attributesList = this.findUserAttributes(internalUser.getId());
        HashMap<String, ArrayList<InternalUserAttribute>> existingAttributesMap = new HashMap<String, ArrayList<InternalUserAttribute>>();
        for (InternalUserAttribute internalUserAttribute : attributesList) {
            ArrayList<InternalUserAttribute> existingVals = (ArrayList<InternalUserAttribute>)existingAttributesMap.get(internalUserAttribute.getName());
            if (existingVals == null) {
                existingVals = new ArrayList<InternalUserAttribute>();
                existingAttributesMap.put(internalUserAttribute.getName(), existingVals);
            }
            existingVals.add(internalUserAttribute);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (existingAttributesMap.containsKey(entry.getKey())) {
                List newVals = (List)entry.getValue();
                List existingVals = (List)existingAttributesMap.get(entry.getKey());
                ArrayList<String> valsToAdd = new ArrayList<String>();
                HashSet valsToRemove = new HashSet(existingVals);
                for (String newVal : newVals) {
                    boolean valueAlreadyExists = false;
                    for (InternalUserAttribute existingVal : existingVals) {
                        if (!newVal.equals(existingVal.getValue())) continue;
                        valsToRemove.remove(existingVal);
                        valueAlreadyExists = true;
                        break;
                    }
                    if (valueAlreadyExists) continue;
                    valsToAdd.add(newVal);
                }
                for (InternalUserAttribute existingVal : valsToRemove) {
                    if (valsToAdd.size() > 0) {
                        String newVal = (String)valsToAdd.remove(0);
                        existingVal.setValue(newVal);
                        this.saveOrUpdate(existingVal);
                        continue;
                    }
                    this.remove(existingVal);
                }
                for (String newVal : valsToAdd) {
                    this.addAttribute(internalUser, (String)entry.getKey(), newVal);
                }
                continue;
            }
            for (String newVal : (List)entry.getValue()) {
                this.addAttribute(internalUser, (String)entry.getKey(), newVal);
            }
        }
    }

    private void addAttribute(InternalUser user, String attributeName, String attributeValue) {
        InternalUserAttribute attribute = new InternalUserAttribute(user, attributeName, attributeValue);
        this.getHibernateTemplate().save((Object)attribute);
    }

    public void removeAttribute(User user, String attributeName) throws ObjectNotFoundException {
        this.removeAttributes(this.findByName(user.getDirectoryId(), user.getName()), attributeName);
    }

    private void removeAttributes(final InternalUser user, final String attributeName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeInternalUserAttributes").setEntity("user", (Object)user).setString("attributeName", attributeName).executeUpdate();
            }
        });
    }

    public List search(final long directoryID, final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("UserDAO can only evaluate EntityQueries for Entity.USER");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = UserDAOHibernate.this.hqlQueryTranslater.asHQL(directoryID, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    public BatchResult<User> addAll(long directoryId, Set<UserTemplateWithCredentialAndAttributes> users) throws ObjectNotFoundException {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        Directory directory = this.directoryDAO.findById(directoryId);
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                InternalUser userToAdd = new InternalUser((User)user, directory, user.getCredential());
                userToAdd.setCreatedDateToNow();
                userToAdd.setUpdatedDateToNow();
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add user <" + user.getName() + ">: " + e.getMessage()));
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.merge(usersToAdd);
        BatchResult result = new BatchResult((long)users.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        return result;
    }

    public BatchResultWithIdReferences<User> addAll(Collection<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> usersToAdd = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                Directory directory = (Directory)this.directoryDAO.loadReference(user.getDirectoryId());
                InternalUser userToAdd = new InternalUser(user, directory);
                HashSet<InternalUserAttribute> attribs = new HashSet<InternalUserAttribute>();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        attribs.add(new InternalUserAttribute(userToAdd, (String)entry.getKey(), value));
                    }
                }
                usersToAdd.add(new TransactionGroup((Serializable)userToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add user <" + user.getName() + ">: " + e.getMessage()));
                usersFailedValidation.add(user);
            }
        }
        BatchResult daoResult = this.batchProcessor.merge(usersToAdd);
        BatchResultWithIdReferences result = new BatchResultWithIdReferences((long)users.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(usersFailedValidation);
        for (TransactionGroup user : usersToAdd) {
            result.addIdReference((InternalDirectoryEntity)user.getPrimaryObject());
        }
        return result;
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return this.batchProcessor.find(directoryID, usernames, InternalUser.class);
    }

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setMembershipDAO(MembershipDAO membershipDAO) {
        this.membershipDAO = membershipDAO;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setInternalAttributesHelper(InternalAttributesHelper internalAttributesHelper) {
        this.internalAttributesHelper = internalAttributesHelper;
    }
}

