/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.InternalDirectoryEntity;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.group.InternalGroupAttribute;
import com.atlassian.crowd.integration.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.model.InternalAttributesHelper;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.group.GroupDAO;
import com.atlassian.crowd.model.membership.MembershipDAO;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOHibernate
extends HibernateDao
implements GroupDAO {
    private DirectoryDAO directoryDAO;
    private MembershipDAO membershipDAO;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalAttributesHelper internalAttributesHelper;

    @Override
    public Class getPersistentClass() {
        return InternalGroup.class;
    }

    public InternalGroup findByName(final long directoryID, final String groupName) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(InternalGroup.class).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryID)).add((Criterion)Expression.eq((String)"lowerName", (Object)groupName.toLowerCase())).uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)("name <" + groupName + ">, directoryId <" + directoryID + ">"));
        }
        return (InternalGroup)result;
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryID, String groupName) throws ObjectNotFoundException {
        InternalGroup group = this.findByName(directoryID, groupName);
        List<InternalGroupAttribute> attributesList = this.findGroupAttributes(group.getId());
        Map<String, List<String>> attributesMap = this.internalAttributesHelper.attributesListToMap(attributesList);
        return new InternalGroupWithAttributes(group, attributesMap);
    }

    public List<InternalGroupAttribute> findGroupAttributes(final long groupId) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(InternalGroupAttribute.class).add((Criterion)Expression.eq((String)"group.id", (Object)groupId)).list();
            }
        });
    }

    public InternalGroup add(Group group) throws ObjectNotFoundException {
        InternalGroup groupToAdd = new InternalGroup(group, this.getDirectory(group));
        groupToAdd.setCreatedDateToNow();
        groupToAdd.setUpdatedDateToNow();
        super.save(groupToAdd);
        return groupToAdd;
    }

    private Directory getDirectory(Group group) throws ObjectNotFoundException {
        Validate.notNull((Object)group.getDirectoryId(), (String)"Cannot add a group with null directoryId");
        return (Directory)this.directoryDAO.load(group.getDirectoryId().longValue());
    }

    public InternalGroup update(Group group) throws ObjectNotFoundException {
        InternalGroup groupToUpdate = this.findByName(group.getDirectoryId(), group.getName());
        if (groupToUpdate.getType() != group.getType()) {
            throw new UnsupportedOperationException("Cannot modify the GroupType for an Internal group");
        }
        groupToUpdate.updateDetailsFrom(group);
        groupToUpdate.setUpdatedDateToNow();
        super.update(groupToUpdate);
        return groupToUpdate;
    }

    public InternalGroup rename(Group group, String newName) throws ObjectNotFoundException {
        InternalGroup groupToRename = this.findByName(group.getDirectoryId(), group.getName());
        String oldName = groupToRename.getName();
        groupToRename.renameTo(newName);
        groupToRename.setUpdatedDateToNow();
        super.update(groupToRename);
        this.membershipDAO.renameGroupRelationships(groupToRename.getDirectoryId().longValue(), oldName, groupToRename.getName());
        return groupToRename;
    }

    public void storeAttributes(Group group, Map<String, List<String>> attributes) throws ObjectNotFoundException {
        InternalGroupWithAttributes groupToUpdate = this.findByNameWithAttributes(group.getDirectoryId(), group.getName());
        for (String string : attributes.keySet()) {
            if (!groupToUpdate.hasAttribute(string)) continue;
            this.removeAttributes(groupToUpdate.getInternalGroup(), string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.addAttribute(groupToUpdate.getInternalGroup(), (String)entry.getKey(), value);
            }
        }
    }

    private void addAttribute(InternalGroup group, String attributeName, String attributeValue) {
        InternalGroupAttribute attribute = new InternalGroupAttribute(group, attributeName, attributeValue);
        this.getHibernateTemplate().save((Object)attribute);
    }

    public void removeAttribute(Group group, String attributeName) throws ObjectNotFoundException {
        this.removeAttributes(this.findByName(group.getDirectoryId(), group.getName()), attributeName);
    }

    private void removeAttributes(final InternalGroup group, final String attributeName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeInternalGroupAttributes").setEntity("group", (Object)group).setString("attributeName", attributeName).executeUpdate();
            }
        });
    }

    public void remove(Group group) throws ObjectNotFoundException {
        final InternalGroup groupToRemove = this.findByName(group.getDirectoryId(), group.getName());
        this.membershipDAO.removeGroupMembers(group.getDirectoryId().longValue(), group.getName());
        this.membershipDAO.removeGroupMemberships(group.getDirectoryId().longValue(), group.getName());
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllInternalGroupAttributes").setEntity("group", (Object)groupToRemove).executeUpdate();
            }
        });
        super.remove(groupToRemove);
    }

    public void removeAll(final long directoryId) {
        this.membershipDAO.removeAllRelationships(directoryId);
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("removeAllInternalGroupAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
                return session.getNamedQuery("removeAllGroupsInDirectory").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public List search(final long directoryID, final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("GroupDAO can only evaluate EntityQueries for Entity.GROUP");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = GroupDAOHibernate.this.hqlQueryTranslater.asHQL(directoryID, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    public BatchResult<Group> addAll(long directoryId, Set<GroupTemplate> groups) throws ObjectNotFoundException {
        HashSet<InternalGroup> groupsToAdd = new HashSet<InternalGroup>();
        HashSet<GroupTemplate> groupsFailedValidation = new HashSet<GroupTemplate>();
        Directory directory = this.directoryDAO.findById(directoryId);
        for (GroupTemplate group : groups) {
            try {
                InternalGroup groupToAdd = new InternalGroup((Group)group, directory);
                groupToAdd.setCreatedDateToNow();
                groupToAdd.setUpdatedDateToNow();
                groupsToAdd.add(groupToAdd);
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add group <" + group.getName() + ">: " + e.getMessage()));
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.merge(groupsToAdd);
        BatchResult result = new BatchResult((long)groups.size());
        result.addFailures((Collection)daoResult.getFailedEntities());
        result.addFailures(groupsFailedValidation);
        return result;
    }

    public BatchResultWithIdReferences<Group> addAll(Collection<InternalGroupWithAttributes> groups) {
        HashSet<TransactionGroup> groupsToAdd = new HashSet<TransactionGroup>();
        HashSet<InternalGroupWithAttributes> groupsFailedValidation = new HashSet<InternalGroupWithAttributes>();
        for (InternalGroupWithAttributes group : groups) {
            try {
                InternalGroup groupToAdd = group.getInternalGroup();
                HashSet<InternalGroupAttribute> attribs = new HashSet<InternalGroupAttribute>();
                for (String name : group.getAttributeNames()) {
                    for (String val : group.getAttributes(name)) {
                        InternalGroupAttribute attrib = new InternalGroupAttribute(groupToAdd, name, val);
                        attribs.add(attrib);
                    }
                }
                groupsToAdd.add(new TransactionGroup((Serializable)groupToAdd, attribs));
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Could not add group <" + group.getName() + ">: " + e.getMessage()));
                groupsFailedValidation.add(group);
            }
        }
        BatchResult daoResult = this.batchProcessor.merge(groupsToAdd);
        BatchResultWithIdReferences result = new BatchResultWithIdReferences((long)groups.size());
        for (TransactionGroup transactionGroup : daoResult.getFailedEntities()) {
            result.addFailure((Object)transactionGroup.getPrimaryObject());
        }
        result.addFailures(groupsFailedValidation);
        for (TransactionGroup group : groupsToAdd) {
            result.addIdReference((InternalDirectoryEntity)group.getPrimaryObject());
        }
        return result;
    }

    public Collection<InternalGroup> findByNames(long directoryID, Collection<String> groupnames) {
        return this.batchProcessor.find(directoryID, groupnames, InternalGroup.class);
    }

    public void setDirectoryDAO(DirectoryDAO directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void setMembershipDAO(MembershipDAO membershipDAO) {
        this.membershipDAO = membershipDAO;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setInternalAttributesHelper(InternalAttributesHelper internalAttributesHelper) {
        this.internalAttributesHelper = internalAttributesHelper;
    }
}

