/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.directory.monitor.DirectoryMonitorCreationException;
import com.atlassian.crowd.integration.directory.monitor.MonitorCapable;
import com.atlassian.crowd.integration.directory.monitor.listener.DirectoryListener;
import com.atlassian.crowd.integration.directory.monitor.listener.ListeningCapable;
import com.atlassian.crowd.integration.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.integration.directory.monitor.poller.PollingCapable;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorAlreadyRegisteredException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorManager;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.listener.DirectoryListenerManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class DirectoryMonitorManagerImpl
implements DirectoryMonitorManager,
EventListener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final DirectoryManager directoryManager;
    private final DirectoryListenerManager directoryListenerManager;
    private final DirectoryPollerManager directoryPollerManager;
    private final EventManager eventManager;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public DirectoryMonitorManagerImpl(DirectoryManager directoryManager, DirectoryListenerManager directoryListenerManager, DirectoryPollerManager directoryPollerManager, EventManager eventManager) {
        this.directoryManager = directoryManager;
        this.directoryListenerManager = directoryListenerManager;
        this.directoryPollerManager = directoryPollerManager;
        this.eventManager = eventManager;
        eventManager.registerListener(this.getClass().getCanonicalName(), (EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(long directoryID) throws ObjectNotFoundException, DirectoryInstantiationException, DirectoryMonitorCreationException, DirectoryMonitorRegistrationException, DirectoryMonitorAlreadyRegisteredException {
        block7: {
            this.logger.info((Object)("Attempting to add monitor for directory with id: " + directoryID));
            if (this.hasMonitor(directoryID)) {
                throw new DirectoryMonitorAlreadyRegisteredException("Remove existing monitor to add a monitor");
            }
            this.readWriteLock.writeLock().lock();
            try {
                Directory directory = this.directoryManager.findDirectoryById(directoryID);
                RemoteDirectory remoteDirectory = directory.getRawImplementation();
                if (remoteDirectory instanceof MonitorCapable) {
                    if (remoteDirectory instanceof PollingCapable) {
                        this.logger.info((Object)"Directory is PollingCapable. Adding poller.");
                        DirectoryPoller poller = ((PollingCapable)remoteDirectory).getDirectoryMonitor();
                        this.directoryPollerManager.addPoller(poller);
                        break block7;
                    }
                    if (remoteDirectory instanceof ListeningCapable) {
                        this.logger.info((Object)"Directory is ListenerCabable. Adding listener.");
                        DirectoryListener listener = ((ListeningCapable)remoteDirectory).getDirectoryMonitor();
                        this.directoryListenerManager.addListener(listener);
                        break block7;
                    }
                    this.logger.info((Object)"Directory is not PollingCapable or ListeningCable");
                    throw new DirectoryMonitorCreationException("Directory is not PollingCapable or ListeningCable");
                }
                this.logger.info((Object)"Directory is not MonitorCapable");
                throw new DirectoryMonitorCreationException("Directory is not MonitorCapable");
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitor(long directoryID) throws DirectoryMonitorUnregistrationException {
        this.logger.info((Object)("Attempting to remove monitor for directory with id: " + directoryID));
        this.readWriteLock.writeLock().lock();
        try {
            if (this.directoryPollerManager.hasPoller(directoryID)) {
                this.logger.info((Object)"Directory is registered with a poller, removing poller");
                boolean bl = this.directoryPollerManager.removePoller(directoryID);
                return bl;
            }
            if (this.directoryListenerManager.hasListener(directoryID)) {
                this.logger.info((Object)"Directory is registered with a listener, removing listener");
                boolean bl = this.directoryListenerManager.removeListener(directoryID);
                return bl;
            }
            this.logger.info((Object)"Directory is not registered with a poller or listener");
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMonitor(long directoryID) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.directoryPollerManager.hasPoller(directoryID) || this.directoryListenerManager.hasListener(directoryID);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllMonitors() {
        this.readWriteLock.writeLock().lock();
        try {
            this.directoryListenerManager.removeAllListeners();
            this.directoryPollerManager.removeAllPollers();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void handleEvent(Event event) {
        if (event instanceof DirectoryEvent) {
            long directoryID = ((DirectoryEvent)event).getDirectory().getId();
            try {
                if (this.hasMonitor(directoryID)) {
                    this.removeMonitor(directoryID);
                }
            }
            catch (DirectoryMonitorUnregistrationException e) {
                this.logger.error((Object)("Unable to remove monitor for directory with ID: " + directoryID));
            }
        } else if (event instanceof XMLRestoreFinishedEvent) {
            this.removeAllMonitors();
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{DirectoryUpdatedEvent.class, DirectoryDeletedEvent.class, XMLRestoreFinishedEvent.class};
    }
}

