/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.cache;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.integration.directory.cache.DirectoryCache;
import com.atlassian.crowd.integration.directory.cache.LDAPDirectoryCache;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.cache.DirectoryCacheManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;

public class DirectoryCacheManagerImpl
implements DirectoryCacheManager,
EventListener {
    private static final Class DEFAULT_CACHE_CLASS = LDAPDirectoryCache.class;
    private static final int DEFAULT_CACHE_MAX_ELEMENTS = 50000;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final CacheManager ehcacheManager;
    private final EventManager eventManager;
    private final DirectoryManager directoryManager;
    private final ReadWriteLock readWriteLock;
    private final Map<Long, DirectoryCache> cacheMap;

    public DirectoryCacheManagerImpl(CacheManager ehcacheManager, EventManager eventManager, DirectoryManager directoryManager) {
        this.ehcacheManager = ehcacheManager;
        this.eventManager = eventManager;
        this.directoryManager = directoryManager;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.cacheMap = new HashMap<Long, DirectoryCache>();
        eventManager.registerListener(this.getClass().getCanonicalName(), (EventListener)this);
    }

    public DirectoryCache getCache(long directoryID) throws InstantiationException {
        DirectoryCache cache = this.getExistingCache(directoryID);
        if (cache == null) {
            cache = this.createCacheAndRegisterListenerIfRequired(directoryID);
        }
        return cache;
    }

    public void removeCache(long directoryID) {
        this.unregisterListenerAndRemoveCacheIfPresent(directoryID);
    }

    public boolean hasCache(long directoryID) {
        DirectoryCache cache = this.getExistingCache(directoryID);
        return cache != null;
    }

    public DirectoryCache resetCache(long directoryID) throws InstantiationException {
        return this.clearExistingOrInitialiseNewCache(directoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectoryCache getExistingCache(long directoryID) {
        this.readWriteLock.readLock().lock();
        try {
            DirectoryCache directoryCache = this.cacheMap.get(directoryID);
            return directoryCache;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectoryCache createCacheAndRegisterListenerIfRequired(long directoryID) throws InstantiationException {
        this.readWriteLock.writeLock().lock();
        try {
            DirectoryCache cache = this.cacheMap.get(directoryID);
            if (cache == null) {
                cache = this.instantiateCache(directoryID);
                this.eventManager.registerListener(this.getListenerName(directoryID), (EventListener)cache);
                this.cacheMap.put(directoryID, cache);
            }
            DirectoryCache directoryCache = cache;
            return directoryCache;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListenerAndRemoveCacheIfPresent(long directoryID) {
        this.readWriteLock.writeLock().lock();
        try {
            DirectoryCache cache = this.cacheMap.get(directoryID);
            if (cache != null) {
                this.eventManager.unregisterListener(this.getListenerName(directoryID));
                cache.clear();
                cache.close();
                this.cacheMap.remove(directoryID);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectoryCache clearExistingOrInitialiseNewCache(long directoryID) throws InstantiationException {
        this.readWriteLock.writeLock().lock();
        try {
            DirectoryCache cache = this.cacheMap.get(directoryID);
            if (cache != null) {
                cache.clear();
                DirectoryCache directoryCache = cache;
                return directoryCache;
            }
            DirectoryCache directoryCache = this.createCacheAndRegisterListenerIfRequired(directoryID);
            return directoryCache;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected DirectoryCache instantiateCache(long directoryID) throws InstantiationException {
        Class cacheClass = null;
        try {
            Directory directory = this.directoryManager.findDirectoryById(directoryID);
            String cacheClassName = directory.getAttribute("cacheClass");
            cacheClass = cacheClassName != null ? ClassLoaderUtils.loadClass((String)cacheClassName, this.getClass()) : DEFAULT_CACHE_CLASS;
            int cacheMaxElements = 0;
            String cacheMaxElementsString = directory.getAttribute("cacheMaxElements");
            if (cacheMaxElementsString != null) {
                try {
                    cacheMaxElements = Integer.valueOf(cacheMaxElementsString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (cacheMaxElements <= 0) {
                cacheMaxElements = 50000;
            }
            Constructor constructor = cacheClass.getConstructor(Long.TYPE, CacheManager.class, Integer.TYPE);
            Object object = constructor.newInstance(directoryID, this.ehcacheManager, cacheMaxElements);
            return (DirectoryCache)object;
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to instantiate cache of class " + cacheClass + " for directory with ID: " + directoryID), (Throwable)e);
            throw new InstantiationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllCaches() {
        this.readWriteLock.writeLock().lock();
        try {
            ArrayList<Long> directoryIDs = new ArrayList<Long>(this.cacheMap.keySet());
            for (Long directoryID : directoryIDs) {
                this.removeCache(directoryID);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected String getListenerName(long directoryID) {
        return new StringBuffer(this.getClass().getCanonicalName()).append(directoryID).toString();
    }

    public void handleEvent(Event event) {
        if (event instanceof DirectoryEvent) {
            long directoryID = ((DirectoryEvent)event).getDirectory().getId();
            this.removeCache(directoryID);
        } else if (event instanceof XMLRestoreFinishedEvent) {
            this.removeAllCaches();
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{DirectoryUpdatedEvent.class, DirectoryDeletedEvent.class, XMLRestoreFinishedEvent.class};
    }
}

