/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.alias.AliasDAO;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.List;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasManagerImpl
implements AliasManager {
    private final AliasDAO aliasDAO;
    private ApplicationService applicationService;

    public AliasManagerImpl(AliasDAO aliasDAO, ApplicationService applicationService) {
        this.aliasDAO = aliasDAO;
        this.applicationService = applicationService;
    }

    public String findUsernameByAlias(Application application, String authenticatingUsername) {
        String realusername;
        Validate.notNull((Object)application);
        Validate.notNull((Object)authenticatingUsername);
        if (application.isAliasingEnabled() && (realusername = this.aliasDAO.findUsernameByAlias(application, authenticatingUsername)) != null) {
            return realusername;
        }
        return authenticatingUsername;
    }

    public String findAliasByUsername(Application application, String username) {
        String alias;
        Validate.notNull((Object)application);
        Validate.notNull((Object)username);
        if (application.isAliasingEnabled() && (alias = this.aliasDAO.findAliasByUsername(application, username)) != null) {
            return alias;
        }
        return username;
    }

    public void storeAlias(Application application, String username, String alias) throws AliasAlreadyInUseException, DirectoryAccessException {
        Validate.notNull((Object)username);
        Validate.notNull((Object)alias);
        String userWithAlias = this.aliasDAO.findUsernameByAlias(application, alias);
        if (userWithAlias != null) {
            if (userWithAlias.equals(username)) {
                return;
            }
            throw new AliasAlreadyInUseException(application.getName(), alias, userWithAlias);
        }
        try {
            User user = this.applicationService.findUserByName(application, alias);
            String aliasForUserWithSameNameAsDesiredAlias = this.aliasDAO.findAliasByUsername(application, user.getName());
            if (aliasForUserWithSameNameAsDesiredAlias == null) {
                throw new AliasAlreadyInUseException(application.getName(), alias, user.getName());
            }
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        this.aliasDAO.storeAlias(application, username, alias);
    }

    public void removeAlias(Application application, String username) throws AliasAlreadyInUseException {
        String userWithUsernameAsAlias = this.aliasDAO.findUsernameByAlias(application, username);
        if (userWithUsernameAsAlias != null) {
            throw new AliasAlreadyInUseException(application.getName(), username, userWithUsernameAsAlias);
        }
        this.aliasDAO.removeAlias(application, username);
    }

    public List<String> search(EntityQuery entityQuery) {
        return this.aliasDAO.search(entityQuery);
    }
}

