/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.monitor.listener;

import com.atlassian.crowd.event.remote.group.RemoteGroupCreatedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupDeletedEvent;
import com.atlassian.crowd.event.remote.group.RemoteGroupUpdatedEvent;
import com.atlassian.crowd.integration.directory.connector.LDAPDirectory;
import com.atlassian.crowd.integration.directory.monitor.listener.ChangeListener;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import javax.naming.Name;
import org.springframework.ldap.core.ContextMapper;

public class GroupChangeListener
extends ChangeListener {
    public GroupChangeListener(LDAPDirectory remoteDirectory, Name baseDN, String objectFilter, ContextMapper mapper, EventManager eventManager, boolean lookupUpdates) {
        super(remoteDirectory, baseDN, objectFilter, mapper, eventManager, lookupUpdates);
    }

    protected void publishEntityCreatedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteGroupCreatedEvent((Object)this, this.getDirectoryID(), (Group)entity));
    }

    protected void publishEntityUpdatedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteGroupUpdatedEvent((Object)this, this.getDirectoryID(), (Group)entity));
    }

    protected void publishEntityDeletedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteGroupDeletedEvent((Object)this, this.getDirectoryID(), ((Group)entity).getName()));
    }

    protected Object lookupEntity(String dn) {
        try {
            return this.remoteDirectory.findEntityByDN(dn, LDAPGroupWithAttributes.class);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }
}

