/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.delegated;

import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.directory.connector.SpringLDAPConnector;
import com.atlassian.crowd.integration.directory.internal.InternalDirectory;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.directory.DirectoryInstanceLoader;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedAuthenticationDirectory
extends InternalDirectory {
    public static final String DELEGATED_DIRECTORY_TYPE = "crowd.delegated.directory.type";
    private static final String DEFAULT_INTERNAL_PASSWORD = "password";
    private DirectoryInstanceLoader directoryInstanceLoader;
    private EventManager eventManager;
    private DirectoryDAO directoryDAO;

    @Override
    public User authenticate(String name, PasswordCredential credential) throws ObjectNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException {
        User user;
        RemoteDirectory directory = null;
        try {
            directory = this.getDelegatedDirectory();
        }
        catch (DirectoryInstantiationException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
        try {
            user = this.findUserByName(name);
            if (user == null || !user.isActive()) {
                throw new InactiveAccountException(user);
            }
            directory.authenticate(name, credential);
        }
        catch (ObjectNotFoundException e) {
            user = directory.authenticate(name, credential);
            try {
                UserTemplate template = new UserTemplate(user.getName(), user.getDirectoryId());
                template.setActive(user.isActive());
                template.setDisplayName(user.getDisplayName());
                template.setFirstName(user.getFirstName());
                template.setLastName(user.getLastName());
                template.setEmailAddress(user.getEmailAddress());
                template.setIconLocation(user.getIconLocation());
                User createdUser = this.addUser(template, new PasswordCredential(DEFAULT_INTERNAL_PASSWORD, true));
                Directory dir = this.directoryDAO.findById(createdUser.getDirectoryId().longValue());
                this.eventManager.publishEvent((Event)new UserCreatedEvent((Object)this, dir, createdUser));
            }
            catch (InvalidCredentialException e1) {
                this.logger.error((Object)("Could not create authenticated user <" + user.getName() + "> in underlying InternalDirectory: " + e1.getMessage()), (Throwable)e1);
                throw new InvalidAuthenticationException(e1.getMessage(), (Throwable)e1);
            }
            catch (InvalidUserException e1) {
                this.logger.error((Object)("Could not create authenticated user <" + user.getName() + "> in underlying InternalDirectory: " + e1.getMessage()), (Throwable)e1);
                throw new InvalidAuthenticationException(e1.getMessage(), (Throwable)e1);
            }
            user = this.findUserByName(name);
        }
        return user;
    }

    @Override
    protected PasswordEncoder getEncoder() {
        return this.passwordEncoderFactory.getEncoder("plaintext");
    }

    @Override
    public void updateUserCredential(String userName, PasswordCredential credential) throws ObjectNotFoundException, InvalidCredentialException {
    }

    @Override
    public void testConnection() throws DirectoryAccessException {
        try {
            RemoteDirectory directoryImpl = this.getDelegatedDirectory();
            SpringLDAPConnector ldapConnector = (SpringLDAPConnector)directoryImpl;
            ldapConnector.testConnection();
        }
        catch (Exception e) {
            throw new DirectoryAccessException("Failed to connect", (Throwable)e);
        }
    }

    protected void encryptCredentials(List credentials) {
        credentials.clear();
    }

    protected void validateRegex(PasswordCredential credential) throws InvalidCredentialException {
    }

    protected RemoteDirectory getDelegatedDirectory() throws DirectoryInstantiationException {
        String directoryType = this.getAttribute(DELEGATED_DIRECTORY_TYPE);
        RemoteDirectory directory = this.directoryInstanceLoader.getDirectory(directoryType, this.attributes.getAttributes(), Long.valueOf(this.getDirectoryId()));
        return directory;
    }

    public List<String> testUserSearch() throws DirectoryInstantiationException {
        return this.getDelegatedDirectory().searchUsers(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).returningAtMost(10).asNames());
    }

    @Override
    public String getDescriptiveName() {
        return this.i18nHelper.getText("directory.delegating.type.name");
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void setDirectoryDAO(DirectoryDAO directoryDAO) {
        this.directoryDAO = directoryDAO;
    }
}

