/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.validator;

import com.atlassian.crowd.integration.directory.connector.validator.Validator;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.util.I18nHelper;
import org.apache.commons.lang.StringUtils;

public class GroupRoleDnOverlapValidator
implements Validator {
    private final I18nHelper i18nHelper;

    public GroupRoleDnOverlapValidator(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public String getError(Directory directory) {
        String groupDN;
        String roleDN;
        boolean rolesDisabled = Boolean.parseBoolean(directory.getAttribute("ldap.roles.disabled"));
        DirectoryType directoryType = directory.getType();
        if (!rolesDisabled && DirectoryType.CONNECTOR.equals((Object)directoryType) && this.isDNConfigOverlapping(roleDN = directory.getAttribute("ldap.role.dn"), groupDN = directory.getAttribute("ldap.group.dn"))) {
            return this.i18nHelper.getText("directoryconnector.rolednaddition.invalid");
        }
        return null;
    }

    public boolean isDNConfigOverlapping(String roleDN, String groupDN) {
        if (StringUtils.isBlank((String)roleDN) || StringUtils.isBlank((String)groupDN)) {
            return true;
        }
        return StringUtils.startsWith((String)(roleDN = roleDN + ","), (String)(groupDN = groupDN + ",")) || StringUtils.startsWith((String)groupDN, (String)roleDN);
    }
}

