/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.name;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.name.Converter;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import javax.naming.CompositeName;
import javax.naming.Name;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchDN {
    protected final Logger logger = Logger.getLogger(this.getClass());
    LDAPPropertiesMapper propertiesMapper;
    Converter converter;

    public SearchDN(LDAPPropertiesMapper propertiesMapper, Converter converter) {
        this.propertiesMapper = propertiesMapper;
        this.converter = converter;
    }

    public Name getGroup() {
        try {
            return this.getSearchDN("ldap.group.dn");
        }
        catch (ObjectNotFoundException e) {
            this.logger.error((Object)"Group Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getRole() {
        try {
            return this.getSearchDN("ldap.role.dn");
        }
        catch (ObjectNotFoundException e) {
            this.logger.error((Object)"Role Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getUser() {
        try {
            return this.getSearchDN("ldap.user.dn");
        }
        catch (ObjectNotFoundException e) {
            this.logger.error((Object)"User Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getBase() throws ObjectNotFoundException {
        return this.converter.getName(this.propertiesMapper.getAttribute("ldap.basedn"));
    }

    public Name getNamingContext() {
        Name baseDN;
        try {
            baseDN = this.getBase();
        }
        catch (ObjectNotFoundException e) {
            baseDN = new CompositeName();
        }
        return baseDN;
    }

    protected Name getSearchDN(String propertyName) throws ObjectNotFoundException {
        String searchDN = "";
        String additionalDN = this.propertiesMapper.getAttribute(propertyName);
        if (StringUtils.isNotBlank((String)additionalDN)) {
            searchDN = additionalDN + ",";
        }
        searchDN = searchDN + this.propertiesMapper.getAttribute("ldap.basedn");
        return this.converter.getName(searchDN);
    }
}

