/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.name;

import com.atlassian.crowd.integration.directory.connector.name.Converter;
import com.atlassian.crowd.integration.directory.connector.name.Encoder;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class GenericConverter
implements Converter {
    Encoder encoder;

    public GenericConverter(Encoder encoder) {
        this.encoder = encoder;
    }

    public Name getName(String dn) throws ObjectNotFoundException {
        String escapedDn = this.encoder.dnEncode(dn);
        try {
            return new CompositeName(escapedDn);
        }
        catch (InvalidNameException e) {
            throw new ObjectNotFoundException((Throwable)e);
        }
    }

    public Name getName(String attributeName, String objectName, Name baseDN) throws ObjectNotFoundException {
        String dn = attributeName + "=" + this.encoder.nameEncode(objectName) + ", " + baseDN;
        try {
            return new CompositeName(dn);
        }
        catch (InvalidNameException e) {
            throw new ObjectNotFoundException((Throwable)e);
        }
    }
}

