/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.entity;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.util.DirectoryAttributeRetriever;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplateWithAttributes;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.UncategorizedLdapException;

public class LDAPUserAttributesMapper {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final LDAPPropertiesMapper ldapPropertiesMapper;
    protected final long directoryId;

    public LDAPUserAttributesMapper(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper) {
        this.directoryId = directoryId;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        return this.mapUserFromAttributes(attributes);
    }

    public Attributes mapAttributesFromUser(User user) throws NamingException {
        if (user == null) {
            throw new UncategorizedLdapException("Cannot map attributes from a null User");
        }
        BasicAttributes directoryAttributes = new BasicAttributes(true);
        directoryAttributes.put(new BasicAttribute(this.ldapPropertiesMapper.getObjectClassAttribute(), this.ldapPropertiesMapper.getUserObjectClass()));
        this.putValueInAttributes(user.getName(), this.ldapPropertiesMapper.getUserNameAttribute(), directoryAttributes);
        this.putValueInAttributes(user.getEmailAddress(), this.ldapPropertiesMapper.getUserEmailAttribute(), directoryAttributes);
        this.putValueInAttributes(user.getFirstName(), this.ldapPropertiesMapper.getUserFirstNameAttribute(), directoryAttributes);
        this.putValueInAttributes(user.getLastName(), this.ldapPropertiesMapper.getUserLastNameAttribute(), directoryAttributes);
        String displayName = user.getDisplayName();
        if (user.getDisplayName() == null) {
            String firstName = StringUtils.defaultString((String)user.getFirstName());
            String lastName = StringUtils.defaultString((String)user.getLastName());
            displayName = firstName + " " + lastName;
        }
        this.putValueInAttributes(displayName, this.ldapPropertiesMapper.getUserDisplayNameAttribute(), directoryAttributes);
        return directoryAttributes;
    }

    public UserTemplateWithAttributes mapUserFromAttributes(Attributes directoryAttributes) throws NamingException {
        if (directoryAttributes == null) {
            throw new UncategorizedLdapException("Cannot map from null attributes");
        }
        String username = this.getUsernameFromAttributes(directoryAttributes);
        UserTemplateWithAttributes user = new UserTemplateWithAttributes(username, Long.valueOf(this.directoryId));
        user.setActive(this.getUserActiveFromAttribute(directoryAttributes));
        user.setEmailAddress(this.getUserEmailFromAttribute(directoryAttributes));
        user.setFirstName(this.getUserFirstNameFromAttribute(directoryAttributes));
        user.setLastName(this.getUserLastNameFromAttribute(directoryAttributes));
        user.setDisplayName(this.getUserDisplayNameFromAttribute(directoryAttributes));
        return user;
    }

    protected String getUserDisplayNameFromAttribute(Attributes directoryAttributes) {
        return DirectoryAttributeRetriever.getValueFromAttributes(this.ldapPropertiesMapper.getUserDisplayNameAttribute(), directoryAttributes);
    }

    protected String getUserLastNameFromAttribute(Attributes directoryAttributes) {
        return DirectoryAttributeRetriever.getValueFromAttributes(this.ldapPropertiesMapper.getUserLastNameAttribute(), directoryAttributes);
    }

    protected String getUserFirstNameFromAttribute(Attributes directoryAttributes) {
        return DirectoryAttributeRetriever.getValueFromAttributes(this.ldapPropertiesMapper.getUserFirstNameAttribute(), directoryAttributes);
    }

    protected String getUserEmailFromAttribute(Attributes directoryAttributes) {
        return DirectoryAttributeRetriever.getValueFromAttributes(this.ldapPropertiesMapper.getUserEmailAttribute(), directoryAttributes);
    }

    protected boolean getUserActiveFromAttribute(Attributes directoryAttributes) {
        return true;
    }

    private void putValueInAttributes(String userAttributeValue, String directoryAttributeName, Attributes directoryAttributes) {
        if (userAttributeValue != null && StringUtils.isNotEmpty((String)userAttributeValue)) {
            directoryAttributes.put(new BasicAttribute(directoryAttributeName, userAttributeValue));
        }
    }

    protected String getUsernameFromAttributes(Attributes directoryAttributes) throws NamingException {
        String username = DirectoryAttributeRetriever.getValueFromAttributes(this.ldapPropertiesMapper.getUserNameAttribute(), directoryAttributes);
        if (username == null) {
            this.logger.fatal((Object)("The following record does not have a username: " + directoryAttributes.toString()));
            throw new UncategorizedLdapException("Unable to find the username of the principal.");
        }
        return username;
    }
}

