/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.entity;

import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.connector.util.DirectoryAttributeRetriever;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.integration.model.group.GroupType;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.UncategorizedLdapException;

public class LDAPGroupAttributesMapper {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final long directoryId;
    protected final GroupType groupType;
    protected final String objectClassAttribute;
    protected final String objectClassValue;
    protected final String nameAttribute;
    protected final String descriptionAttribute;

    public LDAPGroupAttributesMapper(long directoryId, GroupType groupType, LDAPPropertiesMapper ldapPropertiesMapper) {
        this.directoryId = directoryId;
        this.groupType = groupType;
        this.objectClassAttribute = ldapPropertiesMapper.getObjectClassAttribute();
        switch (this.groupType) {
            case GROUP: {
                this.objectClassValue = ldapPropertiesMapper.getGroupObjectClass();
                this.nameAttribute = ldapPropertiesMapper.getGroupNameAttribute();
                this.descriptionAttribute = ldapPropertiesMapper.getGroupDescriptionAttribute();
                break;
            }
            case LEGACY_ROLE: {
                this.objectClassValue = ldapPropertiesMapper.getRoleObjectClass();
                this.nameAttribute = ldapPropertiesMapper.getRoleNameAttribute();
                this.descriptionAttribute = ldapPropertiesMapper.getRoleDescriptionAttribute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create LDAPGroupAttributesMapper for groupType: " + groupType);
            }
        }
    }

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        return this.mapGroupFromAttributes(attributes);
    }

    public Attributes mapAttributesFromGroup(Group group) throws NamingException {
        if (group == null) {
            throw new UncategorizedLdapException("Cannot map attributes from a null Group");
        }
        BasicAttributes directoryAttributes = new BasicAttributes(true);
        directoryAttributes.put(new BasicAttribute(this.objectClassAttribute, this.objectClassValue));
        this.putValueInAttributes(group.getName(), this.nameAttribute, directoryAttributes);
        if (group.getDescription() != null && StringUtils.isNotBlank((String)this.descriptionAttribute)) {
            this.putValueInAttributes(group.getDescription(), this.descriptionAttribute, directoryAttributes);
        }
        return directoryAttributes;
    }

    public GroupTemplateWithAttributes mapGroupFromAttributes(Attributes directoryAttributes) throws NamingException {
        if (directoryAttributes == null) {
            throw new UncategorizedLdapException("Cannot map from null attributes");
        }
        String groupname = this.getGroupNameFromAttributes(directoryAttributes);
        GroupTemplateWithAttributes group = new GroupTemplateWithAttributes(groupname, Long.valueOf(this.directoryId), this.groupType);
        group.setActive(this.getGroupActiveFromAttribute(directoryAttributes));
        group.setDescription(this.getGroupDescriptionFromAttribute(directoryAttributes));
        return group;
    }

    protected String getGroupDescriptionFromAttribute(Attributes directoryAttributes) {
        return DirectoryAttributeRetriever.getValueFromAttributes(this.descriptionAttribute, directoryAttributes);
    }

    protected boolean getGroupActiveFromAttribute(Attributes directoryAttributes) {
        return true;
    }

    private void putValueInAttributes(String groupAttributeValue, String directoryAttributeName, Attributes directoryAttributes) {
        if (groupAttributeValue != null) {
            directoryAttributes.put(new BasicAttribute(directoryAttributeName, groupAttributeValue));
        }
    }

    protected String getGroupNameFromAttributes(Attributes directoryAttributes) throws NamingException {
        String groupname = DirectoryAttributeRetriever.getValueFromAttributes(this.nameAttribute, directoryAttributes);
        if (groupname == null) {
            this.logger.fatal((Object)("The following record does not have a groupname: " + directoryAttributes.toString()));
            throw new UncategorizedLdapException("Unable to find the groupname of the principal.");
        }
        return groupname;
    }
}

