/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.attribute.user;

import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.util.connector.DNStandardiser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.ldap.core.DirContextAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberOfOverlayMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberOf";
    private final String userMemberOfAttribute;
    private final boolean relaxedDnStandardisation;

    public MemberOfOverlayMapper(String userMemberOfAttribute, boolean relaxedDnStandardisation) {
        this.userMemberOfAttribute = userMemberOfAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public List<String> getValues(DirContextAdapter ctx) throws Exception {
        String[] memberships = ctx.getStringAttributes(this.userMemberOfAttribute);
        if (memberships != null) {
            ArrayList<String> standardDNs = new ArrayList<String>(memberships.length);
            for (String memberDN : memberships) {
                String dn = DNStandardiser.standardise(memberDN, !this.relaxedDnStandardisation);
                standardDNs.add(dn);
            }
            return standardDNs;
        }
        return Collections.emptyList();
    }
}

