/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.attribute;

import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.springframework.ldap.core.DirContextAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGUIDMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "objectGUID";

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public List<String> getValues(DirContextAdapter ctx) throws NamingException {
        byte[] guidBytes = (byte[])ctx.getAttributes().get(this.getKey()).get();
        return Arrays.asList(this.getGUIDAsString(guidBytes));
    }

    private String getGUIDAsString(byte[] inArr) {
        StringBuffer guid = new StringBuffer();
        for (int i = 0; i < inArr.length; ++i) {
            StringBuffer dblByte = new StringBuffer(Integer.toHexString(inArr[i] & 0xFF));
            if (dblByte.length() == 1) {
                guid.append("0");
            }
            guid.append(dblByte);
        }
        return guid.toString();
    }
}

